"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RaftSnapshotAgentConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config vault_raft_snapshot_agent_config}
*/
class RaftSnapshotAgentConfig extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config vault_raft_snapshot_agent_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RaftSnapshotAgentConfigConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_raft_snapshot_agent_config',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.7.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._awsAccessKeyId = config.awsAccessKeyId;
        this._awsS3Bucket = config.awsS3Bucket;
        this._awsS3DisableTls = config.awsS3DisableTls;
        this._awsS3EnableKms = config.awsS3EnableKms;
        this._awsS3Endpoint = config.awsS3Endpoint;
        this._awsS3ForcePathStyle = config.awsS3ForcePathStyle;
        this._awsS3KmsKey = config.awsS3KmsKey;
        this._awsS3Region = config.awsS3Region;
        this._awsS3ServerSideEncryption = config.awsS3ServerSideEncryption;
        this._awsSecretAccessKey = config.awsSecretAccessKey;
        this._awsSessionToken = config.awsSessionToken;
        this._azureAccountKey = config.azureAccountKey;
        this._azureAccountName = config.azureAccountName;
        this._azureBlobEnvironment = config.azureBlobEnvironment;
        this._azureContainerName = config.azureContainerName;
        this._azureEndpoint = config.azureEndpoint;
        this._filePrefix = config.filePrefix;
        this._googleDisableTls = config.googleDisableTls;
        this._googleEndpoint = config.googleEndpoint;
        this._googleGcsBucket = config.googleGcsBucket;
        this._googleServiceAccountKey = config.googleServiceAccountKey;
        this._id = config.id;
        this._intervalSeconds = config.intervalSeconds;
        this._localMaxSpace = config.localMaxSpace;
        this._name = config.name;
        this._namespace = config.namespace;
        this._pathPrefix = config.pathPrefix;
        this._retain = config.retain;
        this._storageType = config.storageType;
    }
    get awsAccessKeyId() {
        return this.getStringAttribute('aws_access_key_id');
    }
    set awsAccessKeyId(value) {
        this._awsAccessKeyId = value;
    }
    resetAwsAccessKeyId() {
        this._awsAccessKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsAccessKeyIdInput() {
        return this._awsAccessKeyId;
    }
    get awsS3Bucket() {
        return this.getStringAttribute('aws_s3_bucket');
    }
    set awsS3Bucket(value) {
        this._awsS3Bucket = value;
    }
    resetAwsS3Bucket() {
        this._awsS3Bucket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3BucketInput() {
        return this._awsS3Bucket;
    }
    get awsS3DisableTls() {
        return this.getBooleanAttribute('aws_s3_disable_tls');
    }
    set awsS3DisableTls(value) {
        this._awsS3DisableTls = value;
    }
    resetAwsS3DisableTls() {
        this._awsS3DisableTls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3DisableTlsInput() {
        return this._awsS3DisableTls;
    }
    get awsS3EnableKms() {
        return this.getBooleanAttribute('aws_s3_enable_kms');
    }
    set awsS3EnableKms(value) {
        this._awsS3EnableKms = value;
    }
    resetAwsS3EnableKms() {
        this._awsS3EnableKms = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3EnableKmsInput() {
        return this._awsS3EnableKms;
    }
    get awsS3Endpoint() {
        return this.getStringAttribute('aws_s3_endpoint');
    }
    set awsS3Endpoint(value) {
        this._awsS3Endpoint = value;
    }
    resetAwsS3Endpoint() {
        this._awsS3Endpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3EndpointInput() {
        return this._awsS3Endpoint;
    }
    get awsS3ForcePathStyle() {
        return this.getBooleanAttribute('aws_s3_force_path_style');
    }
    set awsS3ForcePathStyle(value) {
        this._awsS3ForcePathStyle = value;
    }
    resetAwsS3ForcePathStyle() {
        this._awsS3ForcePathStyle = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3ForcePathStyleInput() {
        return this._awsS3ForcePathStyle;
    }
    get awsS3KmsKey() {
        return this.getStringAttribute('aws_s3_kms_key');
    }
    set awsS3KmsKey(value) {
        this._awsS3KmsKey = value;
    }
    resetAwsS3KmsKey() {
        this._awsS3KmsKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3KmsKeyInput() {
        return this._awsS3KmsKey;
    }
    get awsS3Region() {
        return this.getStringAttribute('aws_s3_region');
    }
    set awsS3Region(value) {
        this._awsS3Region = value;
    }
    resetAwsS3Region() {
        this._awsS3Region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3RegionInput() {
        return this._awsS3Region;
    }
    get awsS3ServerSideEncryption() {
        return this.getBooleanAttribute('aws_s3_server_side_encryption');
    }
    set awsS3ServerSideEncryption(value) {
        this._awsS3ServerSideEncryption = value;
    }
    resetAwsS3ServerSideEncryption() {
        this._awsS3ServerSideEncryption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3ServerSideEncryptionInput() {
        return this._awsS3ServerSideEncryption;
    }
    get awsSecretAccessKey() {
        return this.getStringAttribute('aws_secret_access_key');
    }
    set awsSecretAccessKey(value) {
        this._awsSecretAccessKey = value;
    }
    resetAwsSecretAccessKey() {
        this._awsSecretAccessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsSecretAccessKeyInput() {
        return this._awsSecretAccessKey;
    }
    get awsSessionToken() {
        return this.getStringAttribute('aws_session_token');
    }
    set awsSessionToken(value) {
        this._awsSessionToken = value;
    }
    resetAwsSessionToken() {
        this._awsSessionToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsSessionTokenInput() {
        return this._awsSessionToken;
    }
    get azureAccountKey() {
        return this.getStringAttribute('azure_account_key');
    }
    set azureAccountKey(value) {
        this._azureAccountKey = value;
    }
    resetAzureAccountKey() {
        this._azureAccountKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureAccountKeyInput() {
        return this._azureAccountKey;
    }
    get azureAccountName() {
        return this.getStringAttribute('azure_account_name');
    }
    set azureAccountName(value) {
        this._azureAccountName = value;
    }
    resetAzureAccountName() {
        this._azureAccountName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureAccountNameInput() {
        return this._azureAccountName;
    }
    get azureBlobEnvironment() {
        return this.getStringAttribute('azure_blob_environment');
    }
    set azureBlobEnvironment(value) {
        this._azureBlobEnvironment = value;
    }
    resetAzureBlobEnvironment() {
        this._azureBlobEnvironment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureBlobEnvironmentInput() {
        return this._azureBlobEnvironment;
    }
    get azureContainerName() {
        return this.getStringAttribute('azure_container_name');
    }
    set azureContainerName(value) {
        this._azureContainerName = value;
    }
    resetAzureContainerName() {
        this._azureContainerName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureContainerNameInput() {
        return this._azureContainerName;
    }
    get azureEndpoint() {
        return this.getStringAttribute('azure_endpoint');
    }
    set azureEndpoint(value) {
        this._azureEndpoint = value;
    }
    resetAzureEndpoint() {
        this._azureEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureEndpointInput() {
        return this._azureEndpoint;
    }
    get filePrefix() {
        return this.getStringAttribute('file_prefix');
    }
    set filePrefix(value) {
        this._filePrefix = value;
    }
    resetFilePrefix() {
        this._filePrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get filePrefixInput() {
        return this._filePrefix;
    }
    get googleDisableTls() {
        return this.getBooleanAttribute('google_disable_tls');
    }
    set googleDisableTls(value) {
        this._googleDisableTls = value;
    }
    resetGoogleDisableTls() {
        this._googleDisableTls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleDisableTlsInput() {
        return this._googleDisableTls;
    }
    get googleEndpoint() {
        return this.getStringAttribute('google_endpoint');
    }
    set googleEndpoint(value) {
        this._googleEndpoint = value;
    }
    resetGoogleEndpoint() {
        this._googleEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleEndpointInput() {
        return this._googleEndpoint;
    }
    get googleGcsBucket() {
        return this.getStringAttribute('google_gcs_bucket');
    }
    set googleGcsBucket(value) {
        this._googleGcsBucket = value;
    }
    resetGoogleGcsBucket() {
        this._googleGcsBucket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleGcsBucketInput() {
        return this._googleGcsBucket;
    }
    get googleServiceAccountKey() {
        return this.getStringAttribute('google_service_account_key');
    }
    set googleServiceAccountKey(value) {
        this._googleServiceAccountKey = value;
    }
    resetGoogleServiceAccountKey() {
        this._googleServiceAccountKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleServiceAccountKeyInput() {
        return this._googleServiceAccountKey;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get intervalSeconds() {
        return this.getNumberAttribute('interval_seconds');
    }
    set intervalSeconds(value) {
        this._intervalSeconds = value;
    }
    // Temporarily expose input value. Use with caution.
    get intervalSecondsInput() {
        return this._intervalSeconds;
    }
    get localMaxSpace() {
        return this.getNumberAttribute('local_max_space');
    }
    set localMaxSpace(value) {
        this._localMaxSpace = value;
    }
    resetLocalMaxSpace() {
        this._localMaxSpace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localMaxSpaceInput() {
        return this._localMaxSpace;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get pathPrefix() {
        return this.getStringAttribute('path_prefix');
    }
    set pathPrefix(value) {
        this._pathPrefix = value;
    }
    // Temporarily expose input value. Use with caution.
    get pathPrefixInput() {
        return this._pathPrefix;
    }
    get retain() {
        return this.getNumberAttribute('retain');
    }
    set retain(value) {
        this._retain = value;
    }
    resetRetain() {
        this._retain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get retainInput() {
        return this._retain;
    }
    get storageType() {
        return this.getStringAttribute('storage_type');
    }
    set storageType(value) {
        this._storageType = value;
    }
    // Temporarily expose input value. Use with caution.
    get storageTypeInput() {
        return this._storageType;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            aws_access_key_id: cdktf.stringToTerraform(this._awsAccessKeyId),
            aws_s3_bucket: cdktf.stringToTerraform(this._awsS3Bucket),
            aws_s3_disable_tls: cdktf.booleanToTerraform(this._awsS3DisableTls),
            aws_s3_enable_kms: cdktf.booleanToTerraform(this._awsS3EnableKms),
            aws_s3_endpoint: cdktf.stringToTerraform(this._awsS3Endpoint),
            aws_s3_force_path_style: cdktf.booleanToTerraform(this._awsS3ForcePathStyle),
            aws_s3_kms_key: cdktf.stringToTerraform(this._awsS3KmsKey),
            aws_s3_region: cdktf.stringToTerraform(this._awsS3Region),
            aws_s3_server_side_encryption: cdktf.booleanToTerraform(this._awsS3ServerSideEncryption),
            aws_secret_access_key: cdktf.stringToTerraform(this._awsSecretAccessKey),
            aws_session_token: cdktf.stringToTerraform(this._awsSessionToken),
            azure_account_key: cdktf.stringToTerraform(this._azureAccountKey),
            azure_account_name: cdktf.stringToTerraform(this._azureAccountName),
            azure_blob_environment: cdktf.stringToTerraform(this._azureBlobEnvironment),
            azure_container_name: cdktf.stringToTerraform(this._azureContainerName),
            azure_endpoint: cdktf.stringToTerraform(this._azureEndpoint),
            file_prefix: cdktf.stringToTerraform(this._filePrefix),
            google_disable_tls: cdktf.booleanToTerraform(this._googleDisableTls),
            google_endpoint: cdktf.stringToTerraform(this._googleEndpoint),
            google_gcs_bucket: cdktf.stringToTerraform(this._googleGcsBucket),
            google_service_account_key: cdktf.stringToTerraform(this._googleServiceAccountKey),
            id: cdktf.stringToTerraform(this._id),
            interval_seconds: cdktf.numberToTerraform(this._intervalSeconds),
            local_max_space: cdktf.numberToTerraform(this._localMaxSpace),
            name: cdktf.stringToTerraform(this._name),
            namespace: cdktf.stringToTerraform(this._namespace),
            path_prefix: cdktf.stringToTerraform(this._pathPrefix),
            retain: cdktf.numberToTerraform(this._retain),
            storage_type: cdktf.stringToTerraform(this._storageType),
        };
    }
}
exports.RaftSnapshotAgentConfig = RaftSnapshotAgentConfig;
_a = JSII_RTTI_SYMBOL_1;
RaftSnapshotAgentConfig[_a] = { fqn: "@cdktf/provider-vault.RaftSnapshotAgentConfig", version: "1.0.2" };
// =================
// STATIC PROPERTIES
// =================
RaftSnapshotAgentConfig.tfResourceType = "vault_raft_snapshot_agent_config";
//# sourceMappingURL=data:application/json;base64,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