import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataNullDataSourceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/null/d/data_source#has_computed_default DataNullDataSource#has_computed_default}.
     *
     * @stability stable
     */
    readonly hasComputedDefault?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/null/d/data_source#inputs DataNullDataSource#inputs}.
     *
     * @stability stable
     */
    readonly inputs?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/null/d/data_source null_data_source}.
 *
 * @stability stable
 */
export declare class DataNullDataSource extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/null/d/data_source null_data_source} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataNullDataSourceConfig);
    private _hasComputedDefault?;
    /**
     * @stability stable
     */
    get hasComputedDefault(): string;
    /**
     * @stability stable
     */
    set hasComputedDefault(value: string);
    /**
     * @stability stable
     */
    resetHasComputedDefault(): void;
    /**
     * @stability stable
     */
    get hasComputedDefaultInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _inputs?;
    /**
     * @stability stable
     */
    get inputs(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set inputs(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInputs(): void;
    /**
     * @stability stable
     */
    get inputsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    outputs(key: string): string;
    /**
     * @stability stable
     */
    get random(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
