# PyCGTOOL

[![License](https://img.shields.io/github/license/jag1g13/pycgtool.svg)](LICENSE)
[![Build Status](https://img.shields.io/github/workflow/status/jag1g13/pycgtool/Python%20package)](https://github.com/jag1g13/pycgtool/actions)
[![Documentation](https://readthedocs.org/projects/pycgtool/badge/?version=master)](http://pycgtool.readthedocs.io/en/master/?badge=master)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.598143.svg)](https://doi.org/10.5281/zenodo.598143)

Generate coarse-grained molecular dynamics models from atomistic trajectories.

The aim of this project is to provide a tool to aid in parametrising coarse-grained (CG) molecular mechanics models.
PyCGTOOL generates coarse-grained models from atomistic simulation trajectories using a user-provided mapping. 
Equilibrium values and force constants of bonded terms are calculated by Boltzmann Inversion of bond distributions collected from the input trajectory.

Alternatively map-only mode (behaving similarly to MARTINIZE) may be used to generate initial coordinates to use with existing CG topologies such as the MARTINI lipid models.
For instance, a pre-equilibrated atomistic membrane may be used to create starting coordinates for a MARTINI membrane simulation.

PyCGTOOL makes it easy to test multiple variations in mapping and bond topology by making simple changes to the config files.

This version has several advantages over the original C++ implementation CGTOOL:
* PyCGTOOL is able to run anywhere the necessary library dependencies are available (all available from pip)
* Does not require that residues are present in contiguous sorted blocks
* May map multiple residues with a single pass
* Support for polymers such as DNA or proteins making use of GROMACS' pdb2gmx
* Much more automated testing ensures that regressions will be identified quickly

If you find this useful, please cite as:
```
Graham, J. (2017). PyCGTOOL, https://doi.org/10.5281/zenodo.598143
```

## Install

PyCGTOOL requires Python 3.6 or higher and may be installed using pip:
```
pip install pycgtool
```

## Usage

Input to PyCGTOOL is GROMACS GRO and XTC files, along with two custom files: MAP and BND.  These files provide the atomistic-to-CG mapping and bonded topology respectively.  Example files are present in the [test/data](https://github.com/jag1g13/pycgtool/tree/master/test/data) directory.  The format of these files is described in the [full documentation](https://pycgtool.readthedocs.io/en/master/index.html).

For more information, see [the tutorial](https://pycgtool.readthedocs.io/en/master/tutorial.html).
It is important to perform validation of any new parameter set; a brief example is present at the end of the tutorial.

For a full list of options, see the [documentation](https://pycgtool.readthedocs.io/en/master/index.html) or use:
```
pycgtool -h
```

### Generate a Model

To generate a CG model from an atomistic simulation:
```
pycgtool -g <GRO file> -x <XTC file> -m <MAP file> -b <BND file>
```

### Map Only

To use PyCGTOOL to convert a set of atomistic simulation coordinates to CG coordinates:
```
pycgtool -g <GRO file> -m <MAP file>
```

Or to convert a complete simulation trajectory:
```
pycgtool -g <GRO file> -x <XTC file> -m <MAP file>
```

## Maintainers

James Graham ([@jag1g13](https://github.com/jag1g13))

## Contributing

If you experience problems using PyCGTOOL or wish to see a new feature added please [open an issue](https://github.com/jag1g13/pycgtool/issues/new) or submit a PR.

To help develop PyCGTOOL, you can create a fork of this repository, clone your fork and install PyCGTOOL using:
```
poetry install
```

This will install PyCGTOOL in editable mode (similar to `pip install -e .`) along with all the necessary runtime and development dependencies.
The Makefile at the root of the repository contains targets for running unit and integration tests (`make test`) and linting (`make lint`).

## License

[GPL-3.0](LICENSE) © James Graham, University of Southampton
