# Copyright (c) 2017-2022 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import builtins as _builtins, sys, typing as _typing

from google.protobuf.internal.containers import RepeatedCompositeFieldContainer
from google.protobuf.message import Message as _Message
from google.protobuf.timestamp_pb2 import Timestamp

if sys.version_info >= (3, 8):
    from typing import Literal as _L
else:
    from typing_extensions import Literal as _L

__all__ = [
    "GetMeteringReportRequest",
    "GetMeteringReportResponse",
    "ParticipantMeteringReport",
    "ApplicationMeteringReport",
]


class GetMeteringReportRequest(_Message):
    @property
    def to(self) -> Timestamp: ...
    application_id: _builtins.str
    def __init__(self, *, to: _typing.Optional[Timestamp] = ..., application_id: _typing.Optional[_builtins.str] = ...): ...
    def HasField(self, field_name: _L["from", "to", "application_id"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["from", "to", "application_id"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetMeteringReportResponse(_Message):
    @property
    def request(self) -> GetMeteringReportRequest: ...
    @property
    def participant_report(self) -> ParticipantMeteringReport: ...
    @property
    def report_generation_time(self) -> Timestamp: ...
    def __init__(self, *, request: _typing.Optional[GetMeteringReportRequest] = ..., participant_report: _typing.Optional[ParticipantMeteringReport] = ..., report_generation_time: _typing.Optional[Timestamp] = ...): ...
    def HasField(self, field_name: _L["request", "participant_report", "report_generation_time"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["request", "participant_report", "report_generation_time"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ParticipantMeteringReport(_Message):
    participant_id: _builtins.str
    is_final: _builtins.bool
    @property
    def application_reports(self) -> RepeatedCompositeFieldContainer[ApplicationMeteringReport]: ...
    def __init__(self, *, participant_id: _typing.Optional[_builtins.str] = ..., is_final: _typing.Optional[_builtins.bool] = ..., application_reports: _typing.Optional[_typing.Iterable[ApplicationMeteringReport]] = ...): ...
    def HasField(self, field_name: _L["participant_id", "is_final", "application_reports"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["participant_id", "is_final", "application_reports"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ApplicationMeteringReport(_Message):
    application_id: _builtins.str
    event_count: _builtins.int
    def __init__(self, *, application_id: _typing.Optional[_builtins.str] = ..., event_count: _typing.Optional[_builtins.int] = ...): ...
    def HasField(self, field_name: _L["application_id", "event_count"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["application_id", "event_count"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
