import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AzureAuthBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#backend AzureAuthBackendRole#backend}
    */
    readonly backend?: string;
    /**
    * The list of group ids that login is restricted to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#bound_group_ids AzureAuthBackendRole#bound_group_ids}
    */
    readonly boundGroupIds?: string[];
    /**
    * The list of locations that login is restricted to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#bound_locations AzureAuthBackendRole#bound_locations}
    */
    readonly boundLocations?: string[];
    /**
    * The list of resource groups that login is restricted to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#bound_resource_groups AzureAuthBackendRole#bound_resource_groups}
    */
    readonly boundResourceGroups?: string[];
    /**
    * The list of scale set names that the login is restricted to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#bound_scale_sets AzureAuthBackendRole#bound_scale_sets}
    */
    readonly boundScaleSets?: string[];
    /**
    * The list of Service Principal IDs that login is restricted to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#bound_service_principal_ids AzureAuthBackendRole#bound_service_principal_ids}
    */
    readonly boundServicePrincipalIds?: string[];
    /**
    * The list of subscription IDs that login is restricted to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#bound_subscription_ids AzureAuthBackendRole#bound_subscription_ids}
    */
    readonly boundSubscriptionIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#id AzureAuthBackendRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#namespace AzureAuthBackendRole#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#role AzureAuthBackendRole#role}
    */
    readonly role: string;
    /**
    * Specifies the blocks of IP addresses which are allowed to use the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#token_bound_cidrs AzureAuthBackendRole#token_bound_cidrs}
    */
    readonly tokenBoundCidrs?: string[];
    /**
    * Generated Token's Explicit Maximum TTL in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#token_explicit_max_ttl AzureAuthBackendRole#token_explicit_max_ttl}
    */
    readonly tokenExplicitMaxTtl?: number;
    /**
    * The maximum lifetime of the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#token_max_ttl AzureAuthBackendRole#token_max_ttl}
    */
    readonly tokenMaxTtl?: number;
    /**
    * If true, the 'default' policy will not automatically be added to generated tokens
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#token_no_default_policy AzureAuthBackendRole#token_no_default_policy}
    */
    readonly tokenNoDefaultPolicy?: boolean | cdktf.IResolvable;
    /**
    * The maximum number of times a token may be used, a value of zero means unlimited
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#token_num_uses AzureAuthBackendRole#token_num_uses}
    */
    readonly tokenNumUses?: number;
    /**
    * Generated Token's Period
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#token_period AzureAuthBackendRole#token_period}
    */
    readonly tokenPeriod?: number;
    /**
    * Generated Token's Policies
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#token_policies AzureAuthBackendRole#token_policies}
    */
    readonly tokenPolicies?: string[];
    /**
    * The initial ttl of the token to generate in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#token_ttl AzureAuthBackendRole#token_ttl}
    */
    readonly tokenTtl?: number;
    /**
    * The type of token to generate, service or batch
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role#token_type AzureAuthBackendRole#token_type}
    */
    readonly tokenType?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role vault_azure_auth_backend_role}
*/
export declare class AzureAuthBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_azure_auth_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/azure_auth_backend_role vault_azure_auth_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzureAuthBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: AzureAuthBackendRoleConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _boundGroupIds?;
    get boundGroupIds(): string[];
    set boundGroupIds(value: string[]);
    resetBoundGroupIds(): void;
    get boundGroupIdsInput(): string[] | undefined;
    private _boundLocations?;
    get boundLocations(): string[];
    set boundLocations(value: string[]);
    resetBoundLocations(): void;
    get boundLocationsInput(): string[] | undefined;
    private _boundResourceGroups?;
    get boundResourceGroups(): string[];
    set boundResourceGroups(value: string[]);
    resetBoundResourceGroups(): void;
    get boundResourceGroupsInput(): string[] | undefined;
    private _boundScaleSets?;
    get boundScaleSets(): string[];
    set boundScaleSets(value: string[]);
    resetBoundScaleSets(): void;
    get boundScaleSetsInput(): string[] | undefined;
    private _boundServicePrincipalIds?;
    get boundServicePrincipalIds(): string[];
    set boundServicePrincipalIds(value: string[]);
    resetBoundServicePrincipalIds(): void;
    get boundServicePrincipalIdsInput(): string[] | undefined;
    private _boundSubscriptionIds?;
    get boundSubscriptionIds(): string[];
    set boundSubscriptionIds(value: string[]);
    resetBoundSubscriptionIds(): void;
    get boundSubscriptionIdsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _tokenBoundCidrs?;
    get tokenBoundCidrs(): string[];
    set tokenBoundCidrs(value: string[]);
    resetTokenBoundCidrs(): void;
    get tokenBoundCidrsInput(): string[] | undefined;
    private _tokenExplicitMaxTtl?;
    get tokenExplicitMaxTtl(): number;
    set tokenExplicitMaxTtl(value: number);
    resetTokenExplicitMaxTtl(): void;
    get tokenExplicitMaxTtlInput(): number | undefined;
    private _tokenMaxTtl?;
    get tokenMaxTtl(): number;
    set tokenMaxTtl(value: number);
    resetTokenMaxTtl(): void;
    get tokenMaxTtlInput(): number | undefined;
    private _tokenNoDefaultPolicy?;
    get tokenNoDefaultPolicy(): boolean | cdktf.IResolvable;
    set tokenNoDefaultPolicy(value: boolean | cdktf.IResolvable);
    resetTokenNoDefaultPolicy(): void;
    get tokenNoDefaultPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenNumUses?;
    get tokenNumUses(): number;
    set tokenNumUses(value: number);
    resetTokenNumUses(): void;
    get tokenNumUsesInput(): number | undefined;
    private _tokenPeriod?;
    get tokenPeriod(): number;
    set tokenPeriod(value: number);
    resetTokenPeriod(): void;
    get tokenPeriodInput(): number | undefined;
    private _tokenPolicies?;
    get tokenPolicies(): string[];
    set tokenPolicies(value: string[]);
    resetTokenPolicies(): void;
    get tokenPoliciesInput(): string[] | undefined;
    private _tokenTtl?;
    get tokenTtl(): number;
    set tokenTtl(value: number);
    resetTokenTtl(): void;
    get tokenTtlInput(): number | undefined;
    private _tokenType?;
    get tokenType(): string;
    set tokenType(value: string);
    resetTokenType(): void;
    get tokenTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
