import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MfaTotpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the hashing algorithm used to generate the TOTP code. Options include 'SHA1', 'SHA256' and 'SHA512'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_totp#algorithm MfaTotp#algorithm}
    */
    readonly algorithm?: string;
    /**
    * The number of digits in the generated TOTP token. This value can either be 6 or 8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_totp#digits MfaTotp#digits}
    */
    readonly digits?: number;
    /**
    * ID computed by Vault.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_totp#id MfaTotp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the key's issuing organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_totp#issuer MfaTotp#issuer}
    */
    readonly issuer: string;
    /**
    * Specifies the size in bytes of the generated key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_totp#key_size MfaTotp#key_size}
    */
    readonly keySize?: number;
    /**
    * Name of the MFA method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_totp#name MfaTotp#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_totp#namespace MfaTotp#namespace}
    */
    readonly namespace?: string;
    /**
    * The length of time used to generate a counter for the TOTP token calculation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_totp#period MfaTotp#period}
    */
    readonly period?: number;
    /**
    * The pixel size of the generated square QR code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_totp#qr_size MfaTotp#qr_size}
    */
    readonly qrSize?: number;
    /**
    * The number of delay periods that are allowed when validating a TOTP token. This value can either be 0 or 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_totp#skew MfaTotp#skew}
    */
    readonly skew?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/mfa_totp vault_mfa_totp}
*/
export declare class MfaTotp extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_mfa_totp";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/mfa_totp vault_mfa_totp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MfaTotpConfig
    */
    constructor(scope: Construct, id: string, config: MfaTotpConfig);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    resetAlgorithm(): void;
    get algorithmInput(): string | undefined;
    private _digits?;
    get digits(): number;
    set digits(value: number);
    resetDigits(): void;
    get digitsInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    get issuerInput(): string | undefined;
    private _keySize?;
    get keySize(): number;
    set keySize(value: number);
    resetKeySize(): void;
    get keySizeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _period?;
    get period(): number;
    set period(value: number);
    resetPeriod(): void;
    get periodInput(): number | undefined;
    private _qrSize?;
    get qrSize(): number;
    set qrSize(value: number);
    resetQrSize(): void;
    get qrSizeInput(): number | undefined;
    private _skew?;
    get skew(): number;
    set skew(value: number);
    resetSkew(): void;
    get skewInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
