# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class SnapshotRequestModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'description': 'str',
        'consent_code': 'str',
        'contents': 'list[SnapshotRequestContentsModel]',
        'readers': 'list[str]',
        'profile_id': 'str',
        'properties': 'object',
        'policies': 'SnapshotRequestModelPolicies'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'consent_code': 'consentCode',
        'contents': 'contents',
        'readers': 'readers',
        'profile_id': 'profileId',
        'properties': 'properties',
        'policies': 'policies'
    }

    def __init__(self, name=None, description=None, consent_code=None, contents=None, readers=None, profile_id=None, properties=None, policies=None, local_vars_configuration=None):  # noqa: E501
        """SnapshotRequestModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._description = None
        self._consent_code = None
        self._contents = None
        self._readers = None
        self._profile_id = None
        self._properties = None
        self._policies = None
        self.discriminator = None

        self.name = name
        if description is not None:
            self.description = description
        if consent_code is not None:
            self.consent_code = consent_code
        self.contents = contents
        if readers is not None:
            self.readers = readers
        if profile_id is not None:
            self.profile_id = profile_id
        if properties is not None:
            self.properties = properties
        if policies is not None:
            self.policies = policies

    @property
    def name(self):
        """Gets the name of this SnapshotRequestModel.  # noqa: E501

        Dataset and snapshot names follow this pattern. It is the same as ObjectNameProperty, but has a greater maxLength.   # noqa: E501

        :return: The name of this SnapshotRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SnapshotRequestModel.

        Dataset and snapshot names follow this pattern. It is the same as ObjectNameProperty, but has a greater maxLength.   # noqa: E501

        :param name: The name of this SnapshotRequestModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 511):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `511`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and not re.search(r'^[a-zA-Z0-9][_a-zA-Z0-9]*$', name)):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/^[a-zA-Z0-9][_a-zA-Z0-9]*$/`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this SnapshotRequestModel.  # noqa: E501

        Description of the snapshot  # noqa: E501

        :return: The description of this SnapshotRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this SnapshotRequestModel.

        Description of the snapshot  # noqa: E501

        :param description: The description of this SnapshotRequestModel.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def consent_code(self):
        """Gets the consent_code of this SnapshotRequestModel.  # noqa: E501

        Consent code together with PHS ID that will determine user access  # noqa: E501

        :return: The consent_code of this SnapshotRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._consent_code

    @consent_code.setter
    def consent_code(self, consent_code):
        """Sets the consent_code of this SnapshotRequestModel.

        Consent code together with PHS ID that will determine user access  # noqa: E501

        :param consent_code: The consent_code of this SnapshotRequestModel.  # noqa: E501
        :type: str
        """

        self._consent_code = consent_code

    @property
    def contents(self):
        """Gets the contents of this SnapshotRequestModel.  # noqa: E501


        :return: The contents of this SnapshotRequestModel.  # noqa: E501
        :rtype: list[SnapshotRequestContentsModel]
        """
        return self._contents

    @contents.setter
    def contents(self, contents):
        """Sets the contents of this SnapshotRequestModel.


        :param contents: The contents of this SnapshotRequestModel.  # noqa: E501
        :type: list[SnapshotRequestContentsModel]
        """
        if self.local_vars_configuration.client_side_validation and contents is None:  # noqa: E501
            raise ValueError("Invalid value for `contents`, must not be `None`")  # noqa: E501

        self._contents = contents

    @property
    def readers(self):
        """Gets the readers of this SnapshotRequestModel.  # noqa: E501

        Deprecated -- use `policies.readers` instead. Any readers specified here will supplement those set in `policies.readers`.   # noqa: E501

        :return: The readers of this SnapshotRequestModel.  # noqa: E501
        :rtype: list[str]
        """
        return self._readers

    @readers.setter
    def readers(self, readers):
        """Sets the readers of this SnapshotRequestModel.

        Deprecated -- use `policies.readers` instead. Any readers specified here will supplement those set in `policies.readers`.   # noqa: E501

        :param readers: The readers of this SnapshotRequestModel.  # noqa: E501
        :type: list[str]
        """

        self._readers = readers

    @property
    def profile_id(self):
        """Gets the profile_id of this SnapshotRequestModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The profile_id of this SnapshotRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._profile_id

    @profile_id.setter
    def profile_id(self, profile_id):
        """Sets the profile_id of this SnapshotRequestModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param profile_id: The profile_id of this SnapshotRequestModel.  # noqa: E501
        :type: str
        """

        self._profile_id = profile_id

    @property
    def properties(self):
        """Gets the properties of this SnapshotRequestModel.  # noqa: E501

        Additional JSON metadata about the snapshot (this does not need to adhere to a particular schema)  # noqa: E501

        :return: The properties of this SnapshotRequestModel.  # noqa: E501
        :rtype: object
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this SnapshotRequestModel.

        Additional JSON metadata about the snapshot (this does not need to adhere to a particular schema)  # noqa: E501

        :param properties: The properties of this SnapshotRequestModel.  # noqa: E501
        :type: object
        """

        self._properties = properties

    @property
    def policies(self):
        """Gets the policies of this SnapshotRequestModel.  # noqa: E501


        :return: The policies of this SnapshotRequestModel.  # noqa: E501
        :rtype: SnapshotRequestModelPolicies
        """
        return self._policies

    @policies.setter
    def policies(self, policies):
        """Sets the policies of this SnapshotRequestModel.


        :param policies: The policies of this SnapshotRequestModel.  # noqa: E501
        :type: SnapshotRequestModelPolicies
        """

        self._policies = policies

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotRequestModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotRequestModel):
            return True

        return self.to_dict() != other.to_dict()
