# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['vpype', 'vpype_cli']

package_data = \
{'': ['*']}

install_requires = \
['Shapely[vectorized]>=1.7.1,<1.8.0',
 'attrs>=20.3.0,<20.4.0',
 'click-plugins>=1.1.1,<1.2.0',
 'click>=7.1.2,<7.2.0',
 'matplotlib>=3.3.2,<3.4.0',
 'multiprocess>=0.70.11,<0.71.0',
 'numpy==1.19.3',
 'scipy>=1.5.4,<1.6.0',
 'setuptools>=51.0.0,<52.0.0',
 'svgelements==1.3.5',
 'svgwrite>=1.4,<1.5',
 'toml>=0.10.2,<0.11.0']

extras_require = \
{'docs': ['Sphinx>=3.3.0,<4.0.0',
          'sphinx-click>=2.5.0,<3.0.0',
          'sphinx-autodoc-typehints>=1.11.1,<2.0.0',
          'sphinx-rtd-theme>=0.5.0,<0.6.0',
          'recommonmark>=0.6.0,<0.7.0']}

entry_points = \
{'console_scripts': ['vpype = vpype_cli.cli:cli']}

setup_kwargs = {
    'name': 'vpype',
    'version': '1.2.1',
    'description': 'The Swiss Army knife of vector graphics for pen plotters',
    'long_description': "![banner](https://github.com/abey79/vpype/raw/master/docs/images/banner.png)\n\n\n# _vpype_\n\n[![PyPI](https://img.shields.io/pypi/v/vpype?label=PyPI&logo=pypi)](https://pypi.org/project/vpype/)\n![python](https://img.shields.io/github/languages/top/abey79/vpype)\n[![license](https://img.shields.io/github/license/abey79/vpype)](https://vpype.readthedocs.io/en/stable/license.html)\n![Test](https://img.shields.io/github/workflow/status/abey79/vpype/Lint%20and%20Tests?label=Tests&logo=github)\n[![codecov](https://codecov.io/gh/abey79/vpype/branch/master/graph/badge.svg?token=CE7FD9D6XO)](https://codecov.io/gh/abey79/vpype)\n[![Sonarcloud Status](https://sonarcloud.io/api/project_badges/measure?project=abey79_vpype&metric=alert_status)](https://sonarcloud.io/dashboard?id=abey79_vpype)\n[![Documentation Status](https://img.shields.io/readthedocs/vpype?label=Read%20the%20Docs&logo=read-the-docs)](https://vpype.readthedocs.io/en/latest/?badge=latest)\n\n_vpype_ is the Swiss-Army-knife command-line tool for plotter vector graphics.\n\n#### Contents\n\n* [What _vpype_ is?](#what-vpype-is)\n* [How does it work?](#how-does-it-work)\n* [Examples](#examples)\n* [What _vpype_ isn't?](#what-vpype-isnt)\n* [Installation](#installation)\n* [Documentation](#documentation)\n* [Feature overview](#feature-overview)\n    * [General](#general)\n    * [Input/Output](#inputoutput)\n    * [Layout and transforms](#layout-and-transforms)\n    * [Plotting optimization](#plotting-optimization)\n    * [Generation](#generation)\n    * [Extensibility and API](#extensibility-and-api)\n* [Contributing](#contributing)\n* [License](#license)\n\n\n## What _vpype_ is?\n\n_vpype_ is the Swiss-Army-knife command-line tool for plotter vector graphics. Here is what it can do:\n - **laying out** existing vector files with precise control on position, scale and page format;\n - **optimizing** existing SVG files for faster and cleaner plots;\n - creating **HPGL output** for vintage plotter;\n - creating **generative artwork** through built-in commands or plug-ins;\n - creating, modifying and processing **multi-layer vector files** for multi-colour plots;\n - and much more...\n \n_vpype_ is highly **extensible** through [plug-ins](https://vpype.readthedocs.io/en/stable/api/vpype.html#module-vpype) that\ncan greatly extend its capabilities. For example, plug-ins already exists for plotting\n[pixel art](https://github.com/abey79/vpype-pixelart), [half-toning with hatches](https://github.com/abey79/hatched),\n[plotting text](https://github.com/abey79/vpype-text) with Hershey fonts,\napplying [hidden line removal](https://github.com/LoicGoulefert/occult), and much more.  \n\n_vpype_ is also a [well documented](https://vpype.readthedocs.io/en/stable/api/vpype.html#module-vpype) **Python library**\nuseful to create generative art and tools for plotters. For example, the plotter generative art environment\n[vsketch](https://github.com/abey79/vsketch) is built upon _vpype_.\n\nCheck the [documentation](https://vpype.readthedocs.io/en/stable/) for a more thorough introduction to _vpype_.\n\n## How does it work?\n\n_vpype_ works by building so-called _pipelines_ of _commands_, where each command's output is fed to the next command's input.\nSome commands load geometries into the pipeline (e.g. the [`read`](https://vpype.readthedocs.io/en/stable/reference.html#read)\ncommand which loads geometries from a SVG file). Other commands modify these geometries, e.g. by cropping\nthem ([`crop`](https://vpype.readthedocs.io/en/stable/reference.html#crop)) or reordering them to minimize pen-up\ntravels ([`linesort`](https://vpype.readthedocs.io/en/stable/reference.html#linesort)). Finally, some other commands\njust read the geometries in the pipeline for display purposes ([`show`](https://vpype.readthedocs.io/en/stable/reference.html#show))\nor output to file ([`write`](https://vpype.readthedocs.io/en/stable/reference.html#write)).\n\nPipeline are defined using the _vpype_'s CLI (command-line interface) in a terminal by typing `vpype` followed by the\nlist of commands, each with their optional parameters and their arguments:\n\n![command line](https://github.com/abey79/vpype/raw/master/docs/images/command_line.svg)\n\nThis pipeline uses five commands (in bold):\n- [`read`](https://vpype.readthedocs.io/en/stable/reference.html#read) loads geometries from a SVG file.\n- [`linemerge`](https://vpype.readthedocs.io/en/stable/reference.html#linemerge) merges paths whose extremities are close to each other (within the provided tolerance).\n- [`linesort`](https://vpype.readthedocs.io/en/stable/reference.html#linesort) reorder paths such as to minimise the pen-up travel.\n- [`crop`](https://vpype.readthedocs.io/en/stable/reference.html#crop), well, crops.\n- [`write`](https://vpype.readthedocs.io/en/stable/reference.html#write) export the resulting geometries to a SVG file.\n\nThere are many more commands available in *vpype*, see the [overview](#feature-overview) below.\n\nSome commands have arguments, which are always required (in italic). For example, a file path must be provided to the\n[`read`](https://vpype.readthedocs.io/en/stable/reference.html#read) command and dimensions must be provided to the [`crop`](https://vpype.readthedocs.io/en/stable/reference.html#crop) commands. A command may also have options which are, well,\noptional. In this example, `--page-size a4` means that the [`write`](https://vpype.readthedocs.io/en/stable/reference.html#write) command will generate a A4-sized SVG (otherwise it\nwould have the same size as _in.svg_). Likewise, because `--center` is used, the [`write`](https://vpype.readthedocs.io/en/stable/reference.html#write) command will center geometries\non the page before saving the SVG (otherwise the geometries would have been left at their original location).\n\n\n## Examples\n\n**Note**: although it is not required, commands are separated by multiple spaces for clarity in the following examples.\n\nLoad an SVG file, scale it to a specific size, and export it centered on an A4-sized, ready-to-plot SVG file:\n```\nvpype  read input.svg  scaleto 10cm 10cm  write --page-size a4 --center output.svg\n```\n\nOptimize paths to reduce plotting time (merge connected lines and sort them to minimize pen-up distance):\n```\nvpype  read input.svg  linemerge --tolerance 0.1mm  linesort  write output.svg\n```\n\nVisualize the path structure of large SVG files, showing whether lines are properly joined or not thanks to a colorful\ndisplay:\n```\nvpype  read input.svg  show --colorful\n```\n\nLoad several SVG files and save them as a single, multi-layer SVG file (e.g. for multicolored drawings):\n```\nvpype  read -l 1 input1.svg  read -l 2 input2.svg  write output.svg\n```\n\nCreate arbitrarily-sized, grid-like designs like this page's top banner:\n```\nvpype  begin  grid -o 1cm 1cm 10 13  script alien_letter.py  scaleto 0.5cm 0.5cm  end  show\n```\n\nExport to HPGL for vintage plotters:\n```\nvpype  read input.svg  write --device hp7475a --page-size a4 --landscape --center output.hpgl\n```\n  \n## What _vpype_ isn't?\n\n_vpype_ caters to plotter generative art and does not aim to be a general purpose (think\nIllustrator/InkScape) vector graphic tools. One of the main reason for this is the fact _vpype_ converts everything \ncurvy (circles, bezier curves, etc.) to lines made of small segments. _vpype_ also dismisses the stroke and fill\nproperties (color, line width, etc.) of the imported graphics. These design choices make possible _vpype_'s rich feature\nset, but makes its use for, e.g., printed media limited. \n \n \n## Installation\n\nFor Windows, an installer is available [here](https://github.com/abey79/vpype/releases) (note: plug-ins cannot be installed\nwhen using this installation method).\n\nFor other platforms, and when plug-ins are required, *vpype* can be installed from the [Python Package Index](https://pypi.org)\nusing the following command:\n\n```bash\npip install vpype\n```\n\nPython must previously be installed. Python version 3.8 is recommended to use *vpype*, although it is also compatible with Python 3.6 and 3.7. Python 3.9 should be avoided for the time being due to the lack of binary distribution for several dependencies.\n\nFor Linux, install Python with your OS's default package manager. For macOS, Python is best installed from either\n[MacPorts](https://www.macports.org) or [Homebrew](https://brew.sh). For Windows, use the\n[official installer](https://www.python.org/downloads/).\n\nCheck [the documentation](https://vpype.readthedocs.io/en/stable/install.html) for more details, in particular on how to use a virtual environment (recommended).\n\n\n## Documentation\n\nThe _vpype_ CLI includes its own, detailed documentation:\n\n```bash\nvpype --help          # general help and command list\nvpype COMMAND --help  # help for a specific command\n``` \n\nIn addition, the [online documentation](https://vpype.readthedocs.io/en/stable/) provides extensive background\ninformation on the fundamentals behind _vpype_, a cookbook covering most common tasks, the _vpype_ API documentation,\nand much more.\n\n\n## Feature overview\n\n#### General\n\n- Easy to use **CLI** interface with integrated help (`vpype --help`and `vpype COMMAND --help`) and support for arbitrary units (e.g. `vpype read input.svg translate 3cm 2in`).\n- First-class **multi-layer support** with global or per-layer processing (e.g. `vpype COMMANDNAME --layer 1,3`) and layer edition commands ([`lmove`](https://vpype.readthedocs.io/en/stable/reference.html#lmove), [`lcopy`](https://vpype.readthedocs.io/en/stable/reference.html#lcopy), [`ldelete`](https://vpype.readthedocs.io/en/stable/reference.html#ldelete)).\n- Powerful **display** command with adjustable units, optional per-line coloring, optional pen-up trajectories display and per-layer visibility control ([`show`](https://vpype.readthedocs.io/en/stable/reference.html#show)).\n- Geometry **statistics** extraction ([`stat`](https://vpype.readthedocs.io/en/stable/reference.html#stat)).\n- Support for  **command history** recording (`vpype -H [...]`)\n- Support for **RNG seed** configuration for generative plug-ins (`vpype -s 37 [...]`).\n\n\n#### Input/Output\n\n- Single- and multi-layer **SVG input** with adjustable precision, parallel processing for large SVGs, and supports percent or missing width/height ([`read`](https://vpype.readthedocs.io/en/stable/reference.html#read)).\n- Support for **SVG output** with fine layout control (page size and orientation, centering), layer support with custom layer names, optional display of pen-up trajectories, various option for coloring ([`write`](https://vpype.readthedocs.io/en/stable/reference.html#write)).\n- Support for **HPGL output** config-based generation of HPGL code with fine layout control (page size and orientation, centering).\n\n\n#### Layout and transforms\n\n- Powerful **transform** commands for scaling, translating, skewing and rotating geometries ([`scale`](https://vpype.readthedocs.io/en/stable/reference.html#scale), [`translate`](https://vpype.readthedocs.io/en/stable/reference.html#translate), [`skew`](https://vpype.readthedocs.io/en/stable/reference.html#skew), [`rotate`](https://vpype.readthedocs.io/en/stable/reference.html#rotate)).\n- Support for **scaling** and **cropping** to arbitrary dimensions ([`scaleto`](https://vpype.readthedocs.io/en/stable/reference.html#scaleto), [`crop`](https://vpype.readthedocs.io/en/stable/reference.html#crop)).\n- Support for **trimming** geometries by an arbitrary amount ([`trim`](https://vpype.readthedocs.io/en/stable/reference.html#trim)).\n- Arbitrary **page size** definition ([`pagesize`](https://vpype.readthedocs.io/en/stable/reference.html#pagesize)). \n\n\n#### Plotting optimization\n\n- **Line merging** with optional path reversal and configurable merging threshold ([`linemerge`](https://vpype.readthedocs.io/en/stable/reference.html#linemerge)).\n- **Line sorting** with optional path reversal ([`linesort`](https://vpype.readthedocs.io/en/stable/reference.html#linesort)).\n- **Line simplification** with adjustable accuracy ([`linesimplify`](https://vpype.readthedocs.io/en/stable/reference.html#linesimplify)).\n- Support for **splitting** all lines to their constituent segments ([`splitall`](https://vpype.readthedocs.io/en/stable/reference.html#splitall)).\n- Closed paths' **seam location randomization**, to reduce the visibility of pen-up/pen-down artifacts ([`reloop`](https://vpype.readthedocs.io/en/stable/reference.html#reloop)).\n- Support for generating **multiple passes** on each line ([`multipass`](https://vpype.readthedocs.io/en/stable/reference.html#multipass)).\n- Support for **filtering** by line lengths or closed-ness ([`filter`](https://vpype.readthedocs.io/en/stable/reference.html#filter)).\n- Support for **reversing** order of paths within their layers ([`reverse`](https://vpype.readthedocs.io/en/stable/reference.html#reverse)).\n \n #### Generation\n \n - Generation of arbitrary **primitives** including lines, rectangles, circles, ellipses and arcs ([`line`](https://vpype.readthedocs.io/en/stable/reference.html#line), [`rect`](https://vpype.readthedocs.io/en/stable/reference.html#rect), [`circle`](https://vpype.readthedocs.io/en/stable/reference.html#circle), [`ellipse`](https://vpype.readthedocs.io/en/stable/reference.html#ellipse), [`arc`](https://vpype.readthedocs.io/en/stable/reference.html#arc)).\n - Generation of grid-like layouts ([`grid`](https://vpype.readthedocs.io/en/stable/reference.html#grid)).\n - Generation of a **frame** around the geometries ([`frame`](https://vpype.readthedocs.io/en/stable/reference.html#frame)).\n - Generation of random lines for debug/learning purposes ([`random`](https://vpype.readthedocs.io/en/stable/reference.html#random))\n\n#### Extensibility and API\n\n - First-class support for **plug-in** extensions (e.g [vpype-text](https://github.com/abey79/vpype-text), [hatched](https://github.com/abey79/hatched), [occult](https://github.com/LoicGoulefert/occult)).\n - Support for **script-based** generation ([`script`](https://vpype.readthedocs.io/en/stable/reference.html#script)).\n - Powerful and [well-documented](https://vpype.readthedocs.io/en/stable/api/vpype.html#module-vpype) **API** for plug-ins and other plotter generative art projects.\n \n \n ## Contributing\n\nContributions to this project are welcome and do not necessarily require software development skills! Check the\n[Contributing section](https://vpype.readthedocs.io/en/stable/contributing.html) of the documentation for more\ninformation.  \n\n\n## License\n\nThis project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.\n",
    'author': 'Antoine Beyeler',
    'author_email': 'abeyeler@ab-ware.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/abey79/vpype',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<3.9',
}


setup(**setup_kwargs)
