# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.play_queue_settings import PlayQueueSettings
from mozart_api.models.source_type_enum import SourceTypeEnum
from mozart_api.models.stand_position import StandPosition
from mozart_api.models.play_queue_item import PlayQueueItem

from mozart_api.configuration import Configuration


class Action(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "button_name": "str",
        "content_id": "str",
        "deezer_user_id": "str",
        "listening_mode_id": "int",
        "preset_key": "str",
        "queue_item": "PlayQueueItem",
        "queue_settings": "PlayQueueSettings",
        "radio_station_id": "str",
        "source": "SourceTypeEnum",
        "speaker_group_id": "str",
        "stand_position": "StandPosition",
        "stop_duration": "int",
        "tone_name": "str",
        "type": "str",
        "volume_level": "int",
    }

    attribute_map = {
        "button_name": "buttonName",
        "content_id": "contentId",
        "deezer_user_id": "deezerUserId",
        "listening_mode_id": "listeningModeId",
        "preset_key": "presetKey",
        "queue_item": "queueItem",
        "queue_settings": "queueSettings",
        "radio_station_id": "radioStationId",
        "source": "source",
        "speaker_group_id": "speakerGroupId",
        "stand_position": "standPosition",
        "stop_duration": "stopDuration",
        "tone_name": "toneName",
        "type": "type",
        "volume_level": "volumeLevel",
    }

    def __init__(
        self,
        button_name: Optional[str] = None,
        content_id: Optional[str] = None,
        deezer_user_id: Optional[str] = None,
        listening_mode_id: Optional[int] = None,
        preset_key: Optional[str] = None,
        queue_item: Optional[PlayQueueItem] = None,
        queue_settings: Optional[PlayQueueSettings] = None,
        radio_station_id: Optional[str] = None,
        source: Optional[SourceTypeEnum] = None,
        speaker_group_id: Optional[str] = None,
        stand_position: Optional[StandPosition] = None,
        stop_duration: Optional[int] = None,
        tone_name: Optional[str] = None,
        type: Optional["Action.LTypeType"] = None,
        volume_level: Optional[int] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """Action - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._button_name = None
        self._content_id = None
        self._deezer_user_id = None
        self._listening_mode_id = None
        self._preset_key = None
        self._queue_item = None
        self._queue_settings = None
        self._radio_station_id = None
        self._source = None
        self._speaker_group_id = None
        self._stand_position = None
        self._stop_duration = None
        self._tone_name = None
        self._type = None
        self._volume_level = None
        self.discriminator = None

        self.button_name = button_name
        self.content_id = content_id
        self.deezer_user_id = deezer_user_id
        if listening_mode_id is not None:
            self.listening_mode_id = listening_mode_id
        self.preset_key = preset_key
        if queue_item is not None:
            self.queue_item = queue_item
        if queue_settings is not None:
            self.queue_settings = queue_settings
        self.radio_station_id = radio_station_id
        if source is not None:
            self.source = source
        if speaker_group_id is not None:
            self.speaker_group_id = speaker_group_id
        if stand_position is not None:
            self.stand_position = stand_position
        self.stop_duration = stop_duration
        self.tone_name = tone_name
        self.type = type
        self.volume_level = volume_level

    @property
    def button_name(self):
        # type: () -> str
        """Gets the button_name of this Action.  # noqa: E501

        Name of the Button used for button-press types ('buttonShortPress')  # noqa: E501

        :return: The button_name of this Action.  # noqa: E501
        :rtype: str
        """
        return self._button_name

    @button_name.setter
    def button_name(self, button_name):
        # type: (str) -> None
        """Sets the button_name of this Action.

        Name of the Button used for button-press types ('buttonShortPress')  # noqa: E501

        :param button_name: The button_name of this Action.  # noqa: E501
        :type button_name: str
        :rtype: None
        """
        allowed_values = [
            None,
            "microphone",
            "bluetooth",
            "next",
            "previous",
            "playPause",
            "previousNext",
            "preset1",
            "preset2",
            "preset3",
            "preset4",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and button_name not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `button_name` ({0}), must be one of {1}".format(  # noqa: E501
                    button_name, allowed_values
                )
            )

        self._button_name = button_name

    @property
    def content_id(self):
        # type: () -> str
        """Gets the content_id of this Action.  # noqa: E501

        Id of content only used for 'type=triggerContent'  # noqa: E501

        :return: The content_id of this Action.  # noqa: E501
        :rtype: str
        """
        return self._content_id

    @content_id.setter
    def content_id(self, content_id):
        # type: (str) -> None
        """Sets the content_id of this Action.

        Id of content only used for 'type=triggerContent'  # noqa: E501

        :param content_id: The content_id of this Action.  # noqa: E501
        :type content_id: str
        :rtype: None
        """

        self._content_id = content_id

    @property
    def deezer_user_id(self):
        # type: () -> str
        """Gets the deezer_user_id of this Action.  # noqa: E501

        Id of user only used for 'type=deezerFlow' and is optional  # noqa: E501

        :return: The deezer_user_id of this Action.  # noqa: E501
        :rtype: str
        """
        return self._deezer_user_id

    @deezer_user_id.setter
    def deezer_user_id(self, deezer_user_id):
        # type: (str) -> None
        """Sets the deezer_user_id of this Action.

        Id of user only used for 'type=deezerFlow' and is optional  # noqa: E501

        :param deezer_user_id: The deezer_user_id of this Action.  # noqa: E501
        :type deezer_user_id: str
        :rtype: None
        """

        self._deezer_user_id = deezer_user_id

    @property
    def listening_mode_id(self):
        # type: () -> int
        """Gets the listening_mode_id of this Action.  # noqa: E501


        :return: The listening_mode_id of this Action.  # noqa: E501
        :rtype: int
        """
        return self._listening_mode_id

    @listening_mode_id.setter
    def listening_mode_id(self, listening_mode_id):
        # type: (int) -> None
        """Sets the listening_mode_id of this Action.


        :param listening_mode_id: The listening_mode_id of this Action.  # noqa: E501
        :type listening_mode_id: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and listening_mode_id is not None
            and listening_mode_id < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `listening_mode_id`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._listening_mode_id = listening_mode_id

    @property
    def preset_key(self):
        # type: () -> str
        """Gets the preset_key of this Action.  # noqa: E501

        Only used for 'type=sourcePreset'  # noqa: E501

        :return: The preset_key of this Action.  # noqa: E501
        :rtype: str
        """
        return self._preset_key

    @preset_key.setter
    def preset_key(self, preset_key):
        # type: (str) -> None
        """Sets the preset_key of this Action.

        Only used for 'type=sourcePreset'  # noqa: E501

        :param preset_key: The preset_key of this Action.  # noqa: E501
        :type preset_key: str
        :rtype: None
        """

        self._preset_key = preset_key

    @property
    def queue_item(self):
        # type: () -> PlayQueueItem
        """Gets the queue_item of this Action.  # noqa: E501


        :return: The queue_item of this Action.  # noqa: E501
        :rtype: PlayQueueItem
        """
        return self._queue_item

    @queue_item.setter
    def queue_item(self, queue_item):
        # type: (PlayQueueItem) -> None
        """Sets the queue_item of this Action.


        :param queue_item: The queue_item of this Action.  # noqa: E501
        :type queue_item: PlayQueueItem
        :rtype: None
        """

        self._queue_item = queue_item

    @property
    def queue_settings(self):
        # type: () -> PlayQueueSettings
        """Gets the queue_settings of this Action.  # noqa: E501


        :return: The queue_settings of this Action.  # noqa: E501
        :rtype: PlayQueueSettings
        """
        return self._queue_settings

    @queue_settings.setter
    def queue_settings(self, queue_settings):
        # type: (PlayQueueSettings) -> None
        """Sets the queue_settings of this Action.


        :param queue_settings: The queue_settings of this Action.  # noqa: E501
        :type queue_settings: PlayQueueSettings
        :rtype: None
        """

        self._queue_settings = queue_settings

    @property
    def radio_station_id(self):
        # type: () -> str
        """Gets the radio_station_id of this Action.  # noqa: E501

        Id of RadioStation only used for 'type=radio'  # noqa: E501

        :return: The radio_station_id of this Action.  # noqa: E501
        :rtype: str
        """
        return self._radio_station_id

    @radio_station_id.setter
    def radio_station_id(self, radio_station_id):
        # type: (str) -> None
        """Sets the radio_station_id of this Action.

        Id of RadioStation only used for 'type=radio'  # noqa: E501

        :param radio_station_id: The radio_station_id of this Action.  # noqa: E501
        :type radio_station_id: str
        :rtype: None
        """

        self._radio_station_id = radio_station_id

    @property
    def source(self):
        # type: () -> SourceTypeEnum
        """Gets the source of this Action.  # noqa: E501


        :return: The source of this Action.  # noqa: E501
        :rtype: SourceTypeEnum
        """
        return self._source

    @source.setter
    def source(self, source):
        # type: (SourceTypeEnum) -> None
        """Sets the source of this Action.


        :param source: The source of this Action.  # noqa: E501
        :type source: SourceTypeEnum
        :rtype: None
        """

        self._source = source

    @property
    def speaker_group_id(self):
        # type: () -> str
        """Gets the speaker_group_id of this Action.  # noqa: E501


        :return: The speaker_group_id of this Action.  # noqa: E501
        :rtype: str
        """
        return self._speaker_group_id

    @speaker_group_id.setter
    def speaker_group_id(self, speaker_group_id):
        # type: (str) -> None
        """Sets the speaker_group_id of this Action.


        :param speaker_group_id: The speaker_group_id of this Action.  # noqa: E501
        :type speaker_group_id: str
        :rtype: None
        """

        self._speaker_group_id = speaker_group_id

    @property
    def stand_position(self):
        # type: () -> StandPosition
        """Gets the stand_position of this Action.  # noqa: E501


        :return: The stand_position of this Action.  # noqa: E501
        :rtype: StandPosition
        """
        return self._stand_position

    @stand_position.setter
    def stand_position(self, stand_position):
        # type: (StandPosition) -> None
        """Sets the stand_position of this Action.


        :param stand_position: The stand_position of this Action.  # noqa: E501
        :type stand_position: StandPosition
        :rtype: None
        """

        self._stand_position = stand_position

    @property
    def stop_duration(self):
        # type: () -> int
        """Gets the stop_duration of this Action.  # noqa: E501

        The duration to wait (seconds) until stopping only used for 'type=stop'  # noqa: E501

        :return: The stop_duration of this Action.  # noqa: E501
        :rtype: int
        """
        return self._stop_duration

    @stop_duration.setter
    def stop_duration(self, stop_duration):
        # type: (int) -> None
        """Sets the stop_duration of this Action.

        The duration to wait (seconds) until stopping only used for 'type=stop'  # noqa: E501

        :param stop_duration: The stop_duration of this Action.  # noqa: E501
        :type stop_duration: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and stop_duration is not None
            and stop_duration < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `stop_duration`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._stop_duration = stop_duration

    @property
    def tone_name(self):
        # type: () -> str
        """Gets the tone_name of this Action.  # noqa: E501

        Name of the tone only used for 'type=tone'  # noqa: E501

        :return: The tone_name of this Action.  # noqa: E501
        :rtype: str
        """
        return self._tone_name

    @tone_name.setter
    def tone_name(self, tone_name):
        # type: (str) -> None
        """Sets the tone_name of this Action.

        Name of the tone only used for 'type=tone'  # noqa: E501

        :param tone_name: The tone_name of this Action.  # noqa: E501
        :type tone_name: str
        :rtype: None
        """
        allowed_values = [None, "alarm_1", "alarm_2"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and tone_name not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `tone_name` ({0}), must be one of {1}".format(  # noqa: E501
                    tone_name, allowed_values
                )
            )

        self._tone_name = tone_name

    LTypeType = Literal[
        "standby",
        "tone",
        "radio",
        "sourcePreset",
        "deezerFlow",
        "activateSource",
        "playQueue",
        "buttonShortPress",
        "allStandby",
        "touchToJoin",
        "fallback",
        "volume",
        "stop",
        "triggerContent",
        "speakerGroup",
        "listeningMode",
        "stand",
    ]

    @property
    def type(self):
        # type: () -> 'Action.LTypeType'
        """Gets the type of this Action.  # noqa: E501

        The type of Action  # noqa: E501

        :return: The type of this Action.  # noqa: E501
        :rtype: 'Action.LTypeType'
        """
        return self._type

    @type.setter
    def type(self, type):
        # type: ('Action.LTypeType') -> None
        """Sets the type of this Action.

        The type of Action  # noqa: E501

        :param type: The type of this Action.  # noqa: E501
        :type type: 'Action.LTypeType'
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and type is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `type`, must not be `None`"
            )  # noqa: E501
        allowed_values = [
            "standby",
            "tone",
            "radio",
            "sourcePreset",
            "deezerFlow",
            "activateSource",
            "playQueue",
            "buttonShortPress",
            "allStandby",
            "touchToJoin",
            "fallback",
            "volume",
            "stop",
            "triggerContent",
            "speakerGroup",
            "listeningMode",
            "stand",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and type not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}".format(  # noqa: E501
                    type, allowed_values
                )
            )

        self._type = type

    @property
    def volume_level(self):
        # type: () -> int
        """Gets the volume_level of this Action.  # noqa: E501

        The volume level to configure only used for 'type=volume'  # noqa: E501

        :return: The volume_level of this Action.  # noqa: E501
        :rtype: int
        """
        return self._volume_level

    @volume_level.setter
    def volume_level(self, volume_level):
        # type: (int) -> None
        """Sets the volume_level of this Action.

        The volume level to configure only used for 'type=volume'  # noqa: E501

        :param volume_level: The volume_level of this Action.  # noqa: E501
        :type volume_level: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and volume_level is not None
            and volume_level > 100
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `volume_level`, must be a value less than or equal to `100`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and volume_level is not None
            and volume_level < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `volume_level`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._volume_level = volume_level

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Action):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Action):
            return True

        return self.to_dict() != other.to_dict()
