# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional


from mozart_api.configuration import Configuration


class AlarmTimerEventData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"event": "str", "id": "str", "type": "str"}

    attribute_map = {"event": "event", "id": "id", "type": "type"}

    def __init__(
        self,
        event: Optional["AlarmTimerEventData.LTypeEvent"] = None,
        id: Optional[str] = None,
        type: Optional["AlarmTimerEventData.LTypeType"] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """AlarmTimerEventData - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._event = None
        self._id = None
        self._type = None
        self.discriminator = None

        if event is not None:
            self.event = event
        if id is not None:
            self.id = id
        if type is not None:
            self.type = type

    LTypeEvent = Literal["add", "update", "delete"]

    @property
    def event(self):
        # type: () -> 'AlarmTimerEventData.LTypeEvent'
        """Gets the event of this AlarmTimerEventData.  # noqa: E501


        :return: The event of this AlarmTimerEventData.  # noqa: E501
        :rtype: 'AlarmTimerEventData.LTypeEvent'
        """
        return self._event

    @event.setter
    def event(self, event):
        # type: ('AlarmTimerEventData.LTypeEvent') -> None
        """Sets the event of this AlarmTimerEventData.


        :param event: The event of this AlarmTimerEventData.  # noqa: E501
        :type event: 'AlarmTimerEventData.LTypeEvent'
        :rtype: None
        """
        allowed_values = ["add", "update", "delete"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and event not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `event` ({0}), must be one of {1}".format(  # noqa: E501
                    event, allowed_values
                )
            )

        self._event = event

    @property
    def id(self):
        # type: () -> str
        """Gets the id of this AlarmTimerEventData.  # noqa: E501


        :return: The id of this AlarmTimerEventData.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        # type: (str) -> None
        """Sets the id of this AlarmTimerEventData.


        :param id: The id of this AlarmTimerEventData.  # noqa: E501
        :type id: str
        :rtype: None
        """

        self._id = id

    LTypeType = Literal["alarm", "timer"]

    @property
    def type(self):
        # type: () -> 'AlarmTimerEventData.LTypeType'
        """Gets the type of this AlarmTimerEventData.  # noqa: E501


        :return: The type of this AlarmTimerEventData.  # noqa: E501
        :rtype: 'AlarmTimerEventData.LTypeType'
        """
        return self._type

    @type.setter
    def type(self, type):
        # type: ('AlarmTimerEventData.LTypeType') -> None
        """Sets the type of this AlarmTimerEventData.


        :param type: The type of this AlarmTimerEventData.  # noqa: E501
        :type type: 'AlarmTimerEventData.LTypeType'
        :rtype: None
        """
        allowed_values = ["alarm", "timer"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and type not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}".format(  # noqa: E501
                    type, allowed_values
                )
            )

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AlarmTimerEventData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AlarmTimerEventData):
            return True

        return self.to_dict() != other.to_dict()
