# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional


from mozart_api.configuration import Configuration


class BatteryState(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "battery_level": "int",
        "is_charging": "bool",
        "remaining_charging_time_minutes": "int",
        "remaining_playing_time_minutes": "int",
    }

    attribute_map = {
        "battery_level": "batteryLevel",
        "is_charging": "isCharging",
        "remaining_charging_time_minutes": "remainingChargingTimeMinutes",
        "remaining_playing_time_minutes": "remainingPlayingTimeMinutes",
    }

    def __init__(
        self,
        battery_level: Optional[int] = None,
        is_charging: Optional[bool] = None,
        remaining_charging_time_minutes: Optional[int] = None,
        remaining_playing_time_minutes: Optional[int] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """BatteryState - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._battery_level = None
        self._is_charging = None
        self._remaining_charging_time_minutes = None
        self._remaining_playing_time_minutes = None
        self.discriminator = None

        if battery_level is not None:
            self.battery_level = battery_level
        if is_charging is not None:
            self.is_charging = is_charging
        if remaining_charging_time_minutes is not None:
            self.remaining_charging_time_minutes = remaining_charging_time_minutes
        if remaining_playing_time_minutes is not None:
            self.remaining_playing_time_minutes = remaining_playing_time_minutes

    @property
    def battery_level(self):
        # type: () -> int
        """Gets the battery_level of this BatteryState.  # noqa: E501

        Batterylevel in percent   # noqa: E501

        :return: The battery_level of this BatteryState.  # noqa: E501
        :rtype: int
        """
        return self._battery_level

    @battery_level.setter
    def battery_level(self, battery_level):
        # type: (int) -> None
        """Sets the battery_level of this BatteryState.

        Batterylevel in percent   # noqa: E501

        :param battery_level: The battery_level of this BatteryState.  # noqa: E501
        :type battery_level: int
        :rtype: None
        """

        self._battery_level = battery_level

    @property
    def is_charging(self):
        # type: () -> bool
        """Gets the is_charging of this BatteryState.  # noqa: E501


        :return: The is_charging of this BatteryState.  # noqa: E501
        :rtype: bool
        """
        return self._is_charging

    @is_charging.setter
    def is_charging(self, is_charging):
        # type: (bool) -> None
        """Sets the is_charging of this BatteryState.


        :param is_charging: The is_charging of this BatteryState.  # noqa: E501
        :type is_charging: bool
        :rtype: None
        """

        self._is_charging = is_charging

    @property
    def remaining_charging_time_minutes(self):
        # type: () -> int
        """Gets the remaining_charging_time_minutes of this BatteryState.  # noqa: E501

        Remaining charging time in minutes  # noqa: E501

        :return: The remaining_charging_time_minutes of this BatteryState.  # noqa: E501
        :rtype: int
        """
        return self._remaining_charging_time_minutes

    @remaining_charging_time_minutes.setter
    def remaining_charging_time_minutes(self, remaining_charging_time_minutes):
        # type: (int) -> None
        """Sets the remaining_charging_time_minutes of this BatteryState.

        Remaining charging time in minutes  # noqa: E501

        :param remaining_charging_time_minutes: The remaining_charging_time_minutes of this BatteryState.  # noqa: E501
        :type remaining_charging_time_minutes: int
        :rtype: None
        """

        self._remaining_charging_time_minutes = remaining_charging_time_minutes

    @property
    def remaining_playing_time_minutes(self):
        # type: () -> int
        """Gets the remaining_playing_time_minutes of this BatteryState.  # noqa: E501

        Remaining playing time in minutes  # noqa: E501

        :return: The remaining_playing_time_minutes of this BatteryState.  # noqa: E501
        :rtype: int
        """
        return self._remaining_playing_time_minutes

    @remaining_playing_time_minutes.setter
    def remaining_playing_time_minutes(self, remaining_playing_time_minutes):
        # type: (int) -> None
        """Sets the remaining_playing_time_minutes of this BatteryState.

        Remaining playing time in minutes  # noqa: E501

        :param remaining_playing_time_minutes: The remaining_playing_time_minutes of this BatteryState.  # noqa: E501
        :type remaining_playing_time_minutes: int
        :rtype: None
        """

        self._remaining_playing_time_minutes = remaining_playing_time_minutes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BatteryState):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BatteryState):
            return True

        return self.to_dict() != other.to_dict()
