# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional


from mozart_api.configuration import Configuration


class BeolinkExperience(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "category": "str",
        "id": "str",
        "linkable": "bool",
        "name": "str",
        "product_friendly_name": "str",
        "source_friendly_name": "str",
        "type": "str",
        "unique_source_id": "str",
    }

    attribute_map = {
        "category": "category",
        "id": "id",
        "linkable": "linkable",
        "name": "name",
        "product_friendly_name": "productFriendlyName",
        "source_friendly_name": "sourceFriendlyName",
        "type": "type",
        "unique_source_id": "uniqueSourceId",
    }

    def __init__(
        self,
        category: Optional["BeolinkExperience.LTypeCategory"] = None,
        id: Optional[str] = None,
        linkable: Optional[bool] = None,
        name: Optional[str] = None,
        product_friendly_name: Optional[str] = None,
        source_friendly_name: Optional[str] = None,
        type: Optional[str] = None,
        unique_source_id: Optional[str] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """BeolinkExperience - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._category = None
        self._id = None
        self._linkable = None
        self._name = None
        self._product_friendly_name = None
        self._source_friendly_name = None
        self._type = None
        self._unique_source_id = None
        self.discriminator = None

        self.category = category
        self.id = id
        self.linkable = linkable
        self.name = name
        if product_friendly_name is not None:
            self.product_friendly_name = product_friendly_name
        if source_friendly_name is not None:
            self.source_friendly_name = source_friendly_name
        self.type = type
        self.unique_source_id = unique_source_id

    LTypeCategory = Literal["TV", "RADIO", "MUSIC", "MEDIA", "UNKNOWN"]

    @property
    def category(self):
        # type: () -> 'BeolinkExperience.LTypeCategory'
        """Gets the category of this BeolinkExperience.  # noqa: E501

        Source category  # noqa: E501

        :return: The category of this BeolinkExperience.  # noqa: E501
        :rtype: 'BeolinkExperience.LTypeCategory'
        """
        return self._category

    @category.setter
    def category(self, category):
        # type: ('BeolinkExperience.LTypeCategory') -> None
        """Sets the category of this BeolinkExperience.

        Source category  # noqa: E501

        :param category: The category of this BeolinkExperience.  # noqa: E501
        :type category: 'BeolinkExperience.LTypeCategory'
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and category is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `category`, must not be `None`"
            )  # noqa: E501
        allowed_values = ["TV", "RADIO", "MUSIC", "MEDIA", "UNKNOWN"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and category not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `category` ({0}), must be one of {1}".format(  # noqa: E501
                    category, allowed_values
                )
            )

        self._category = category

    @property
    def id(self):
        # type: () -> str
        """Gets the id of this BeolinkExperience.  # noqa: E501

        experience id, e.g. \"RADIO\" or \"toslink\"  # noqa: E501

        :return: The id of this BeolinkExperience.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        # type: (str) -> None
        """Sets the id of this BeolinkExperience.

        experience id, e.g. \"RADIO\" or \"toslink\"  # noqa: E501

        :param id: The id of this BeolinkExperience.  # noqa: E501
        :type id: str
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and id is None
        ):  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def linkable(self):
        # type: () -> bool
        """Gets the linkable of this BeolinkExperience.  # noqa: E501

        Linkable means \"Does pressing play on this source make sense\"  # noqa: E501

        :return: The linkable of this BeolinkExperience.  # noqa: E501
        :rtype: bool
        """
        return self._linkable

    @linkable.setter
    def linkable(self, linkable):
        # type: (bool) -> None
        """Sets the linkable of this BeolinkExperience.

        Linkable means \"Does pressing play on this source make sense\"  # noqa: E501

        :param linkable: The linkable of this BeolinkExperience.  # noqa: E501
        :type linkable: bool
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and linkable is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `linkable`, must not be `None`"
            )  # noqa: E501

        self._linkable = linkable

    @property
    def name(self):
        # type: () -> str
        """Gets the name of this BeolinkExperience.  # noqa: E501

        Experience name, e.g. \"Bluetooth\" or \"B&O Radio\"  # noqa: E501

        :return: The name of this BeolinkExperience.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        # type: (str) -> None
        """Sets the name of this BeolinkExperience.

        Experience name, e.g. \"Bluetooth\" or \"B&O Radio\"  # noqa: E501

        :param name: The name of this BeolinkExperience.  # noqa: E501
        :type name: str
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and name is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `name`, must not be `None`"
            )  # noqa: E501

        self._name = name

    @property
    def product_friendly_name(self):
        # type: () -> str
        """Gets the product_friendly_name of this BeolinkExperience.  # noqa: E501

        Optional product friendly name  # noqa: E501

        :return: The product_friendly_name of this BeolinkExperience.  # noqa: E501
        :rtype: str
        """
        return self._product_friendly_name

    @product_friendly_name.setter
    def product_friendly_name(self, product_friendly_name):
        # type: (str) -> None
        """Sets the product_friendly_name of this BeolinkExperience.

        Optional product friendly name  # noqa: E501

        :param product_friendly_name: The product_friendly_name of this BeolinkExperience.  # noqa: E501
        :type product_friendly_name: str
        :rtype: None
        """

        self._product_friendly_name = product_friendly_name

    @property
    def source_friendly_name(self):
        # type: () -> str
        """Gets the source_friendly_name of this BeolinkExperience.  # noqa: E501

        Optional friendly name for source  # noqa: E501

        :return: The source_friendly_name of this BeolinkExperience.  # noqa: E501
        :rtype: str
        """
        return self._source_friendly_name

    @source_friendly_name.setter
    def source_friendly_name(self, source_friendly_name):
        # type: (str) -> None
        """Sets the source_friendly_name of this BeolinkExperience.

        Optional friendly name for source  # noqa: E501

        :param source_friendly_name: The source_friendly_name of this BeolinkExperience.  # noqa: E501
        :type source_friendly_name: str
        :rtype: None
        """

        self._source_friendly_name = source_friendly_name

    @property
    def type(self):
        # type: () -> str
        """Gets the type of this BeolinkExperience.  # noqa: E501

        Source type. This corresponds to the exhaustive list or sources provided by the control layer  # noqa: E501

        :return: The type of this BeolinkExperience.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        # type: (str) -> None
        """Sets the type of this BeolinkExperience.

        Source type. This corresponds to the exhaustive list or sources provided by the control layer  # noqa: E501

        :param type: The type of this BeolinkExperience.  # noqa: E501
        :type type: str
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and type is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `type`, must not be `None`"
            )  # noqa: E501

        self._type = type

    @property
    def unique_source_id(self):
        # type: () -> str
        """Gets the unique_source_id of this BeolinkExperience.  # noqa: E501

        The actual device jabber id that the experience comes from  # noqa: E501

        :return: The unique_source_id of this BeolinkExperience.  # noqa: E501
        :rtype: str
        """
        return self._unique_source_id

    @unique_source_id.setter
    def unique_source_id(self, unique_source_id):
        # type: (str) -> None
        """Sets the unique_source_id of this BeolinkExperience.

        The actual device jabber id that the experience comes from  # noqa: E501

        :param unique_source_id: The unique_source_id of this BeolinkExperience.  # noqa: E501
        :type unique_source_id: str
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and unique_source_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `unique_source_id`, must not be `None`"
            )  # noqa: E501

        self._unique_source_id = unique_source_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BeolinkExperience):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BeolinkExperience):
            return True

        return self.to_dict() != other.to_dict()
