# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.beolink_experience import BeolinkExperience

from mozart_api.configuration import Configuration


class BeolinkExperiencesResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "experiences": "list[BeolinkExperience]",
        "request_id": "str",
        "status": "str",
    }

    attribute_map = {
        "experiences": "experiences",
        "request_id": "requestID",
        "status": "status",
    }

    def __init__(
        self,
        experiences: Optional[List[BeolinkExperience]] = None,
        request_id: Optional[str] = None,
        status: Optional["BeolinkExperiencesResult.LTypeStatus"] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """BeolinkExperiencesResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._experiences = None
        self._request_id = None
        self._status = None
        self.discriminator = None

        self.experiences = experiences
        self.request_id = request_id
        self.status = status

    @property
    def experiences(self):
        # type: () -> List[BeolinkExperience]
        """Gets the experiences of this BeolinkExperiencesResult.  # noqa: E501


        :return: The experiences of this BeolinkExperiencesResult.  # noqa: E501
        :rtype: List[BeolinkExperience]
        """
        return self._experiences

    @experiences.setter
    def experiences(self, experiences):
        # type: (list[BeolinkExperience]) -> None
        """Sets the experiences of this BeolinkExperiencesResult.


        :param experiences: The experiences of this BeolinkExperiencesResult.  # noqa: E501
        :type experiences: list[BeolinkExperience]
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and experiences is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `experiences`, must not be `None`"
            )  # noqa: E501

        self._experiences = experiences

    @property
    def request_id(self):
        # type: () -> str
        """Gets the request_id of this BeolinkExperiencesResult.  # noqa: E501

        Beolink request ID  # noqa: E501

        :return: The request_id of this BeolinkExperiencesResult.  # noqa: E501
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        # type: (str) -> None
        """Sets the request_id of this BeolinkExperiencesResult.

        Beolink request ID  # noqa: E501

        :param request_id: The request_id of this BeolinkExperiencesResult.  # noqa: E501
        :type request_id: str
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and request_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `request_id`, must not be `None`"
            )  # noqa: E501

        self._request_id = request_id

    LTypeStatus = Literal["ok", "busy", "timeout"]

    @property
    def status(self):
        # type: () -> 'BeolinkExperiencesResult.LTypeStatus'
        """Gets the status of this BeolinkExperiencesResult.  # noqa: E501

        Current scan status. * busy: there is another scan in progress * timeout: the scan timed out. The results will be partial   # noqa: E501

        :return: The status of this BeolinkExperiencesResult.  # noqa: E501
        :rtype: 'BeolinkExperiencesResult.LTypeStatus'
        """
        return self._status

    @status.setter
    def status(self, status):
        # type: ('BeolinkExperiencesResult.LTypeStatus') -> None
        """Sets the status of this BeolinkExperiencesResult.

        Current scan status. * busy: there is another scan in progress * timeout: the scan timed out. The results will be partial   # noqa: E501

        :param status: The status of this BeolinkExperiencesResult.  # noqa: E501
        :type status: 'BeolinkExperiencesResult.LTypeStatus'
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and status is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `status`, must not be `None`"
            )  # noqa: E501
        allowed_values = ["ok", "busy", "timeout"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and status not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}".format(  # noqa: E501
                    status, allowed_values
                )
            )

        self._status = status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BeolinkExperiencesResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BeolinkExperiencesResult):
            return True

        return self.to_dict() != other.to_dict()
