# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional


from mozart_api.configuration import Configuration


class BeolinkJoinResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "error": "str",
        "jid": "str",
        "request_id": "str",
        "status": "str",
        "type": "str",
    }

    attribute_map = {
        "error": "error",
        "jid": "jid",
        "request_id": "requestID",
        "status": "status",
        "type": "type",
    }

    def __init__(
        self,
        error: Optional["BeolinkJoinResult.LTypeError"] = None,
        jid: Optional[str] = None,
        request_id: Optional[str] = None,
        status: Optional["BeolinkJoinResult.LTypeStatus"] = None,
        type: Optional["BeolinkJoinResult.LTypeType"] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """BeolinkJoinResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._error = None
        self._jid = None
        self._request_id = None
        self._status = None
        self._type = None
        self.discriminator = None

        if error is not None:
            self.error = error
        self.jid = jid
        self.request_id = request_id
        self.status = status
        self.type = type

    LTypeError = Literal[
        "ok", "busy", "leaderless", "alone", "silent", "missing", "rejected", "timeout"
    ]

    @property
    def error(self):
        # type: () -> 'BeolinkJoinResult.LTypeError'
        """Gets the error of this BeolinkJoinResult.  # noqa: E501

        Join error  # noqa: E501

        :return: The error of this BeolinkJoinResult.  # noqa: E501
        :rtype: 'BeolinkJoinResult.LTypeError'
        """
        return self._error

    @error.setter
    def error(self, error):
        # type: ('BeolinkJoinResult.LTypeError') -> None
        """Sets the error of this BeolinkJoinResult.

        Join error  # noqa: E501

        :param error: The error of this BeolinkJoinResult.  # noqa: E501
        :type error: 'BeolinkJoinResult.LTypeError'
        :rtype: None
        """
        allowed_values = [
            "ok",
            "busy",
            "leaderless",
            "alone",
            "silent",
            "missing",
            "rejected",
            "timeout",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and error not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `error` ({0}), must be one of {1}".format(  # noqa: E501
                    error, allowed_values
                )
            )

        self._error = error

    @property
    def jid(self):
        # type: () -> str
        """Gets the jid of this BeolinkJoinResult.  # noqa: E501

        Beolink peer ID  # noqa: E501

        :return: The jid of this BeolinkJoinResult.  # noqa: E501
        :rtype: str
        """
        return self._jid

    @jid.setter
    def jid(self, jid):
        # type: (str) -> None
        """Sets the jid of this BeolinkJoinResult.

        Beolink peer ID  # noqa: E501

        :param jid: The jid of this BeolinkJoinResult.  # noqa: E501
        :type jid: str
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and jid is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `jid`, must not be `None`"
            )  # noqa: E501

        self._jid = jid

    @property
    def request_id(self):
        # type: () -> str
        """Gets the request_id of this BeolinkJoinResult.  # noqa: E501

        Beolink request ID  # noqa: E501

        :return: The request_id of this BeolinkJoinResult.  # noqa: E501
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        # type: (str) -> None
        """Sets the request_id of this BeolinkJoinResult.

        Beolink request ID  # noqa: E501

        :param request_id: The request_id of this BeolinkJoinResult.  # noqa: E501
        :type request_id: str
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and request_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `request_id`, must not be `None`"
            )  # noqa: E501

        self._request_id = request_id

    LTypeStatus = Literal["idle", "joined", "failed"]

    @property
    def status(self):
        # type: () -> 'BeolinkJoinResult.LTypeStatus'
        """Gets the status of this BeolinkJoinResult.  # noqa: E501

        Overall join status  # noqa: E501

        :return: The status of this BeolinkJoinResult.  # noqa: E501
        :rtype: 'BeolinkJoinResult.LTypeStatus'
        """
        return self._status

    @status.setter
    def status(self, status):
        # type: ('BeolinkJoinResult.LTypeStatus') -> None
        """Sets the status of this BeolinkJoinResult.

        Overall join status  # noqa: E501

        :param status: The status of this BeolinkJoinResult.  # noqa: E501
        :type status: 'BeolinkJoinResult.LTypeStatus'
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and status is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `status`, must not be `None`"
            )  # noqa: E501
        allowed_values = ["idle", "joined", "failed"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and status not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}".format(  # noqa: E501
                    status, allowed_values
                )
            )

        self._status = status

    LTypeType = Literal["join", "joinRequested", "expand", "expandRequested"]

    @property
    def type(self):
        # type: () -> 'BeolinkJoinResult.LTypeType'
        """Gets the type of this BeolinkJoinResult.  # noqa: E501

        The type of join request this is a result of  # noqa: E501

        :return: The type of this BeolinkJoinResult.  # noqa: E501
        :rtype: 'BeolinkJoinResult.LTypeType'
        """
        return self._type

    @type.setter
    def type(self, type):
        # type: ('BeolinkJoinResult.LTypeType') -> None
        """Sets the type of this BeolinkJoinResult.

        The type of join request this is a result of  # noqa: E501

        :param type: The type of this BeolinkJoinResult.  # noqa: E501
        :type type: 'BeolinkJoinResult.LTypeType'
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and type is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `type`, must not be `None`"
            )  # noqa: E501
        allowed_values = [
            "join",
            "joinRequested",
            "expand",
            "expandRequested",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and type not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}".format(  # noqa: E501
                    type, allowed_values
                )
            )

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BeolinkJoinResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BeolinkJoinResult):
            return True

        return self.to_dict() != other.to_dict()
