# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional


from mozart_api.configuration import Configuration


class BluetoothDevice(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"address": "str", "connected": "bool", "name": "str"}

    attribute_map = {"address": "address", "connected": "connected", "name": "name"}

    def __init__(
        self,
        address: Optional[str] = None,
        connected: Optional[bool] = None,
        name: Optional[str] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """BluetoothDevice - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._address = None
        self._connected = None
        self._name = None
        self.discriminator = None

        if address is not None:
            self.address = address
        if connected is not None:
            self.connected = connected
        if name is not None:
            self.name = name

    @property
    def address(self):
        # type: () -> str
        """Gets the address of this BluetoothDevice.  # noqa: E501


        :return: The address of this BluetoothDevice.  # noqa: E501
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address):
        # type: (str) -> None
        """Sets the address of this BluetoothDevice.


        :param address: The address of this BluetoothDevice.  # noqa: E501
        :type address: str
        :rtype: None
        """

        self._address = address

    @property
    def connected(self):
        # type: () -> bool
        """Gets the connected of this BluetoothDevice.  # noqa: E501


        :return: The connected of this BluetoothDevice.  # noqa: E501
        :rtype: bool
        """
        return self._connected

    @connected.setter
    def connected(self, connected):
        # type: (bool) -> None
        """Sets the connected of this BluetoothDevice.


        :param connected: The connected of this BluetoothDevice.  # noqa: E501
        :type connected: bool
        :rtype: None
        """

        self._connected = connected

    @property
    def name(self):
        # type: () -> str
        """Gets the name of this BluetoothDevice.  # noqa: E501


        :return: The name of this BluetoothDevice.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        # type: (str) -> None
        """Sets the name of this BluetoothDevice.


        :param name: The name of this BluetoothDevice.  # noqa: E501
        :type name: str
        :rtype: None
        """

        self._name = name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BluetoothDevice):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BluetoothDevice):
            return True

        return self.to_dict() != other.to_dict()
