# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional


from mozart_api.configuration import Configuration


class ErrorModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"error_code": "str", "error_id": "str", "error_message": "str"}

    attribute_map = {
        "error_code": "errorCode",
        "error_id": "errorId",
        "error_message": "errorMessage",
    }

    def __init__(
        self,
        error_code: Optional[str] = None,
        error_id: Optional[str] = None,
        error_message: Optional[str] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """ErrorModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._error_code = None
        self._error_id = None
        self._error_message = None
        self.discriminator = None

        if error_code is not None:
            self.error_code = error_code
        if error_id is not None:
            self.error_id = error_id
        if error_message is not None:
            self.error_message = error_message

    @property
    def error_code(self):
        # type: () -> str
        """Gets the error_code of this ErrorModel.  # noqa: E501

        A wellknown code that signal the error, can be used by callers   # noqa: E501

        :return: The error_code of this ErrorModel.  # noqa: E501
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        # type: (str) -> None
        """Sets the error_code of this ErrorModel.

        A wellknown code that signal the error, can be used by callers   # noqa: E501

        :param error_code: The error_code of this ErrorModel.  # noqa: E501
        :type error_code: str
        :rtype: None
        """

        self._error_code = error_code

    @property
    def error_id(self):
        # type: () -> str
        """Gets the error_id of this ErrorModel.  # noqa: E501

        A unique identifier used to e.g. quick find in logs   # noqa: E501

        :return: The error_id of this ErrorModel.  # noqa: E501
        :rtype: str
        """
        return self._error_id

    @error_id.setter
    def error_id(self, error_id):
        # type: (str) -> None
        """Sets the error_id of this ErrorModel.

        A unique identifier used to e.g. quick find in logs   # noqa: E501

        :param error_id: The error_id of this ErrorModel.  # noqa: E501
        :type error_id: str
        :rtype: None
        """

        self._error_id = error_id

    @property
    def error_message(self):
        # type: () -> str
        """Gets the error_message of this ErrorModel.  # noqa: E501

        A textual representation, human readable and suitable for logs   # noqa: E501

        :return: The error_message of this ErrorModel.  # noqa: E501
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        # type: (str) -> None
        """Sets the error_message of this ErrorModel.

        A textual representation, human readable and suitable for logs   # noqa: E501

        :param error_message: The error_message of this ErrorModel.  # noqa: E501
        :type error_message: str
        :rtype: None
        """

        self._error_message = error_message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ErrorModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ErrorModel):
            return True

        return self.to_dict() != other.to_dict()
