# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.video_timings import VideoTimings
from mozart_api.models.video_pixel_format import VideoPixelFormat

from mozart_api.configuration import Configuration


class HdmiVideoFormat(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "pixel_format": "VideoPixelFormat",
        "v_ic": "int",
        "video_timings": "VideoTimings",
    }

    attribute_map = {
        "pixel_format": "pixelFormat",
        "v_ic": "vIC",
        "video_timings": "videoTimings",
    }

    def __init__(
        self,
        pixel_format: Optional[VideoPixelFormat] = None,
        v_ic: Optional[int] = None,
        video_timings: Optional[VideoTimings] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """HdmiVideoFormat - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._pixel_format = None
        self._v_ic = None
        self._video_timings = None
        self.discriminator = None

        if pixel_format is not None:
            self.pixel_format = pixel_format
        if v_ic is not None:
            self.v_ic = v_ic
        if video_timings is not None:
            self.video_timings = video_timings

    @property
    def pixel_format(self):
        # type: () -> VideoPixelFormat
        """Gets the pixel_format of this HdmiVideoFormat.  # noqa: E501


        :return: The pixel_format of this HdmiVideoFormat.  # noqa: E501
        :rtype: VideoPixelFormat
        """
        return self._pixel_format

    @pixel_format.setter
    def pixel_format(self, pixel_format):
        # type: (VideoPixelFormat) -> None
        """Sets the pixel_format of this HdmiVideoFormat.


        :param pixel_format: The pixel_format of this HdmiVideoFormat.  # noqa: E501
        :type pixel_format: VideoPixelFormat
        :rtype: None
        """

        self._pixel_format = pixel_format

    @property
    def v_ic(self):
        # type: () -> int
        """Gets the v_ic of this HdmiVideoFormat.  # noqa: E501


        :return: The v_ic of this HdmiVideoFormat.  # noqa: E501
        :rtype: int
        """
        return self._v_ic

    @v_ic.setter
    def v_ic(self, v_ic):
        # type: (int) -> None
        """Sets the v_ic of this HdmiVideoFormat.


        :param v_ic: The v_ic of this HdmiVideoFormat.  # noqa: E501
        :type v_ic: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and v_ic is not None
            and v_ic < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `v_ic`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._v_ic = v_ic

    @property
    def video_timings(self):
        # type: () -> VideoTimings
        """Gets the video_timings of this HdmiVideoFormat.  # noqa: E501


        :return: The video_timings of this HdmiVideoFormat.  # noqa: E501
        :rtype: VideoTimings
        """
        return self._video_timings

    @video_timings.setter
    def video_timings(self, video_timings):
        # type: (VideoTimings) -> None
        """Sets the video_timings of this HdmiVideoFormat.


        :param video_timings: The video_timings of this HdmiVideoFormat.  # noqa: E501
        :type video_timings: VideoTimings
        :rtype: None
        """

        self._video_timings = video_timings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HdmiVideoFormat):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HdmiVideoFormat):
            return True

        return self.to_dict() != other.to_dict()
