# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.compression import Compression
from mozart_api.models.spatial_surround import SpatialSurround
from mozart_api.models.spatial_processing import SpatialProcessing
from mozart_api.models.spatial_envelopment import SpatialEnvelopment
from mozart_api.models.directivity import Directivity
from mozart_api.models.spatial_width import SpatialWidth
from mozart_api.models.tone_touch import ToneTouch
from mozart_api.models.balance import Balance
from mozart_api.models.ambience import Ambience
from mozart_api.models.fader import Fader
from mozart_api.models.room_compensation import RoomCompensation
from mozart_api.models.spatial_height import SpatialHeight
from mozart_api.models.bass_management import BassManagement
from mozart_api.models.speech_enhance import SpeechEnhance

from mozart_api.configuration import Configuration


class ListeningModeFeatures(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "ambience": "Ambience",
        "balance": "Balance",
        "bass_management": "BassManagement",
        "compression": "Compression",
        "directivity": "Directivity",
        "fader": "Fader",
        "room_compensation": "RoomCompensation",
        "spatial_envelopment": "SpatialEnvelopment",
        "spatial_height": "SpatialHeight",
        "spatial_processing": "SpatialProcessing",
        "spatial_surround": "SpatialSurround",
        "spatial_width": "SpatialWidth",
        "speech_enhance": "SpeechEnhance",
        "tone_touch": "ToneTouch",
    }

    attribute_map = {
        "ambience": "ambience",
        "balance": "balance",
        "bass_management": "bassManagement",
        "compression": "compression",
        "directivity": "directivity",
        "fader": "fader",
        "room_compensation": "roomCompensation",
        "spatial_envelopment": "spatialEnvelopment",
        "spatial_height": "spatialHeight",
        "spatial_processing": "spatialProcessing",
        "spatial_surround": "spatialSurround",
        "spatial_width": "spatialWidth",
        "speech_enhance": "speechEnhance",
        "tone_touch": "toneTouch",
    }

    def __init__(
        self,
        ambience: Optional[Ambience] = None,
        balance: Optional[Balance] = None,
        bass_management: Optional[BassManagement] = None,
        compression: Optional[Compression] = None,
        directivity: Optional[Directivity] = None,
        fader: Optional[Fader] = None,
        room_compensation: Optional[RoomCompensation] = None,
        spatial_envelopment: Optional[SpatialEnvelopment] = None,
        spatial_height: Optional[SpatialHeight] = None,
        spatial_processing: Optional[SpatialProcessing] = None,
        spatial_surround: Optional[SpatialSurround] = None,
        spatial_width: Optional[SpatialWidth] = None,
        speech_enhance: Optional[SpeechEnhance] = None,
        tone_touch: Optional[ToneTouch] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """ListeningModeFeatures - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._ambience = None
        self._balance = None
        self._bass_management = None
        self._compression = None
        self._directivity = None
        self._fader = None
        self._room_compensation = None
        self._spatial_envelopment = None
        self._spatial_height = None
        self._spatial_processing = None
        self._spatial_surround = None
        self._spatial_width = None
        self._speech_enhance = None
        self._tone_touch = None
        self.discriminator = None

        if ambience is not None:
            self.ambience = ambience
        if balance is not None:
            self.balance = balance
        if bass_management is not None:
            self.bass_management = bass_management
        if compression is not None:
            self.compression = compression
        if directivity is not None:
            self.directivity = directivity
        if fader is not None:
            self.fader = fader
        if room_compensation is not None:
            self.room_compensation = room_compensation
        if spatial_envelopment is not None:
            self.spatial_envelopment = spatial_envelopment
        if spatial_height is not None:
            self.spatial_height = spatial_height
        if spatial_processing is not None:
            self.spatial_processing = spatial_processing
        if spatial_surround is not None:
            self.spatial_surround = spatial_surround
        if spatial_width is not None:
            self.spatial_width = spatial_width
        if speech_enhance is not None:
            self.speech_enhance = speech_enhance
        if tone_touch is not None:
            self.tone_touch = tone_touch

    @property
    def ambience(self):
        # type: () -> Ambience
        """Gets the ambience of this ListeningModeFeatures.  # noqa: E501


        :return: The ambience of this ListeningModeFeatures.  # noqa: E501
        :rtype: Ambience
        """
        return self._ambience

    @ambience.setter
    def ambience(self, ambience):
        # type: (Ambience) -> None
        """Sets the ambience of this ListeningModeFeatures.


        :param ambience: The ambience of this ListeningModeFeatures.  # noqa: E501
        :type ambience: Ambience
        :rtype: None
        """

        self._ambience = ambience

    @property
    def balance(self):
        # type: () -> Balance
        """Gets the balance of this ListeningModeFeatures.  # noqa: E501


        :return: The balance of this ListeningModeFeatures.  # noqa: E501
        :rtype: Balance
        """
        return self._balance

    @balance.setter
    def balance(self, balance):
        # type: (Balance) -> None
        """Sets the balance of this ListeningModeFeatures.


        :param balance: The balance of this ListeningModeFeatures.  # noqa: E501
        :type balance: Balance
        :rtype: None
        """

        self._balance = balance

    @property
    def bass_management(self):
        # type: () -> BassManagement
        """Gets the bass_management of this ListeningModeFeatures.  # noqa: E501


        :return: The bass_management of this ListeningModeFeatures.  # noqa: E501
        :rtype: BassManagement
        """
        return self._bass_management

    @bass_management.setter
    def bass_management(self, bass_management):
        # type: (BassManagement) -> None
        """Sets the bass_management of this ListeningModeFeatures.


        :param bass_management: The bass_management of this ListeningModeFeatures.  # noqa: E501
        :type bass_management: BassManagement
        :rtype: None
        """

        self._bass_management = bass_management

    @property
    def compression(self):
        # type: () -> Compression
        """Gets the compression of this ListeningModeFeatures.  # noqa: E501


        :return: The compression of this ListeningModeFeatures.  # noqa: E501
        :rtype: Compression
        """
        return self._compression

    @compression.setter
    def compression(self, compression):
        # type: (Compression) -> None
        """Sets the compression of this ListeningModeFeatures.


        :param compression: The compression of this ListeningModeFeatures.  # noqa: E501
        :type compression: Compression
        :rtype: None
        """

        self._compression = compression

    @property
    def directivity(self):
        # type: () -> Directivity
        """Gets the directivity of this ListeningModeFeatures.  # noqa: E501


        :return: The directivity of this ListeningModeFeatures.  # noqa: E501
        :rtype: Directivity
        """
        return self._directivity

    @directivity.setter
    def directivity(self, directivity):
        # type: (Directivity) -> None
        """Sets the directivity of this ListeningModeFeatures.


        :param directivity: The directivity of this ListeningModeFeatures.  # noqa: E501
        :type directivity: Directivity
        :rtype: None
        """

        self._directivity = directivity

    @property
    def fader(self):
        # type: () -> Fader
        """Gets the fader of this ListeningModeFeatures.  # noqa: E501


        :return: The fader of this ListeningModeFeatures.  # noqa: E501
        :rtype: Fader
        """
        return self._fader

    @fader.setter
    def fader(self, fader):
        # type: (Fader) -> None
        """Sets the fader of this ListeningModeFeatures.


        :param fader: The fader of this ListeningModeFeatures.  # noqa: E501
        :type fader: Fader
        :rtype: None
        """

        self._fader = fader

    @property
    def room_compensation(self):
        # type: () -> RoomCompensation
        """Gets the room_compensation of this ListeningModeFeatures.  # noqa: E501


        :return: The room_compensation of this ListeningModeFeatures.  # noqa: E501
        :rtype: RoomCompensation
        """
        return self._room_compensation

    @room_compensation.setter
    def room_compensation(self, room_compensation):
        # type: (RoomCompensation) -> None
        """Sets the room_compensation of this ListeningModeFeatures.


        :param room_compensation: The room_compensation of this ListeningModeFeatures.  # noqa: E501
        :type room_compensation: RoomCompensation
        :rtype: None
        """

        self._room_compensation = room_compensation

    @property
    def spatial_envelopment(self):
        # type: () -> SpatialEnvelopment
        """Gets the spatial_envelopment of this ListeningModeFeatures.  # noqa: E501


        :return: The spatial_envelopment of this ListeningModeFeatures.  # noqa: E501
        :rtype: SpatialEnvelopment
        """
        return self._spatial_envelopment

    @spatial_envelopment.setter
    def spatial_envelopment(self, spatial_envelopment):
        # type: (SpatialEnvelopment) -> None
        """Sets the spatial_envelopment of this ListeningModeFeatures.


        :param spatial_envelopment: The spatial_envelopment of this ListeningModeFeatures.  # noqa: E501
        :type spatial_envelopment: SpatialEnvelopment
        :rtype: None
        """

        self._spatial_envelopment = spatial_envelopment

    @property
    def spatial_height(self):
        # type: () -> SpatialHeight
        """Gets the spatial_height of this ListeningModeFeatures.  # noqa: E501


        :return: The spatial_height of this ListeningModeFeatures.  # noqa: E501
        :rtype: SpatialHeight
        """
        return self._spatial_height

    @spatial_height.setter
    def spatial_height(self, spatial_height):
        # type: (SpatialHeight) -> None
        """Sets the spatial_height of this ListeningModeFeatures.


        :param spatial_height: The spatial_height of this ListeningModeFeatures.  # noqa: E501
        :type spatial_height: SpatialHeight
        :rtype: None
        """

        self._spatial_height = spatial_height

    @property
    def spatial_processing(self):
        # type: () -> SpatialProcessing
        """Gets the spatial_processing of this ListeningModeFeatures.  # noqa: E501


        :return: The spatial_processing of this ListeningModeFeatures.  # noqa: E501
        :rtype: SpatialProcessing
        """
        return self._spatial_processing

    @spatial_processing.setter
    def spatial_processing(self, spatial_processing):
        # type: (SpatialProcessing) -> None
        """Sets the spatial_processing of this ListeningModeFeatures.


        :param spatial_processing: The spatial_processing of this ListeningModeFeatures.  # noqa: E501
        :type spatial_processing: SpatialProcessing
        :rtype: None
        """

        self._spatial_processing = spatial_processing

    @property
    def spatial_surround(self):
        # type: () -> SpatialSurround
        """Gets the spatial_surround of this ListeningModeFeatures.  # noqa: E501


        :return: The spatial_surround of this ListeningModeFeatures.  # noqa: E501
        :rtype: SpatialSurround
        """
        return self._spatial_surround

    @spatial_surround.setter
    def spatial_surround(self, spatial_surround):
        # type: (SpatialSurround) -> None
        """Sets the spatial_surround of this ListeningModeFeatures.


        :param spatial_surround: The spatial_surround of this ListeningModeFeatures.  # noqa: E501
        :type spatial_surround: SpatialSurround
        :rtype: None
        """

        self._spatial_surround = spatial_surround

    @property
    def spatial_width(self):
        # type: () -> SpatialWidth
        """Gets the spatial_width of this ListeningModeFeatures.  # noqa: E501


        :return: The spatial_width of this ListeningModeFeatures.  # noqa: E501
        :rtype: SpatialWidth
        """
        return self._spatial_width

    @spatial_width.setter
    def spatial_width(self, spatial_width):
        # type: (SpatialWidth) -> None
        """Sets the spatial_width of this ListeningModeFeatures.


        :param spatial_width: The spatial_width of this ListeningModeFeatures.  # noqa: E501
        :type spatial_width: SpatialWidth
        :rtype: None
        """

        self._spatial_width = spatial_width

    @property
    def speech_enhance(self):
        # type: () -> SpeechEnhance
        """Gets the speech_enhance of this ListeningModeFeatures.  # noqa: E501


        :return: The speech_enhance of this ListeningModeFeatures.  # noqa: E501
        :rtype: SpeechEnhance
        """
        return self._speech_enhance

    @speech_enhance.setter
    def speech_enhance(self, speech_enhance):
        # type: (SpeechEnhance) -> None
        """Sets the speech_enhance of this ListeningModeFeatures.


        :param speech_enhance: The speech_enhance of this ListeningModeFeatures.  # noqa: E501
        :type speech_enhance: SpeechEnhance
        :rtype: None
        """

        self._speech_enhance = speech_enhance

    @property
    def tone_touch(self):
        # type: () -> ToneTouch
        """Gets the tone_touch of this ListeningModeFeatures.  # noqa: E501


        :return: The tone_touch of this ListeningModeFeatures.  # noqa: E501
        :rtype: ToneTouch
        """
        return self._tone_touch

    @tone_touch.setter
    def tone_touch(self, tone_touch):
        # type: (ToneTouch) -> None
        """Sets the tone_touch of this ListeningModeFeatures.


        :param tone_touch: The tone_touch of this ListeningModeFeatures.  # noqa: E501
        :type tone_touch: ToneTouch
        :rtype: None
        """

        self._tone_touch = tone_touch

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ListeningModeFeatures):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ListeningModeFeatures):
            return True

        return self.to_dict() != other.to_dict()
