# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.listening_mode_features import ListeningModeFeatures
from mozart_api.models.listening_mode_trigger import ListeningModeTrigger

from mozart_api.configuration import Configuration


class ListeningModeProps(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "client_ctx": "str",
        "features": "ListeningModeFeatures",
        "id": "int",
        "name": "str",
        "origin": "str",
        "role": "str",
        "triggers": "list[ListeningModeTrigger]",
    }

    attribute_map = {
        "client_ctx": "clientCtx",
        "features": "features",
        "id": "id",
        "name": "name",
        "origin": "origin",
        "role": "role",
        "triggers": "triggers",
    }

    def __init__(
        self,
        client_ctx: Optional[str] = None,
        features: Optional[ListeningModeFeatures] = None,
        id: Optional[int] = None,
        name: Optional[str] = None,
        origin: Optional["ListeningModeProps.LTypeOrigin"] = None,
        role: Optional["ListeningModeProps.LTypeRole"] = None,
        triggers: Optional[List[ListeningModeTrigger]] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """ListeningModeProps - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._client_ctx = None
        self._features = None
        self._id = None
        self._name = None
        self._origin = None
        self._role = None
        self._triggers = None
        self.discriminator = None

        self.client_ctx = client_ctx
        if features is not None:
            self.features = features
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if origin is not None:
            self.origin = origin
        if role is not None:
            self.role = role
        if triggers is not None:
            self.triggers = triggers

    @property
    def client_ctx(self):
        # type: () -> str
        """Gets the client_ctx of this ListeningModeProps.  # noqa: E501

        An optional generic string property supplied from the client. If provided, it will be stored without changes. If not supplied, any current clientCtx will remain unchanged.   # noqa: E501

        :return: The client_ctx of this ListeningModeProps.  # noqa: E501
        :rtype: str
        """
        return self._client_ctx

    @client_ctx.setter
    def client_ctx(self, client_ctx):
        # type: (str) -> None
        """Sets the client_ctx of this ListeningModeProps.

        An optional generic string property supplied from the client. If provided, it will be stored without changes. If not supplied, any current clientCtx will remain unchanged.   # noqa: E501

        :param client_ctx: The client_ctx of this ListeningModeProps.  # noqa: E501
        :type client_ctx: str
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and client_ctx is not None
            and len(client_ctx) > 4096
        ):
            raise ValueError(
                "Invalid value for `client_ctx`, length must be less than or equal to `4096`"
            )  # noqa: E501

        self._client_ctx = client_ctx

    @property
    def features(self):
        # type: () -> ListeningModeFeatures
        """Gets the features of this ListeningModeProps.  # noqa: E501


        :return: The features of this ListeningModeProps.  # noqa: E501
        :rtype: ListeningModeFeatures
        """
        return self._features

    @features.setter
    def features(self, features):
        # type: (ListeningModeFeatures) -> None
        """Sets the features of this ListeningModeProps.


        :param features: The features of this ListeningModeProps.  # noqa: E501
        :type features: ListeningModeFeatures
        :rtype: None
        """

        self._features = features

    @property
    def id(self):
        # type: () -> int
        """Gets the id of this ListeningModeProps.  # noqa: E501


        :return: The id of this ListeningModeProps.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        # type: (int) -> None
        """Sets the id of this ListeningModeProps.


        :param id: The id of this ListeningModeProps.  # noqa: E501
        :type id: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and id is not None
            and id < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `id`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._id = id

    @property
    def name(self):
        # type: () -> str
        """Gets the name of this ListeningModeProps.  # noqa: E501

        Friendly name  # noqa: E501

        :return: The name of this ListeningModeProps.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        # type: (str) -> None
        """Sets the name of this ListeningModeProps.

        Friendly name  # noqa: E501

        :param name: The name of this ListeningModeProps.  # noqa: E501
        :type name: str
        :rtype: None
        """

        self._name = name

    LTypeOrigin = Literal["user", "default", "edited"]

    @property
    def origin(self):
        # type: () -> 'ListeningModeProps.LTypeOrigin'
        """Gets the origin of this ListeningModeProps.  # noqa: E501

        User created, default or an edited default listening mode  # noqa: E501

        :return: The origin of this ListeningModeProps.  # noqa: E501
        :rtype: 'ListeningModeProps.LTypeOrigin'
        """
        return self._origin

    @origin.setter
    def origin(self, origin):
        # type: ('ListeningModeProps.LTypeOrigin') -> None
        """Sets the origin of this ListeningModeProps.

        User created, default or an edited default listening mode  # noqa: E501

        :param origin: The origin of this ListeningModeProps.  # noqa: E501
        :type origin: 'ListeningModeProps.LTypeOrigin'
        :rtype: None
        """
        allowed_values = ["user", "default", "edited"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and origin not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `origin` ({0}), must be one of {1}".format(  # noqa: E501
                    origin, allowed_values
                )
            )

        self._origin = origin

    LTypeRole = Literal["standalone", "multichannel"]

    @property
    def role(self):
        # type: () -> 'ListeningModeProps.LTypeRole'
        """Gets the role of this ListeningModeProps.  # noqa: E501

        Role a listening mode applies to  # noqa: E501

        :return: The role of this ListeningModeProps.  # noqa: E501
        :rtype: 'ListeningModeProps.LTypeRole'
        """
        return self._role

    @role.setter
    def role(self, role):
        # type: ('ListeningModeProps.LTypeRole') -> None
        """Sets the role of this ListeningModeProps.

        Role a listening mode applies to  # noqa: E501

        :param role: The role of this ListeningModeProps.  # noqa: E501
        :type role: 'ListeningModeProps.LTypeRole'
        :rtype: None
        """
        allowed_values = ["standalone", "multichannel"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and role not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `role` ({0}), must be one of {1}".format(  # noqa: E501
                    role, allowed_values
                )
            )

        self._role = role

    @property
    def triggers(self):
        # type: () -> List[ListeningModeTrigger]
        """Gets the triggers of this ListeningModeProps.  # noqa: E501


        :return: The triggers of this ListeningModeProps.  # noqa: E501
        :rtype: List[ListeningModeTrigger]
        """
        return self._triggers

    @triggers.setter
    def triggers(self, triggers):
        # type: (list[ListeningModeTrigger]) -> None
        """Sets the triggers of this ListeningModeProps.


        :param triggers: The triggers of this ListeningModeProps.  # noqa: E501
        :type triggers: list[ListeningModeTrigger]
        :rtype: None
        """

        self._triggers = triggers

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ListeningModeProps):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ListeningModeProps):
            return True

        return self.to_dict() != other.to_dict()
