# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.overlay_play_request_from_usb_from_usb import (
    OverlayPlayRequestFromUsbFromUsb,
)
from mozart_api.models.uri import Uri
from mozart_api.models.overlay_play_request_text_to_speech_text_to_speech import (
    OverlayPlayRequestTextToSpeechTextToSpeech,
)

from mozart_api.configuration import Configuration


class OverlayPlayRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "volume_absolute": "int",
        "uri": "Uri",
        "text_to_speech": "OverlayPlayRequestTextToSpeechTextToSpeech",
        "from_usb": "OverlayPlayRequestFromUsbFromUsb",
    }

    attribute_map = {
        "volume_absolute": "volumeAbsolute",
        "uri": "uri",
        "text_to_speech": "textToSpeech",
        "from_usb": "fromUsb",
    }

    def __init__(
        self,
        volume_absolute: Optional[int] = None,
        uri: Optional[Uri] = None,
        text_to_speech: Optional[OverlayPlayRequestTextToSpeechTextToSpeech] = None,
        from_usb: Optional[OverlayPlayRequestFromUsbFromUsb] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """OverlayPlayRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._volume_absolute = None
        self._uri = None
        self._text_to_speech = None
        self._from_usb = None
        self.discriminator = None

        self.volume_absolute = volume_absolute
        if uri is not None:
            self.uri = uri
        if text_to_speech is not None:
            self.text_to_speech = text_to_speech
        if from_usb is not None:
            self.from_usb = from_usb

    @property
    def volume_absolute(self):
        # type: () -> int
        """Gets the volume_absolute of this OverlayPlayRequest.  # noqa: E501

        An optional absolute volume level at which to play the URI. If not provided, the URI will play at the currently configured volume level on the product. The level should be provided in volume steps [0, 100]   # noqa: E501

        :return: The volume_absolute of this OverlayPlayRequest.  # noqa: E501
        :rtype: int
        """
        return self._volume_absolute

    @volume_absolute.setter
    def volume_absolute(self, volume_absolute):
        # type: (int) -> None
        """Sets the volume_absolute of this OverlayPlayRequest.

        An optional absolute volume level at which to play the URI. If not provided, the URI will play at the currently configured volume level on the product. The level should be provided in volume steps [0, 100]   # noqa: E501

        :param volume_absolute: The volume_absolute of this OverlayPlayRequest.  # noqa: E501
        :type volume_absolute: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and volume_absolute is not None
            and volume_absolute > 100
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `volume_absolute`, must be a value less than or equal to `100`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and volume_absolute is not None
            and volume_absolute < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `volume_absolute`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._volume_absolute = volume_absolute

    @property
    def uri(self):
        # type: () -> Uri
        """Gets the uri of this OverlayPlayRequest.  # noqa: E501


        :return: The uri of this OverlayPlayRequest.  # noqa: E501
        :rtype: Uri
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        # type: (Uri) -> None
        """Sets the uri of this OverlayPlayRequest.


        :param uri: The uri of this OverlayPlayRequest.  # noqa: E501
        :type uri: Uri
        :rtype: None
        """

        self._uri = uri

    @property
    def text_to_speech(self):
        # type: () -> OverlayPlayRequestTextToSpeechTextToSpeech
        """Gets the text_to_speech of this OverlayPlayRequest.  # noqa: E501


        :return: The text_to_speech of this OverlayPlayRequest.  # noqa: E501
        :rtype: OverlayPlayRequestTextToSpeechTextToSpeech
        """
        return self._text_to_speech

    @text_to_speech.setter
    def text_to_speech(self, text_to_speech):
        # type: (OverlayPlayRequestTextToSpeechTextToSpeech) -> None
        """Sets the text_to_speech of this OverlayPlayRequest.


        :param text_to_speech: The text_to_speech of this OverlayPlayRequest.  # noqa: E501
        :type text_to_speech: OverlayPlayRequestTextToSpeechTextToSpeech
        :rtype: None
        """

        self._text_to_speech = text_to_speech

    @property
    def from_usb(self):
        # type: () -> OverlayPlayRequestFromUsbFromUsb
        """Gets the from_usb of this OverlayPlayRequest.  # noqa: E501


        :return: The from_usb of this OverlayPlayRequest.  # noqa: E501
        :rtype: OverlayPlayRequestFromUsbFromUsb
        """
        return self._from_usb

    @from_usb.setter
    def from_usb(self, from_usb):
        # type: (OverlayPlayRequestFromUsbFromUsb) -> None
        """Sets the from_usb of this OverlayPlayRequest.


        :param from_usb: The from_usb of this OverlayPlayRequest.  # noqa: E501
        :type from_usb: OverlayPlayRequestFromUsbFromUsb
        :rtype: None
        """

        self._from_usb = from_usb

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OverlayPlayRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OverlayPlayRequest):
            return True

        return self.to_dict() != other.to_dict()
