# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional


from mozart_api.configuration import Configuration


class OverlayPlayRequestCommon(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"volume_absolute": "int"}

    attribute_map = {"volume_absolute": "volumeAbsolute"}

    def __init__(
        self, volume_absolute: Optional[int] = None, local_vars_configuration=None
    ):  # noqa: E501
        """OverlayPlayRequestCommon - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._volume_absolute = None
        self.discriminator = None

        self.volume_absolute = volume_absolute

    @property
    def volume_absolute(self):
        # type: () -> int
        """Gets the volume_absolute of this OverlayPlayRequestCommon.  # noqa: E501

        An optional absolute volume level at which to play the URI. If not provided, the URI will play at the currently configured volume level on the product. The level should be provided in volume steps [0, 100]   # noqa: E501

        :return: The volume_absolute of this OverlayPlayRequestCommon.  # noqa: E501
        :rtype: int
        """
        return self._volume_absolute

    @volume_absolute.setter
    def volume_absolute(self, volume_absolute):
        # type: (int) -> None
        """Sets the volume_absolute of this OverlayPlayRequestCommon.

        An optional absolute volume level at which to play the URI. If not provided, the URI will play at the currently configured volume level on the product. The level should be provided in volume steps [0, 100]   # noqa: E501

        :param volume_absolute: The volume_absolute of this OverlayPlayRequestCommon.  # noqa: E501
        :type volume_absolute: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and volume_absolute is not None
            and volume_absolute > 100
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `volume_absolute`, must be a value less than or equal to `100`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and volume_absolute is not None
            and volume_absolute < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `volume_absolute`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._volume_absolute = volume_absolute

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OverlayPlayRequestCommon):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OverlayPlayRequestCommon):
            return True

        return self.to_dict() != other.to_dict()
