# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.playback_content_metadata import PlaybackContentMetadata
from mozart_api.models.play_queue_item_type import PlayQueueItemType

from mozart_api.configuration import Configuration


class PlayQueueItem(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "index": "int",
        "metadata": "PlaybackContentMetadata",
        "provider": "PlayQueueItemType",
        "start_now_from_position": "int",
        "type": "str",
        "uri": "str",
    }

    attribute_map = {
        "index": "index",
        "metadata": "metadata",
        "provider": "provider",
        "start_now_from_position": "startNowFromPosition",
        "type": "type",
        "uri": "uri",
    }

    def __init__(
        self,
        index: Optional[int] = None,
        metadata: Optional[PlaybackContentMetadata] = None,
        provider: Optional[PlayQueueItemType] = None,
        start_now_from_position: Optional[int] = None,
        type: Optional["PlayQueueItem.LTypeType"] = None,
        uri: Optional[str] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """PlayQueueItem - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._index = None
        self._metadata = None
        self._provider = None
        self._start_now_from_position = None
        self._type = None
        self._uri = None
        self.discriminator = None

        if index is not None:
            self.index = index
        if metadata is not None:
            self.metadata = metadata
        self.provider = provider
        self.start_now_from_position = start_now_from_position
        self.type = type
        self.uri = uri

    @property
    def index(self):
        # type: () -> int
        """Gets the index of this PlayQueueItem.  # noqa: E501


        :return: The index of this PlayQueueItem.  # noqa: E501
        :rtype: int
        """
        return self._index

    @index.setter
    def index(self, index):
        # type: (int) -> None
        """Sets the index of this PlayQueueItem.


        :param index: The index of this PlayQueueItem.  # noqa: E501
        :type index: int
        :rtype: None
        """

        self._index = index

    @property
    def metadata(self):
        # type: () -> PlaybackContentMetadata
        """Gets the metadata of this PlayQueueItem.  # noqa: E501


        :return: The metadata of this PlayQueueItem.  # noqa: E501
        :rtype: PlaybackContentMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        # type: (PlaybackContentMetadata) -> None
        """Sets the metadata of this PlayQueueItem.


        :param metadata: The metadata of this PlayQueueItem.  # noqa: E501
        :type metadata: PlaybackContentMetadata
        :rtype: None
        """

        self._metadata = metadata

    @property
    def provider(self):
        # type: () -> PlayQueueItemType
        """Gets the provider of this PlayQueueItem.  # noqa: E501


        :return: The provider of this PlayQueueItem.  # noqa: E501
        :rtype: PlayQueueItemType
        """
        return self._provider

    @provider.setter
    def provider(self, provider):
        # type: (PlayQueueItemType) -> None
        """Sets the provider of this PlayQueueItem.


        :param provider: The provider of this PlayQueueItem.  # noqa: E501
        :type provider: PlayQueueItemType
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and provider is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `provider`, must not be `None`"
            )  # noqa: E501

        self._provider = provider

    @property
    def start_now_from_position(self):
        # type: () -> int
        """Gets the start_now_from_position of this PlayQueueItem.  # noqa: E501

        Start playing specified track as soon as possible. This works for any type, for `track` set to 0 and for `playlist` specify the wanted track from position 0  # noqa: E501

        :return: The start_now_from_position of this PlayQueueItem.  # noqa: E501
        :rtype: int
        """
        return self._start_now_from_position

    @start_now_from_position.setter
    def start_now_from_position(self, start_now_from_position):
        # type: (int) -> None
        """Sets the start_now_from_position of this PlayQueueItem.

        Start playing specified track as soon as possible. This works for any type, for `track` set to 0 and for `playlist` specify the wanted track from position 0  # noqa: E501

        :param start_now_from_position: The start_now_from_position of this PlayQueueItem.  # noqa: E501
        :type start_now_from_position: int
        :rtype: None
        """

        self._start_now_from_position = start_now_from_position

    LTypeType = Literal["track", "playlist"]

    @property
    def type(self):
        # type: () -> 'PlayQueueItem.LTypeType'
        """Gets the type of this PlayQueueItem.  # noqa: E501


        :return: The type of this PlayQueueItem.  # noqa: E501
        :rtype: 'PlayQueueItem.LTypeType'
        """
        return self._type

    @type.setter
    def type(self, type):
        # type: ('PlayQueueItem.LTypeType') -> None
        """Sets the type of this PlayQueueItem.


        :param type: The type of this PlayQueueItem.  # noqa: E501
        :type type: 'PlayQueueItem.LTypeType'
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and type is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `type`, must not be `None`"
            )  # noqa: E501
        allowed_values = ["track", "playlist"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and type not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}".format(  # noqa: E501
                    type, allowed_values
                )
            )

        self._type = type

    @property
    def uri(self):
        # type: () -> str
        """Gets the uri of this PlayQueueItem.  # noqa: E501

        This can be url, track id, playlist id, radio id and suchlike  # noqa: E501

        :return: The uri of this PlayQueueItem.  # noqa: E501
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        # type: (str) -> None
        """Sets the uri of this PlayQueueItem.

        This can be url, track id, playlist id, radio id and suchlike  # noqa: E501

        :param uri: The uri of this PlayQueueItem.  # noqa: E501
        :type uri: str
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and uri is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `uri`, must not be `None`"
            )  # noqa: E501

        self._uri = uri

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PlayQueueItem):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PlayQueueItem):
            return True

        return self.to_dict() != other.to_dict()
