# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional


from mozart_api.configuration import Configuration


class PlayQueueSettings(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "consume": "bool",
        "gapless": "bool",
        "repeat": "str",
        "shuffle": "bool",
    }

    attribute_map = {
        "consume": "consume",
        "gapless": "gapless",
        "repeat": "repeat",
        "shuffle": "shuffle",
    }

    def __init__(
        self,
        consume: Optional[bool] = None,
        gapless: Optional[bool] = None,
        repeat: Optional["PlayQueueSettings.LTypeRepeat"] = None,
        shuffle: Optional[bool] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """PlayQueueSettings - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._consume = None
        self._gapless = None
        self._repeat = None
        self._shuffle = None
        self.discriminator = None

        if consume is not None:
            self.consume = consume
        if gapless is not None:
            self.gapless = gapless
        if repeat is not None:
            self.repeat = repeat
        if shuffle is not None:
            self.shuffle = shuffle

    @property
    def consume(self):
        # type: () -> bool
        """Gets the consume of this PlayQueueSettings.  # noqa: E501


        :return: The consume of this PlayQueueSettings.  # noqa: E501
        :rtype: bool
        """
        return self._consume

    @consume.setter
    def consume(self, consume):
        # type: (bool) -> None
        """Sets the consume of this PlayQueueSettings.


        :param consume: The consume of this PlayQueueSettings.  # noqa: E501
        :type consume: bool
        :rtype: None
        """

        self._consume = consume

    @property
    def gapless(self):
        # type: () -> bool
        """Gets the gapless of this PlayQueueSettings.  # noqa: E501


        :return: The gapless of this PlayQueueSettings.  # noqa: E501
        :rtype: bool
        """
        return self._gapless

    @gapless.setter
    def gapless(self, gapless):
        # type: (bool) -> None
        """Sets the gapless of this PlayQueueSettings.


        :param gapless: The gapless of this PlayQueueSettings.  # noqa: E501
        :type gapless: bool
        :rtype: None
        """

        self._gapless = gapless

    LTypeRepeat = Literal["all", "track", "none"]

    @property
    def repeat(self):
        # type: () -> 'PlayQueueSettings.LTypeRepeat'
        """Gets the repeat of this PlayQueueSettings.  # noqa: E501


        :return: The repeat of this PlayQueueSettings.  # noqa: E501
        :rtype: 'PlayQueueSettings.LTypeRepeat'
        """
        return self._repeat

    @repeat.setter
    def repeat(self, repeat):
        # type: ('PlayQueueSettings.LTypeRepeat') -> None
        """Sets the repeat of this PlayQueueSettings.


        :param repeat: The repeat of this PlayQueueSettings.  # noqa: E501
        :type repeat: 'PlayQueueSettings.LTypeRepeat'
        :rtype: None
        """
        allowed_values = ["all", "track", "none"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and repeat not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `repeat` ({0}), must be one of {1}".format(  # noqa: E501
                    repeat, allowed_values
                )
            )

        self._repeat = repeat

    @property
    def shuffle(self):
        # type: () -> bool
        """Gets the shuffle of this PlayQueueSettings.  # noqa: E501


        :return: The shuffle of this PlayQueueSettings.  # noqa: E501
        :rtype: bool
        """
        return self._shuffle

    @shuffle.setter
    def shuffle(self, shuffle):
        # type: (bool) -> None
        """Sets the shuffle of this PlayQueueSettings.


        :param shuffle: The shuffle of this PlayQueueSettings.  # noqa: E501
        :type shuffle: bool
        :rtype: None
        """

        self._shuffle = shuffle

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PlayQueueSettings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PlayQueueSettings):
            return True

        return self.to_dict() != other.to_dict()
