# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.art import Art
from mozart_api.models.beolink_leader import BeolinkLeader

from mozart_api.configuration import Configuration


class PlaybackContentMetadata(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "album_name": "str",
        "art": "list[Art]",
        "artist_name": "str",
        "bitdepth": "int",
        "bitrate": "int",
        "container_name": "str",
        "encoding": "str",
        "genre": "str",
        "id": "int",
        "input_channel_processing": "str",
        "input_channels": "str",
        "organization": "str",
        "output_channel_processing": "str",
        "output_channels": "str",
        "queue_id": "str",
        "remote_leader": "BeolinkLeader",
        "remote_source": "str",
        "samplerate": "int",
        "source": "str",
        "source_internal_id": "str",
        "title": "str",
        "total_duration": "int",
        "total_duration_seconds": "int",
        "track": "int",
        "track_count": "int",
        "uri": "str",
    }

    attribute_map = {
        "album_name": "albumName",
        "art": "art",
        "artist_name": "artistName",
        "bitdepth": "bitdepth",
        "bitrate": "bitrate",
        "container_name": "containerName",
        "encoding": "encoding",
        "genre": "genre",
        "id": "id",
        "input_channel_processing": "inputChannelProcessing",
        "input_channels": "inputChannels",
        "organization": "organization",
        "output_channel_processing": "outputChannelProcessing",
        "output_channels": "outputChannels",
        "queue_id": "queueId",
        "remote_leader": "remoteLeader",
        "remote_source": "remoteSource",
        "samplerate": "samplerate",
        "source": "source",
        "source_internal_id": "sourceInternalId",
        "title": "title",
        "total_duration": "totalDuration",
        "total_duration_seconds": "totalDurationSeconds",
        "track": "track",
        "track_count": "trackCount",
        "uri": "uri",
    }

    def __init__(
        self,
        album_name: Optional[str] = None,
        art: Optional[List[Art]] = None,
        artist_name: Optional[str] = None,
        bitdepth: Optional[int] = None,
        bitrate: Optional[int] = None,
        container_name: Optional[str] = None,
        encoding: Optional["PlaybackContentMetadata.LTypeEncoding"] = None,
        genre: Optional[str] = None,
        id: Optional[int] = None,
        input_channel_processing: Optional[str] = None,
        input_channels: Optional[str] = None,
        organization: Optional[str] = None,
        output_channel_processing: Optional[str] = None,
        output_channels: Optional[str] = None,
        queue_id: Optional[str] = None,
        remote_leader: Optional[BeolinkLeader] = None,
        remote_source: Optional[str] = None,
        samplerate: Optional[int] = None,
        source: Optional[str] = None,
        source_internal_id: Optional[str] = None,
        title: Optional[str] = None,
        total_duration: Optional[int] = None,
        total_duration_seconds: Optional[int] = None,
        track: Optional[int] = None,
        track_count: Optional[int] = None,
        uri: Optional[str] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """PlaybackContentMetadata - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._album_name = None
        self._art = None
        self._artist_name = None
        self._bitdepth = None
        self._bitrate = None
        self._container_name = None
        self._encoding = None
        self._genre = None
        self._id = None
        self._input_channel_processing = None
        self._input_channels = None
        self._organization = None
        self._output_channel_processing = None
        self._output_channels = None
        self._queue_id = None
        self._remote_leader = None
        self._remote_source = None
        self._samplerate = None
        self._source = None
        self._source_internal_id = None
        self._title = None
        self._total_duration = None
        self._total_duration_seconds = None
        self._track = None
        self._track_count = None
        self._uri = None
        self.discriminator = None

        if album_name is not None:
            self.album_name = album_name
        if art is not None:
            self.art = art
        if artist_name is not None:
            self.artist_name = artist_name
        if bitdepth is not None:
            self.bitdepth = bitdepth
        if bitrate is not None:
            self.bitrate = bitrate
        if container_name is not None:
            self.container_name = container_name
        if encoding is not None:
            self.encoding = encoding
        if genre is not None:
            self.genre = genre
        if id is not None:
            self.id = id
        self.input_channel_processing = input_channel_processing
        self.input_channels = input_channels
        if organization is not None:
            self.organization = organization
        self.output_channel_processing = output_channel_processing
        self.output_channels = output_channels
        if queue_id is not None:
            self.queue_id = queue_id
        if remote_leader is not None:
            self.remote_leader = remote_leader
        self.remote_source = remote_source
        if samplerate is not None:
            self.samplerate = samplerate
        if source is not None:
            self.source = source
        if source_internal_id is not None:
            self.source_internal_id = source_internal_id
        if title is not None:
            self.title = title
        self.total_duration = total_duration
        self.total_duration_seconds = total_duration_seconds
        if track is not None:
            self.track = track
        if track_count is not None:
            self.track_count = track_count
        if uri is not None:
            self.uri = uri

    @property
    def album_name(self):
        # type: () -> str
        """Gets the album_name of this PlaybackContentMetadata.  # noqa: E501


        :return: The album_name of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._album_name

    @album_name.setter
    def album_name(self, album_name):
        # type: (str) -> None
        """Sets the album_name of this PlaybackContentMetadata.


        :param album_name: The album_name of this PlaybackContentMetadata.  # noqa: E501
        :type album_name: str
        :rtype: None
        """

        self._album_name = album_name

    @property
    def art(self):
        # type: () -> List[Art]
        """Gets the art of this PlaybackContentMetadata.  # noqa: E501


        :return: The art of this PlaybackContentMetadata.  # noqa: E501
        :rtype: List[Art]
        """
        return self._art

    @art.setter
    def art(self, art):
        # type: (list[Art]) -> None
        """Sets the art of this PlaybackContentMetadata.


        :param art: The art of this PlaybackContentMetadata.  # noqa: E501
        :type art: list[Art]
        :rtype: None
        """

        self._art = art

    @property
    def artist_name(self):
        # type: () -> str
        """Gets the artist_name of this PlaybackContentMetadata.  # noqa: E501


        :return: The artist_name of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._artist_name

    @artist_name.setter
    def artist_name(self, artist_name):
        # type: (str) -> None
        """Sets the artist_name of this PlaybackContentMetadata.


        :param artist_name: The artist_name of this PlaybackContentMetadata.  # noqa: E501
        :type artist_name: str
        :rtype: None
        """

        self._artist_name = artist_name

    @property
    def bitdepth(self):
        # type: () -> int
        """Gets the bitdepth of this PlaybackContentMetadata.  # noqa: E501


        :return: The bitdepth of this PlaybackContentMetadata.  # noqa: E501
        :rtype: int
        """
        return self._bitdepth

    @bitdepth.setter
    def bitdepth(self, bitdepth):
        # type: (int) -> None
        """Sets the bitdepth of this PlaybackContentMetadata.


        :param bitdepth: The bitdepth of this PlaybackContentMetadata.  # noqa: E501
        :type bitdepth: int
        :rtype: None
        """

        self._bitdepth = bitdepth

    @property
    def bitrate(self):
        # type: () -> int
        """Gets the bitrate of this PlaybackContentMetadata.  # noqa: E501


        :return: The bitrate of this PlaybackContentMetadata.  # noqa: E501
        :rtype: int
        """
        return self._bitrate

    @bitrate.setter
    def bitrate(self, bitrate):
        # type: (int) -> None
        """Sets the bitrate of this PlaybackContentMetadata.


        :param bitrate: The bitrate of this PlaybackContentMetadata.  # noqa: E501
        :type bitrate: int
        :rtype: None
        """

        self._bitrate = bitrate

    @property
    def container_name(self):
        # type: () -> str
        """Gets the container_name of this PlaybackContentMetadata.  # noqa: E501


        :return: The container_name of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._container_name

    @container_name.setter
    def container_name(self, container_name):
        # type: (str) -> None
        """Sets the container_name of this PlaybackContentMetadata.


        :param container_name: The container_name of this PlaybackContentMetadata.  # noqa: E501
        :type container_name: str
        :rtype: None
        """

        self._container_name = container_name

    LTypeEncoding = Literal[
        "pcm",
        "wav",
        "mp3",
        "oggvorbis",
        "aac",
        "flac",
        "sbc",
        "alac",
        "opus",
        "DolbyDigital",
        "DolbyDigitalPlus",
        "DolbyTrueHD",
        "unknown",
    ]

    @property
    def encoding(self):
        # type: () -> 'PlaybackContentMetadata.LTypeEncoding'
        """Gets the encoding of this PlaybackContentMetadata.  # noqa: E501


        :return: The encoding of this PlaybackContentMetadata.  # noqa: E501
        :rtype: 'PlaybackContentMetadata.LTypeEncoding'
        """
        return self._encoding

    @encoding.setter
    def encoding(self, encoding):
        # type: ('PlaybackContentMetadata.LTypeEncoding') -> None
        """Sets the encoding of this PlaybackContentMetadata.


        :param encoding: The encoding of this PlaybackContentMetadata.  # noqa: E501
        :type encoding: 'PlaybackContentMetadata.LTypeEncoding'
        :rtype: None
        """
        allowed_values = [
            "pcm",
            "wav",
            "mp3",
            "oggvorbis",
            "aac",
            "flac",
            "sbc",
            "alac",
            "opus",
            "DolbyDigital",
            "DolbyDigitalPlus",
            "DolbyTrueHD",
            "unknown",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and encoding not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `encoding` ({0}), must be one of {1}".format(  # noqa: E501
                    encoding, allowed_values
                )
            )

        self._encoding = encoding

    @property
    def genre(self):
        # type: () -> str
        """Gets the genre of this PlaybackContentMetadata.  # noqa: E501


        :return: The genre of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._genre

    @genre.setter
    def genre(self, genre):
        # type: (str) -> None
        """Sets the genre of this PlaybackContentMetadata.


        :param genre: The genre of this PlaybackContentMetadata.  # noqa: E501
        :type genre: str
        :rtype: None
        """

        self._genre = genre

    @property
    def id(self):
        # type: () -> int
        """Gets the id of this PlaybackContentMetadata.  # noqa: E501


        :return: The id of this PlaybackContentMetadata.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        # type: (int) -> None
        """Sets the id of this PlaybackContentMetadata.


        :param id: The id of this PlaybackContentMetadata.  # noqa: E501
        :type id: int
        :rtype: None
        """

        self._id = id

    @property
    def input_channel_processing(self):
        # type: () -> str
        """Gets the input_channel_processing of this PlaybackContentMetadata.  # noqa: E501

        Input processing/decoding on top of the base codec indicated in encoding. E.g. Dolby Atmos on top of Dolby TrueHD or Dolby Surround on top of PCM. For Dolby, this value has priority over encoding, meaning that if inputChannelProcessing has a value, it must be indicated in the app, and optionally the encoding value can be indicated as well. If inputChannelProcessing does not have value the encoding value must be indicated.   # noqa: E501

        :return: The input_channel_processing of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._input_channel_processing

    @input_channel_processing.setter
    def input_channel_processing(self, input_channel_processing):
        # type: (str) -> None
        """Sets the input_channel_processing of this PlaybackContentMetadata.

        Input processing/decoding on top of the base codec indicated in encoding. E.g. Dolby Atmos on top of Dolby TrueHD or Dolby Surround on top of PCM. For Dolby, this value has priority over encoding, meaning that if inputChannelProcessing has a value, it must be indicated in the app, and optionally the encoding value can be indicated as well. If inputChannelProcessing does not have value the encoding value must be indicated.   # noqa: E501

        :param input_channel_processing: The input_channel_processing of this PlaybackContentMetadata.  # noqa: E501
        :type input_channel_processing: str
        :rtype: None
        """
        allowed_values = [None, "dolbySurround", "dolbyAtmos"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and input_channel_processing not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `input_channel_processing` ({0}), must be one of {1}".format(  # noqa: E501
                    input_channel_processing, allowed_values
                )
            )

        self._input_channel_processing = input_channel_processing

    @property
    def input_channels(self):
        # type: () -> str
        """Gets the input_channels of this PlaybackContentMetadata.  # noqa: E501

        e.g. 5.1  # noqa: E501

        :return: The input_channels of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._input_channels

    @input_channels.setter
    def input_channels(self, input_channels):
        # type: (str) -> None
        """Sets the input_channels of this PlaybackContentMetadata.

        e.g. 5.1  # noqa: E501

        :param input_channels: The input_channels of this PlaybackContentMetadata.  # noqa: E501
        :type input_channels: str
        :rtype: None
        """

        self._input_channels = input_channels

    @property
    def organization(self):
        # type: () -> str
        """Gets the organization of this PlaybackContentMetadata.  # noqa: E501

        This can be filled by gstreamers GST_TAG_ORGANIZATION. Mozart can also fill this with netradio station name like \"P3\" and TV content like \"Netflix\". This is needed so it's possible to show who the provider is for the playing audio track/content.   # noqa: E501

        :return: The organization of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        # type: (str) -> None
        """Sets the organization of this PlaybackContentMetadata.

        This can be filled by gstreamers GST_TAG_ORGANIZATION. Mozart can also fill this with netradio station name like \"P3\" and TV content like \"Netflix\". This is needed so it's possible to show who the provider is for the playing audio track/content.   # noqa: E501

        :param organization: The organization of this PlaybackContentMetadata.  # noqa: E501
        :type organization: str
        :rtype: None
        """

        self._organization = organization

    @property
    def output_channel_processing(self):
        # type: () -> str
        """Gets the output_channel_processing of this PlaybackContentMetadata.  # noqa: E501

        e.g. downmix  # noqa: E501

        :return: The output_channel_processing of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._output_channel_processing

    @output_channel_processing.setter
    def output_channel_processing(self, output_channel_processing):
        # type: (str) -> None
        """Sets the output_channel_processing of this PlaybackContentMetadata.

        e.g. downmix  # noqa: E501

        :param output_channel_processing: The output_channel_processing of this PlaybackContentMetadata.  # noqa: E501
        :type output_channel_processing: str
        :rtype: None
        """
        allowed_values = [None, "Direct", "Downmix", "TrueImage"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and output_channel_processing not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `output_channel_processing` ({0}), must be one of {1}".format(  # noqa: E501
                    output_channel_processing, allowed_values
                )
            )

        self._output_channel_processing = output_channel_processing

    @property
    def output_channels(self):
        # type: () -> str
        """Gets the output_channels of this PlaybackContentMetadata.  # noqa: E501

        e.g. 7.1  # noqa: E501

        :return: The output_channels of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._output_channels

    @output_channels.setter
    def output_channels(self, output_channels):
        # type: (str) -> None
        """Sets the output_channels of this PlaybackContentMetadata.

        e.g. 7.1  # noqa: E501

        :param output_channels: The output_channels of this PlaybackContentMetadata.  # noqa: E501
        :type output_channels: str
        :rtype: None
        """

        self._output_channels = output_channels

    @property
    def queue_id(self):
        # type: () -> str
        """Gets the queue_id of this PlaybackContentMetadata.  # noqa: E501


        :return: The queue_id of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id):
        # type: (str) -> None
        """Sets the queue_id of this PlaybackContentMetadata.


        :param queue_id: The queue_id of this PlaybackContentMetadata.  # noqa: E501
        :type queue_id: str
        :rtype: None
        """

        self._queue_id = queue_id

    @property
    def remote_leader(self):
        # type: () -> BeolinkLeader
        """Gets the remote_leader of this PlaybackContentMetadata.  # noqa: E501


        :return: The remote_leader of this PlaybackContentMetadata.  # noqa: E501
        :rtype: BeolinkLeader
        """
        return self._remote_leader

    @remote_leader.setter
    def remote_leader(self, remote_leader):
        # type: (BeolinkLeader) -> None
        """Sets the remote_leader of this PlaybackContentMetadata.


        :param remote_leader: The remote_leader of this PlaybackContentMetadata.  # noqa: E501
        :type remote_leader: BeolinkLeader
        :rtype: None
        """

        self._remote_leader = remote_leader

    @property
    def remote_source(self):
        # type: () -> str
        """Gets the remote_source of this PlaybackContentMetadata.  # noqa: E501


        :return: The remote_source of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._remote_source

    @remote_source.setter
    def remote_source(self, remote_source):
        # type: (str) -> None
        """Sets the remote_source of this PlaybackContentMetadata.


        :param remote_source: The remote_source of this PlaybackContentMetadata.  # noqa: E501
        :type remote_source: str
        :rtype: None
        """

        self._remote_source = remote_source

    @property
    def samplerate(self):
        # type: () -> int
        """Gets the samplerate of this PlaybackContentMetadata.  # noqa: E501


        :return: The samplerate of this PlaybackContentMetadata.  # noqa: E501
        :rtype: int
        """
        return self._samplerate

    @samplerate.setter
    def samplerate(self, samplerate):
        # type: (int) -> None
        """Sets the samplerate of this PlaybackContentMetadata.


        :param samplerate: The samplerate of this PlaybackContentMetadata.  # noqa: E501
        :type samplerate: int
        :rtype: None
        """

        self._samplerate = samplerate

    @property
    def source(self):
        # type: () -> str
        """Gets the source of this PlaybackContentMetadata.  # noqa: E501


        :return: The source of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        # type: (str) -> None
        """Sets the source of this PlaybackContentMetadata.


        :param source: The source of this PlaybackContentMetadata.  # noqa: E501
        :type source: str
        :rtype: None
        """

        self._source = source

    @property
    def source_internal_id(self):
        # type: () -> str
        """Gets the source_internal_id of this PlaybackContentMetadata.  # noqa: E501


        :return: The source_internal_id of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._source_internal_id

    @source_internal_id.setter
    def source_internal_id(self, source_internal_id):
        # type: (str) -> None
        """Sets the source_internal_id of this PlaybackContentMetadata.


        :param source_internal_id: The source_internal_id of this PlaybackContentMetadata.  # noqa: E501
        :type source_internal_id: str
        :rtype: None
        """

        self._source_internal_id = source_internal_id

    @property
    def title(self):
        # type: () -> str
        """Gets the title of this PlaybackContentMetadata.  # noqa: E501


        :return: The title of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        # type: (str) -> None
        """Sets the title of this PlaybackContentMetadata.


        :param title: The title of this PlaybackContentMetadata.  # noqa: E501
        :type title: str
        :rtype: None
        """

        self._title = title

    @property
    def total_duration(self):
        # type: () -> int
        """Gets the total_duration of this PlaybackContentMetadata.  # noqa: E501

        to be removed once all devices and apps are updated  # noqa: E501

        :return: The total_duration of this PlaybackContentMetadata.  # noqa: E501
        :rtype: int
        """
        return self._total_duration

    @total_duration.setter
    def total_duration(self, total_duration):
        # type: (int) -> None
        """Sets the total_duration of this PlaybackContentMetadata.

        to be removed once all devices and apps are updated  # noqa: E501

        :param total_duration: The total_duration of this PlaybackContentMetadata.  # noqa: E501
        :type total_duration: int
        :rtype: None
        """

        self._total_duration = total_duration

    @property
    def total_duration_seconds(self):
        # type: () -> int
        """Gets the total_duration_seconds of this PlaybackContentMetadata.  # noqa: E501


        :return: The total_duration_seconds of this PlaybackContentMetadata.  # noqa: E501
        :rtype: int
        """
        return self._total_duration_seconds

    @total_duration_seconds.setter
    def total_duration_seconds(self, total_duration_seconds):
        # type: (int) -> None
        """Sets the total_duration_seconds of this PlaybackContentMetadata.


        :param total_duration_seconds: The total_duration_seconds of this PlaybackContentMetadata.  # noqa: E501
        :type total_duration_seconds: int
        :rtype: None
        """

        self._total_duration_seconds = total_duration_seconds

    @property
    def track(self):
        # type: () -> int
        """Gets the track of this PlaybackContentMetadata.  # noqa: E501


        :return: The track of this PlaybackContentMetadata.  # noqa: E501
        :rtype: int
        """
        return self._track

    @track.setter
    def track(self, track):
        # type: (int) -> None
        """Sets the track of this PlaybackContentMetadata.


        :param track: The track of this PlaybackContentMetadata.  # noqa: E501
        :type track: int
        :rtype: None
        """

        self._track = track

    @property
    def track_count(self):
        # type: () -> int
        """Gets the track_count of this PlaybackContentMetadata.  # noqa: E501


        :return: The track_count of this PlaybackContentMetadata.  # noqa: E501
        :rtype: int
        """
        return self._track_count

    @track_count.setter
    def track_count(self, track_count):
        # type: (int) -> None
        """Sets the track_count of this PlaybackContentMetadata.


        :param track_count: The track_count of this PlaybackContentMetadata.  # noqa: E501
        :type track_count: int
        :rtype: None
        """

        self._track_count = track_count

    @property
    def uri(self):
        # type: () -> str
        """Gets the uri of this PlaybackContentMetadata.  # noqa: E501


        :return: The uri of this PlaybackContentMetadata.  # noqa: E501
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        # type: (str) -> None
        """Sets the uri of this PlaybackContentMetadata.


        :param uri: The uri of this PlaybackContentMetadata.  # noqa: E501
        :type uri: str
        :rtype: None
        """

        self._uri = uri

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PlaybackContentMetadata):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PlaybackContentMetadata):
            return True

        return self.to_dict() != other.to_dict()
