# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.action import Action
from mozart_api.models.source_type_enum import SourceTypeEnum
from mozart_api.models.content_item import ContentItem

from mozart_api.configuration import Configuration


class Preset(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "action_list": "list[Action]",
        "scene_list": "list[str]",
        "content": "ContentItem",
        "id": "str",
        "name": "str",
        "source": "SourceTypeEnum",
        "title": "str",
    }

    attribute_map = {
        "action_list": "actionList",
        "scene_list": "sceneList",
        "content": "content",
        "id": "id",
        "name": "name",
        "source": "source",
        "title": "title",
    }

    def __init__(
        self,
        action_list: Optional[List[Action]] = None,
        scene_list: Optional[List[str]] = None,
        content: Optional[ContentItem] = None,
        id: Optional[str] = None,
        name: Optional[str] = None,
        source: Optional[SourceTypeEnum] = None,
        title: Optional[str] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """Preset - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._action_list = None
        self._scene_list = None
        self._content = None
        self._id = None
        self._name = None
        self._source = None
        self._title = None
        self.discriminator = None

        if action_list is not None:
            self.action_list = action_list
        if scene_list is not None:
            self.scene_list = scene_list
        if content is not None:
            self.content = content
        if id is not None:
            self.id = id
        self.name = name
        if source is not None:
            self.source = source
        if title is not None:
            self.title = title

    @property
    def action_list(self):
        # type: () -> List[Action]
        """Gets the action_list of this Preset.  # noqa: E501

        An ordered list of Actions to run on the product  # noqa: E501

        :return: The action_list of this Preset.  # noqa: E501
        :rtype: List[Action]
        """
        return self._action_list

    @action_list.setter
    def action_list(self, action_list):
        # type: (list[Action]) -> None
        """Sets the action_list of this Preset.

        An ordered list of Actions to run on the product  # noqa: E501

        :param action_list: The action_list of this Preset.  # noqa: E501
        :type action_list: list[Action]
        :rtype: None
        """

        self._action_list = action_list

    @property
    def scene_list(self):
        # type: () -> List[str]
        """Gets the scene_list of this Preset.  # noqa: E501

        A list of scenes  # noqa: E501

        :return: The scene_list of this Preset.  # noqa: E501
        :rtype: List[str]
        """
        return self._scene_list

    @scene_list.setter
    def scene_list(self, scene_list):
        # type: (list[str]) -> None
        """Sets the scene_list of this Preset.

        A list of scenes  # noqa: E501

        :param scene_list: The scene_list of this Preset.  # noqa: E501
        :type scene_list: list[str]
        :rtype: None
        """

        self._scene_list = scene_list

    @property
    def content(self):
        # type: () -> ContentItem
        """Gets the content of this Preset.  # noqa: E501


        :return: The content of this Preset.  # noqa: E501
        :rtype: ContentItem
        """
        return self._content

    @content.setter
    def content(self, content):
        # type: (ContentItem) -> None
        """Sets the content of this Preset.


        :param content: The content of this Preset.  # noqa: E501
        :type content: ContentItem
        :rtype: None
        """

        self._content = content

    @property
    def id(self):
        # type: () -> str
        """Gets the id of this Preset.  # noqa: E501


        :return: The id of this Preset.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        # type: (str) -> None
        """Sets the id of this Preset.


        :param id: The id of this Preset.  # noqa: E501
        :type id: str
        :rtype: None
        """

        self._id = id

    @property
    def name(self):
        # type: () -> str
        """Gets the name of this Preset.  # noqa: E501


        :return: The name of this Preset.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        # type: (str) -> None
        """Sets the name of this Preset.


        :param name: The name of this Preset.  # noqa: E501
        :type name: str
        :rtype: None
        """

        self._name = name

    @property
    def source(self):
        # type: () -> SourceTypeEnum
        """Gets the source of this Preset.  # noqa: E501


        :return: The source of this Preset.  # noqa: E501
        :rtype: SourceTypeEnum
        """
        return self._source

    @source.setter
    def source(self, source):
        # type: (SourceTypeEnum) -> None
        """Sets the source of this Preset.


        :param source: The source of this Preset.  # noqa: E501
        :type source: SourceTypeEnum
        :rtype: None
        """

        self._source = source

    @property
    def title(self):
        # type: () -> str
        """Gets the title of this Preset.  # noqa: E501


        :return: The title of this Preset.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        # type: (str) -> None
        """Sets the title of this Preset.


        :param title: The title of this Preset.  # noqa: E501
        :type title: str
        :rtype: None
        """

        self._title = title

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Preset):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Preset):
            return True

        return self.to_dict() != other.to_dict()
