# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional


from mozart_api.configuration import Configuration


class RoomCompensationMeasurementError(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"error": "str", "speaker_id": "str"}

    attribute_map = {"error": "error", "speaker_id": "speakerId"}

    def __init__(
        self,
        error: Optional["RoomCompensationMeasurementError.LTypeError"] = None,
        speaker_id: Optional[str] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """RoomCompensationMeasurementError - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._error = None
        self._speaker_id = None
        self.discriminator = None

        if error is not None:
            self.error = error
        if speaker_id is not None:
            self.speaker_id = speaker_id

    LTypeError = Literal[
        "noError",
        "lowSignal",
        "speakerSilent",
        "noisyLeftMicrophone",
        "noisyRightMicrophone",
        "noisyExternalMicrophone",
        "externalMicrophoneLocation",
        "externalMicrophoneMissing",
        "microphonesDisabled",
        "noisyMeasurement",
        "internalError",
    ]

    @property
    def error(self):
        # type: () -> 'RoomCompensationMeasurementError.LTypeError'
        """Gets the error of this RoomCompensationMeasurementError.  # noqa: E501

        noError:   The measurement went OK. lowSignal:   When there is too low signal in the recording, e.g. due to a loudspeaker being placed at   too great a distance from the microphone. speakerSilent:   No signal could be measured.   Could be because:     - The speaker is powered off or not connected.     - The left/right switch on a wired powerlink speaker is set in the wrong position.     - The speaker is placed in another room behind closed doors. noisy<Left/Right/External>Microphone:   When the recording of the given microphone is too noisy.   Could be because:     - Something is blocking the microphone externalMicrophoneLocation:   When the location of the external microphone is invalid. externalMicrophoneMissing:   If the external microphone was missing/disconnected during a measurement. microphonesDisabled:   If the microphones are either muted or disabled. noisyMeasurement:   When too much background noise has been detected during the measurement internalError:   Something went wrong internally - can not be fixed by the user. Try again.   # noqa: E501

        :return: The error of this RoomCompensationMeasurementError.  # noqa: E501
        :rtype: 'RoomCompensationMeasurementError.LTypeError'
        """
        return self._error

    @error.setter
    def error(self, error):
        # type: ('RoomCompensationMeasurementError.LTypeError') -> None
        """Sets the error of this RoomCompensationMeasurementError.

        noError:   The measurement went OK. lowSignal:   When there is too low signal in the recording, e.g. due to a loudspeaker being placed at   too great a distance from the microphone. speakerSilent:   No signal could be measured.   Could be because:     - The speaker is powered off or not connected.     - The left/right switch on a wired powerlink speaker is set in the wrong position.     - The speaker is placed in another room behind closed doors. noisy<Left/Right/External>Microphone:   When the recording of the given microphone is too noisy.   Could be because:     - Something is blocking the microphone externalMicrophoneLocation:   When the location of the external microphone is invalid. externalMicrophoneMissing:   If the external microphone was missing/disconnected during a measurement. microphonesDisabled:   If the microphones are either muted or disabled. noisyMeasurement:   When too much background noise has been detected during the measurement internalError:   Something went wrong internally - can not be fixed by the user. Try again.   # noqa: E501

        :param error: The error of this RoomCompensationMeasurementError.  # noqa: E501
        :type error: 'RoomCompensationMeasurementError.LTypeError'
        :rtype: None
        """
        allowed_values = [
            "noError",
            "lowSignal",
            "speakerSilent",
            "noisyLeftMicrophone",
            "noisyRightMicrophone",
            "noisyExternalMicrophone",
            "externalMicrophoneLocation",
            "externalMicrophoneMissing",
            "microphonesDisabled",
            "noisyMeasurement",
            "internalError",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and error not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `error` ({0}), must be one of {1}".format(  # noqa: E501
                    error, allowed_values
                )
            )

        self._error = error

    @property
    def speaker_id(self):
        # type: () -> str
        """Gets the speaker_id of this RoomCompensationMeasurementError.  # noqa: E501


        :return: The speaker_id of this RoomCompensationMeasurementError.  # noqa: E501
        :rtype: str
        """
        return self._speaker_id

    @speaker_id.setter
    def speaker_id(self, speaker_id):
        # type: (str) -> None
        """Sets the speaker_id of this RoomCompensationMeasurementError.


        :param speaker_id: The speaker_id of this RoomCompensationMeasurementError.  # noqa: E501
        :type speaker_id: str
        :rtype: None
        """

        self._speaker_id = speaker_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RoomCompensationMeasurementError):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RoomCompensationMeasurementError):
            return True

        return self.to_dict() != other.to_dict()
