# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional


from mozart_api.configuration import Configuration


class RoomCompensationPropertiesAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "action": "str",
        "continue_on_error": "bool",
        "skip_automatic_role_assignment": "bool",
        "speaker_list": "list[str]",
        "speaker_preset": "int",
    }

    attribute_map = {
        "action": "action",
        "continue_on_error": "continueOnError",
        "skip_automatic_role_assignment": "skipAutomaticRoleAssignment",
        "speaker_list": "speakerList",
        "speaker_preset": "speakerPreset",
    }

    def __init__(
        self,
        action: Optional[str] = None,
        continue_on_error: Optional[bool] = None,
        skip_automatic_role_assignment: Optional[bool] = None,
        speaker_list: Optional[List[str]] = None,
        speaker_preset: Optional[int] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """RoomCompensationPropertiesAllOf - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._action = None
        self._continue_on_error = None
        self._skip_automatic_role_assignment = None
        self._speaker_list = None
        self._speaker_preset = None
        self.discriminator = None

        self.action = action
        self.continue_on_error = continue_on_error
        self.skip_automatic_role_assignment = skip_automatic_role_assignment
        self.speaker_list = speaker_list
        self.speaker_preset = speaker_preset

    @property
    def action(self):
        # type: () -> str
        """Gets the action of this RoomCompensationPropertiesAllOf.  # noqa: E501

        Must be set if room compensation type is advanced. runAll:   Do measurements on all connected speakers. continue:   Continue from and including the speaker where last interrupted (stopped or failed). useSpeakerList:   Do measurements on the speakers in the list property.   # noqa: E501

        :return: The action of this RoomCompensationPropertiesAllOf.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        # type: (str) -> None
        """Sets the action of this RoomCompensationPropertiesAllOf.

        Must be set if room compensation type is advanced. runAll:   Do measurements on all connected speakers. continue:   Continue from and including the speaker where last interrupted (stopped or failed). useSpeakerList:   Do measurements on the speakers in the list property.   # noqa: E501

        :param action: The action of this RoomCompensationPropertiesAllOf.  # noqa: E501
        :type action: str
        :rtype: None
        """
        allowed_values = [None, "runAll", "continue", "useSpeakerList"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and action not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}".format(  # noqa: E501
                    action, allowed_values
                )
            )

        self._action = action

    @property
    def continue_on_error(self):
        # type: () -> bool
        """Gets the continue_on_error of this RoomCompensationPropertiesAllOf.  # noqa: E501

        On failing measurement on a speaker, default behavior is to stop measurement and skip the remaining speakers. Setting continueOnError to true will make the measuremnt process continue and finish measurement on all speakers, even though an error ocurred on one of the speakers.   # noqa: E501

        :return: The continue_on_error of this RoomCompensationPropertiesAllOf.  # noqa: E501
        :rtype: bool
        """
        return self._continue_on_error

    @continue_on_error.setter
    def continue_on_error(self, continue_on_error):
        # type: (bool) -> None
        """Sets the continue_on_error of this RoomCompensationPropertiesAllOf.

        On failing measurement on a speaker, default behavior is to stop measurement and skip the remaining speakers. Setting continueOnError to true will make the measuremnt process continue and finish measurement on all speakers, even though an error ocurred on one of the speakers.   # noqa: E501

        :param continue_on_error: The continue_on_error of this RoomCompensationPropertiesAllOf.  # noqa: E501
        :type continue_on_error: bool
        :rtype: None
        """

        self._continue_on_error = continue_on_error

    @property
    def skip_automatic_role_assignment(self):
        # type: () -> bool
        """Gets the skip_automatic_role_assignment of this RoomCompensationPropertiesAllOf.  # noqa: E501

        Skip calculation of automatic role assignment.  # noqa: E501

        :return: The skip_automatic_role_assignment of this RoomCompensationPropertiesAllOf.  # noqa: E501
        :rtype: bool
        """
        return self._skip_automatic_role_assignment

    @skip_automatic_role_assignment.setter
    def skip_automatic_role_assignment(self, skip_automatic_role_assignment):
        # type: (bool) -> None
        """Sets the skip_automatic_role_assignment of this RoomCompensationPropertiesAllOf.

        Skip calculation of automatic role assignment.  # noqa: E501

        :param skip_automatic_role_assignment: The skip_automatic_role_assignment of this RoomCompensationPropertiesAllOf.  # noqa: E501
        :type skip_automatic_role_assignment: bool
        :rtype: None
        """

        self._skip_automatic_role_assignment = skip_automatic_role_assignment

    @property
    def speaker_list(self):
        # type: () -> List[str]
        """Gets the speaker_list of this RoomCompensationPropertiesAllOf.  # noqa: E501

        List of speaker IDs to include in room compensation / automatic role assignment measurement. Relevant e.g. if you want to create a speaker group without the external speakers included. This can not be used for doing measurements on a partial speaker group, only on all speakers in an existing group or for all speakers in a new group.   # noqa: E501

        :return: The speaker_list of this RoomCompensationPropertiesAllOf.  # noqa: E501
        :rtype: List[str]
        """
        return self._speaker_list

    @speaker_list.setter
    def speaker_list(self, speaker_list):
        # type: (list[str]) -> None
        """Sets the speaker_list of this RoomCompensationPropertiesAllOf.

        List of speaker IDs to include in room compensation / automatic role assignment measurement. Relevant e.g. if you want to create a speaker group without the external speakers included. This can not be used for doing measurements on a partial speaker group, only on all speakers in an existing group or for all speakers in a new group.   # noqa: E501

        :param speaker_list: The speaker_list of this RoomCompensationPropertiesAllOf.  # noqa: E501
        :type speaker_list: list[str]
        :rtype: None
        """

        self._speaker_list = speaker_list

    @property
    def speaker_preset(self):
        # type: () -> int
        """Gets the speaker_preset of this RoomCompensationPropertiesAllOf.  # noqa: E501

        The Powerlink preset to use for the external PL/WPL speakers.  # noqa: E501

        :return: The speaker_preset of this RoomCompensationPropertiesAllOf.  # noqa: E501
        :rtype: int
        """
        return self._speaker_preset

    @speaker_preset.setter
    def speaker_preset(self, speaker_preset):
        # type: (int) -> None
        """Sets the speaker_preset of this RoomCompensationPropertiesAllOf.

        The Powerlink preset to use for the external PL/WPL speakers.  # noqa: E501

        :param speaker_preset: The speaker_preset of this RoomCompensationPropertiesAllOf.  # noqa: E501
        :type speaker_preset: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and speaker_preset is not None
            and speaker_preset > 255
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `speaker_preset`, must be a value less than or equal to `255`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and speaker_preset is not None
            and speaker_preset < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `speaker_preset`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._speaker_preset = speaker_preset

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RoomCompensationPropertiesAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RoomCompensationPropertiesAllOf):
            return True

        return self.to_dict() != other.to_dict()
