# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.speaker_group import SpeakerGroup
from mozart_api.models.room_compensation_response import RoomCompensationResponse

from mozart_api.configuration import Configuration


class RoomCompensationResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "compensation": "list[RoomCompensationResponse]",
        "measured_response": "list[RoomCompensationResponse]",
        "placement": "str",
        "reference_response": "list[RoomCompensationResponse]",
        "speaker_group_suggestion": "SpeakerGroup",
        "time_stamp": "datetime",
    }

    attribute_map = {
        "compensation": "compensation",
        "measured_response": "measuredResponse",
        "placement": "placement",
        "reference_response": "referenceResponse",
        "speaker_group_suggestion": "speakerGroupSuggestion",
        "time_stamp": "timeStamp",
    }

    def __init__(
        self,
        compensation: Optional[List[RoomCompensationResponse]] = None,
        measured_response: Optional[List[RoomCompensationResponse]] = None,
        placement: Optional["RoomCompensationResult.LTypePlacement"] = None,
        reference_response: Optional[List[RoomCompensationResponse]] = None,
        speaker_group_suggestion: Optional[SpeakerGroup] = None,
        time_stamp: Optional[datetime] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """RoomCompensationResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._compensation = None
        self._measured_response = None
        self._placement = None
        self._reference_response = None
        self._speaker_group_suggestion = None
        self._time_stamp = None
        self.discriminator = None

        if compensation is not None:
            self.compensation = compensation
        if measured_response is not None:
            self.measured_response = measured_response
        if placement is not None:
            self.placement = placement
        if reference_response is not None:
            self.reference_response = reference_response
        if speaker_group_suggestion is not None:
            self.speaker_group_suggestion = speaker_group_suggestion
        if time_stamp is not None:
            self.time_stamp = time_stamp

    @property
    def compensation(self):
        # type: () -> List[RoomCompensationResponse]
        """Gets the compensation of this RoomCompensationResult.  # noqa: E501


        :return: The compensation of this RoomCompensationResult.  # noqa: E501
        :rtype: List[RoomCompensationResponse]
        """
        return self._compensation

    @compensation.setter
    def compensation(self, compensation):
        # type: (list[RoomCompensationResponse]) -> None
        """Sets the compensation of this RoomCompensationResult.


        :param compensation: The compensation of this RoomCompensationResult.  # noqa: E501
        :type compensation: list[RoomCompensationResponse]
        :rtype: None
        """

        self._compensation = compensation

    @property
    def measured_response(self):
        # type: () -> List[RoomCompensationResponse]
        """Gets the measured_response of this RoomCompensationResult.  # noqa: E501


        :return: The measured_response of this RoomCompensationResult.  # noqa: E501
        :rtype: List[RoomCompensationResponse]
        """
        return self._measured_response

    @measured_response.setter
    def measured_response(self, measured_response):
        # type: (list[RoomCompensationResponse]) -> None
        """Sets the measured_response of this RoomCompensationResult.


        :param measured_response: The measured_response of this RoomCompensationResult.  # noqa: E501
        :type measured_response: list[RoomCompensationResponse]
        :rtype: None
        """

        self._measured_response = measured_response

    LTypePlacement = Literal["free", "nearWall", "unknown"]

    @property
    def placement(self):
        # type: () -> 'RoomCompensationResult.LTypePlacement'
        """Gets the placement of this RoomCompensationResult.  # noqa: E501


        :return: The placement of this RoomCompensationResult.  # noqa: E501
        :rtype: 'RoomCompensationResult.LTypePlacement'
        """
        return self._placement

    @placement.setter
    def placement(self, placement):
        # type: ('RoomCompensationResult.LTypePlacement') -> None
        """Sets the placement of this RoomCompensationResult.


        :param placement: The placement of this RoomCompensationResult.  # noqa: E501
        :type placement: 'RoomCompensationResult.LTypePlacement'
        :rtype: None
        """
        allowed_values = ["free", "nearWall", "unknown"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and placement not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `placement` ({0}), must be one of {1}".format(  # noqa: E501
                    placement, allowed_values
                )
            )

        self._placement = placement

    @property
    def reference_response(self):
        # type: () -> List[RoomCompensationResponse]
        """Gets the reference_response of this RoomCompensationResult.  # noqa: E501


        :return: The reference_response of this RoomCompensationResult.  # noqa: E501
        :rtype: List[RoomCompensationResponse]
        """
        return self._reference_response

    @reference_response.setter
    def reference_response(self, reference_response):
        # type: (list[RoomCompensationResponse]) -> None
        """Sets the reference_response of this RoomCompensationResult.


        :param reference_response: The reference_response of this RoomCompensationResult.  # noqa: E501
        :type reference_response: list[RoomCompensationResponse]
        :rtype: None
        """

        self._reference_response = reference_response

    @property
    def speaker_group_suggestion(self):
        # type: () -> SpeakerGroup
        """Gets the speaker_group_suggestion of this RoomCompensationResult.  # noqa: E501


        :return: The speaker_group_suggestion of this RoomCompensationResult.  # noqa: E501
        :rtype: SpeakerGroup
        """
        return self._speaker_group_suggestion

    @speaker_group_suggestion.setter
    def speaker_group_suggestion(self, speaker_group_suggestion):
        # type: (SpeakerGroup) -> None
        """Sets the speaker_group_suggestion of this RoomCompensationResult.


        :param speaker_group_suggestion: The speaker_group_suggestion of this RoomCompensationResult.  # noqa: E501
        :type speaker_group_suggestion: SpeakerGroup
        :rtype: None
        """

        self._speaker_group_suggestion = speaker_group_suggestion

    @property
    def time_stamp(self):
        # type: () -> datetime
        """Gets the time_stamp of this RoomCompensationResult.  # noqa: E501


        :return: The time_stamp of this RoomCompensationResult.  # noqa: E501
        :rtype: datetime
        """
        return self._time_stamp

    @time_stamp.setter
    def time_stamp(self, time_stamp):
        # type: (datetime) -> None
        """Sets the time_stamp of this RoomCompensationResult.


        :param time_stamp: The time_stamp of this RoomCompensationResult.  # noqa: E501
        :type time_stamp: datetime
        :rtype: None
        """

        self._time_stamp = time_stamp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RoomCompensationResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RoomCompensationResult):
            return True

        return self.to_dict() != other.to_dict()
