# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.room_compensation_error_details import (
    RoomCompensationErrorDetails,
)
from mozart_api.models.room_compensation_properties import RoomCompensationProperties

from mozart_api.configuration import Configuration


class RoomCompensationState(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "state": "str",
        "error": "str",
        "error_details": "RoomCompensationErrorDetails",
        "last_run_available": "bool",
        "properties": "RoomCompensationProperties",
        "time_stamp": "datetime",
    }

    attribute_map = {
        "state": "state",
        "error": "error",
        "error_details": "errorDetails",
        "last_run_available": "lastRunAvailable",
        "properties": "properties",
        "time_stamp": "timeStamp",
    }

    def __init__(
        self,
        state: Optional["RoomCompensationState.LTypeState"] = None,
        error: Optional["RoomCompensationState.LTypeError"] = None,
        error_details: Optional[RoomCompensationErrorDetails] = None,
        last_run_available: Optional[bool] = None,
        properties: Optional[RoomCompensationProperties] = None,
        time_stamp: Optional[datetime] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """RoomCompensationState - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._state = None
        self._error = None
        self._error_details = None
        self._last_run_available = None
        self._properties = None
        self._time_stamp = None
        self.discriminator = None

        if state is not None:
            self.state = state
        if error is not None:
            self.error = error
        if error_details is not None:
            self.error_details = error_details
        if last_run_available is not None:
            self.last_run_available = last_run_available
        if properties is not None:
            self.properties = properties
        if time_stamp is not None:
            self.time_stamp = time_stamp

    LTypeState = Literal["notStarted", "running", "done", "error", "stopped"]

    @property
    def state(self):
        # type: () -> 'RoomCompensationState.LTypeState'
        """Gets the state of this RoomCompensationState.  # noqa: E501


        :return: The state of this RoomCompensationState.  # noqa: E501
        :rtype: 'RoomCompensationState.LTypeState'
        """
        return self._state

    @state.setter
    def state(self, state):
        # type: ('RoomCompensationState.LTypeState') -> None
        """Sets the state of this RoomCompensationState.


        :param state: The state of this RoomCompensationState.  # noqa: E501
        :type state: 'RoomCompensationState.LTypeState'
        :rtype: None
        """
        allowed_values = [
            "notStarted",
            "running",
            "done",
            "error",
            "stopped",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and state not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}".format(  # noqa: E501
                    state, allowed_values
                )
            )

        self._state = state

    LTypeError = Literal[
        "noError",
        "microphoneMuted",
        "microphoneSwitchOff",
        "externalMicrophoneMissing",
        "externalMicrophoneInvalidPosition",
        "noisyEnvironment",
        "speakerMeasurementFailed",
        "invalidSpeakerList",
        "invalidAction",
        "internalError",
    ]

    @property
    def error(self):
        # type: () -> 'RoomCompensationState.LTypeError'
        """Gets the error of this RoomCompensationState.  # noqa: E501

        microphoneMuted:   The microphone is muted (soft-off, using touch button). microphoneSwitchOff:   The microphone switch is set in its off position. externalMicrophoneMissing:   The external microphone is not connected.   Is only relevant for advanced room compensation. externalMicrophoneInvalidPosition:   The external microphone is placed in an invalid position,   e.g. placed too close or in an extreme angle to the internal speakers.   Is only relevant for advanced room compensation. noisyEnvironment:   Too much environment noise to get a valid measurement. speakerMeasurementFailed:   A measurement failed, related to one of the individual speakers.   See the errorDetails property for details about the error and which speaker measurement failed.   Is only relevant for advanced room compensation. invalidSpeakerList:   The speaker list contains invalid speakers.   Valid speakers are: all external speakers and non-virtual internal speakers.   Is only relevant for advanced room compensation. invalidAction   Could not start with given action.   Eg. can't run from last failed speaker if there isn't any failed run.   Is only relevant for advanced room compensation. internalError:   Internal product error.   # noqa: E501

        :return: The error of this RoomCompensationState.  # noqa: E501
        :rtype: 'RoomCompensationState.LTypeError'
        """
        return self._error

    @error.setter
    def error(self, error):
        # type: ('RoomCompensationState.LTypeError') -> None
        """Sets the error of this RoomCompensationState.

        microphoneMuted:   The microphone is muted (soft-off, using touch button). microphoneSwitchOff:   The microphone switch is set in its off position. externalMicrophoneMissing:   The external microphone is not connected.   Is only relevant for advanced room compensation. externalMicrophoneInvalidPosition:   The external microphone is placed in an invalid position,   e.g. placed too close or in an extreme angle to the internal speakers.   Is only relevant for advanced room compensation. noisyEnvironment:   Too much environment noise to get a valid measurement. speakerMeasurementFailed:   A measurement failed, related to one of the individual speakers.   See the errorDetails property for details about the error and which speaker measurement failed.   Is only relevant for advanced room compensation. invalidSpeakerList:   The speaker list contains invalid speakers.   Valid speakers are: all external speakers and non-virtual internal speakers.   Is only relevant for advanced room compensation. invalidAction   Could not start with given action.   Eg. can't run from last failed speaker if there isn't any failed run.   Is only relevant for advanced room compensation. internalError:   Internal product error.   # noqa: E501

        :param error: The error of this RoomCompensationState.  # noqa: E501
        :type error: 'RoomCompensationState.LTypeError'
        :rtype: None
        """
        allowed_values = [
            "noError",
            "microphoneMuted",
            "microphoneSwitchOff",
            "externalMicrophoneMissing",
            "externalMicrophoneInvalidPosition",
            "noisyEnvironment",
            "speakerMeasurementFailed",
            "invalidSpeakerList",
            "invalidAction",
            "internalError",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and error not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `error` ({0}), must be one of {1}".format(  # noqa: E501
                    error, allowed_values
                )
            )

        self._error = error

    @property
    def error_details(self):
        # type: () -> RoomCompensationErrorDetails
        """Gets the error_details of this RoomCompensationState.  # noqa: E501


        :return: The error_details of this RoomCompensationState.  # noqa: E501
        :rtype: RoomCompensationErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        # type: (RoomCompensationErrorDetails) -> None
        """Sets the error_details of this RoomCompensationState.


        :param error_details: The error_details of this RoomCompensationState.  # noqa: E501
        :type error_details: RoomCompensationErrorDetails
        :rtype: None
        """

        self._error_details = error_details

    @property
    def last_run_available(self):
        # type: () -> bool
        """Gets the last_run_available of this RoomCompensationState.  # noqa: E501

        When true, measurements have been cached due to manual interrupt or failure, making it possible to use the action \"continue\" where the system will continue from the speaker where interrupted. The cached measurements are only temporary and will be cleared after some time (default 15min), in which case lastRunAvailable becomes false.   # noqa: E501

        :return: The last_run_available of this RoomCompensationState.  # noqa: E501
        :rtype: bool
        """
        return self._last_run_available

    @last_run_available.setter
    def last_run_available(self, last_run_available):
        # type: (bool) -> None
        """Sets the last_run_available of this RoomCompensationState.

        When true, measurements have been cached due to manual interrupt or failure, making it possible to use the action \"continue\" where the system will continue from the speaker where interrupted. The cached measurements are only temporary and will be cleared after some time (default 15min), in which case lastRunAvailable becomes false.   # noqa: E501

        :param last_run_available: The last_run_available of this RoomCompensationState.  # noqa: E501
        :type last_run_available: bool
        :rtype: None
        """

        self._last_run_available = last_run_available

    @property
    def properties(self):
        # type: () -> RoomCompensationProperties
        """Gets the properties of this RoomCompensationState.  # noqa: E501


        :return: The properties of this RoomCompensationState.  # noqa: E501
        :rtype: RoomCompensationProperties
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        # type: (RoomCompensationProperties) -> None
        """Sets the properties of this RoomCompensationState.


        :param properties: The properties of this RoomCompensationState.  # noqa: E501
        :type properties: RoomCompensationProperties
        :rtype: None
        """

        self._properties = properties

    @property
    def time_stamp(self):
        # type: () -> datetime
        """Gets the time_stamp of this RoomCompensationState.  # noqa: E501


        :return: The time_stamp of this RoomCompensationState.  # noqa: E501
        :rtype: datetime
        """
        return self._time_stamp

    @time_stamp.setter
    def time_stamp(self, time_stamp):
        # type: (datetime) -> None
        """Sets the time_stamp of this RoomCompensationState.


        :param time_stamp: The time_stamp of this RoomCompensationState.  # noqa: E501
        :type time_stamp: datetime
        :rtype: None
        """

        self._time_stamp = time_stamp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RoomCompensationState):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RoomCompensationState):
            return True

        return self.to_dict() != other.to_dict()
