# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional


from mozart_api.configuration import Configuration


class RoomCompensationVersion(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"algorithm": "int", "coefficients": "int"}

    attribute_map = {"algorithm": "algorithm", "coefficients": "coefficients"}

    def __init__(
        self,
        algorithm: Optional[int] = None,
        coefficients: Optional[int] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """RoomCompensationVersion - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._algorithm = None
        self._coefficients = None
        self.discriminator = None

        if algorithm is not None:
            self.algorithm = algorithm
        if coefficients is not None:
            self.coefficients = coefficients

    @property
    def algorithm(self):
        # type: () -> int
        """Gets the algorithm of this RoomCompensationVersion.  # noqa: E501


        :return: The algorithm of this RoomCompensationVersion.  # noqa: E501
        :rtype: int
        """
        return self._algorithm

    @algorithm.setter
    def algorithm(self, algorithm):
        # type: (int) -> None
        """Sets the algorithm of this RoomCompensationVersion.


        :param algorithm: The algorithm of this RoomCompensationVersion.  # noqa: E501
        :type algorithm: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and algorithm is not None
            and algorithm < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `algorithm`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._algorithm = algorithm

    @property
    def coefficients(self):
        # type: () -> int
        """Gets the coefficients of this RoomCompensationVersion.  # noqa: E501


        :return: The coefficients of this RoomCompensationVersion.  # noqa: E501
        :rtype: int
        """
        return self._coefficients

    @coefficients.setter
    def coefficients(self, coefficients):
        # type: (int) -> None
        """Sets the coefficients of this RoomCompensationVersion.


        :param coefficients: The coefficients of this RoomCompensationVersion.  # noqa: E501
        :type coefficients: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and coefficients is not None
            and coefficients < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `coefficients`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._coefficients = coefficients

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RoomCompensationVersion):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RoomCompensationVersion):
            return True

        return self.to_dict() != other.to_dict()
