# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.software_update_state import SoftwareUpdateState

from mozart_api.configuration import Configuration


class SoftwareUpdateStatus(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "available_update": "str",
        "last_check": "datetime",
        "last_update": "datetime",
        "software_version": "str",
        "state": "SoftwareUpdateState",
        "update_progress": "int",
    }

    attribute_map = {
        "available_update": "availableUpdate",
        "last_check": "lastCheck",
        "last_update": "lastUpdate",
        "software_version": "softwareVersion",
        "state": "state",
        "update_progress": "updateProgress",
    }

    def __init__(
        self,
        available_update: Optional[str] = None,
        last_check: Optional[datetime] = None,
        last_update: Optional[datetime] = None,
        software_version: Optional[str] = None,
        state: Optional[SoftwareUpdateState] = None,
        update_progress: Optional[int] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """SoftwareUpdateStatus - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._available_update = None
        self._last_check = None
        self._last_update = None
        self._software_version = None
        self._state = None
        self._update_progress = None
        self.discriminator = None

        if available_update is not None:
            self.available_update = available_update
        if last_check is not None:
            self.last_check = last_check
        if last_update is not None:
            self.last_update = last_update
        self.software_version = software_version
        self.state = state
        if update_progress is not None:
            self.update_progress = update_progress

    @property
    def available_update(self):
        # type: () -> str
        """Gets the available_update of this SoftwareUpdateStatus.  # noqa: E501


        :return: The available_update of this SoftwareUpdateStatus.  # noqa: E501
        :rtype: str
        """
        return self._available_update

    @available_update.setter
    def available_update(self, available_update):
        # type: (str) -> None
        """Sets the available_update of this SoftwareUpdateStatus.


        :param available_update: The available_update of this SoftwareUpdateStatus.  # noqa: E501
        :type available_update: str
        :rtype: None
        """

        self._available_update = available_update

    @property
    def last_check(self):
        # type: () -> datetime
        """Gets the last_check of this SoftwareUpdateStatus.  # noqa: E501


        :return: The last_check of this SoftwareUpdateStatus.  # noqa: E501
        :rtype: datetime
        """
        return self._last_check

    @last_check.setter
    def last_check(self, last_check):
        # type: (datetime) -> None
        """Sets the last_check of this SoftwareUpdateStatus.


        :param last_check: The last_check of this SoftwareUpdateStatus.  # noqa: E501
        :type last_check: datetime
        :rtype: None
        """

        self._last_check = last_check

    @property
    def last_update(self):
        # type: () -> datetime
        """Gets the last_update of this SoftwareUpdateStatus.  # noqa: E501


        :return: The last_update of this SoftwareUpdateStatus.  # noqa: E501
        :rtype: datetime
        """
        return self._last_update

    @last_update.setter
    def last_update(self, last_update):
        # type: (datetime) -> None
        """Sets the last_update of this SoftwareUpdateStatus.


        :param last_update: The last_update of this SoftwareUpdateStatus.  # noqa: E501
        :type last_update: datetime
        :rtype: None
        """

        self._last_update = last_update

    @property
    def software_version(self):
        # type: () -> str
        """Gets the software_version of this SoftwareUpdateStatus.  # noqa: E501


        :return: The software_version of this SoftwareUpdateStatus.  # noqa: E501
        :rtype: str
        """
        return self._software_version

    @software_version.setter
    def software_version(self, software_version):
        # type: (str) -> None
        """Sets the software_version of this SoftwareUpdateStatus.


        :param software_version: The software_version of this SoftwareUpdateStatus.  # noqa: E501
        :type software_version: str
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and software_version is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `software_version`, must not be `None`"
            )  # noqa: E501

        self._software_version = software_version

    @property
    def state(self):
        # type: () -> SoftwareUpdateState
        """Gets the state of this SoftwareUpdateStatus.  # noqa: E501


        :return: The state of this SoftwareUpdateStatus.  # noqa: E501
        :rtype: SoftwareUpdateState
        """
        return self._state

    @state.setter
    def state(self, state):
        # type: (SoftwareUpdateState) -> None
        """Sets the state of this SoftwareUpdateStatus.


        :param state: The state of this SoftwareUpdateStatus.  # noqa: E501
        :type state: SoftwareUpdateState
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and state is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `state`, must not be `None`"
            )  # noqa: E501

        self._state = state

    @property
    def update_progress(self):
        # type: () -> int
        """Gets the update_progress of this SoftwareUpdateStatus.  # noqa: E501


        :return: The update_progress of this SoftwareUpdateStatus.  # noqa: E501
        :rtype: int
        """
        return self._update_progress

    @update_progress.setter
    def update_progress(self, update_progress):
        # type: (int) -> None
        """Sets the update_progress of this SoftwareUpdateStatus.


        :param update_progress: The update_progress of this SoftwareUpdateStatus.  # noqa: E501
        :type update_progress: int
        :rtype: None
        """

        self._update_progress = update_progress

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SoftwareUpdateStatus):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SoftwareUpdateStatus):
            return True

        return self.to_dict() != other.to_dict()
