# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.sound_tone_touch import SoundToneTouch
from mozart_api.models.room_compensation_info import RoomCompensationInfo
from mozart_api.models.sound_adjustments import SoundAdjustments

from mozart_api.configuration import Configuration


class SoundSettings(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "adjustments": "SoundAdjustments",
        "room_compensation": "RoomCompensationInfo",
        "tone_touch": "SoundToneTouch",
    }

    attribute_map = {
        "adjustments": "adjustments",
        "room_compensation": "roomCompensation",
        "tone_touch": "toneTouch",
    }

    def __init__(
        self,
        adjustments: Optional[SoundAdjustments] = None,
        room_compensation: Optional[RoomCompensationInfo] = None,
        tone_touch: Optional[SoundToneTouch] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """SoundSettings - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._adjustments = None
        self._room_compensation = None
        self._tone_touch = None
        self.discriminator = None

        if adjustments is not None:
            self.adjustments = adjustments
        if room_compensation is not None:
            self.room_compensation = room_compensation
        if tone_touch is not None:
            self.tone_touch = tone_touch

    @property
    def adjustments(self):
        # type: () -> SoundAdjustments
        """Gets the adjustments of this SoundSettings.  # noqa: E501


        :return: The adjustments of this SoundSettings.  # noqa: E501
        :rtype: SoundAdjustments
        """
        return self._adjustments

    @adjustments.setter
    def adjustments(self, adjustments):
        # type: (SoundAdjustments) -> None
        """Sets the adjustments of this SoundSettings.


        :param adjustments: The adjustments of this SoundSettings.  # noqa: E501
        :type adjustments: SoundAdjustments
        :rtype: None
        """

        self._adjustments = adjustments

    @property
    def room_compensation(self):
        # type: () -> RoomCompensationInfo
        """Gets the room_compensation of this SoundSettings.  # noqa: E501


        :return: The room_compensation of this SoundSettings.  # noqa: E501
        :rtype: RoomCompensationInfo
        """
        return self._room_compensation

    @room_compensation.setter
    def room_compensation(self, room_compensation):
        # type: (RoomCompensationInfo) -> None
        """Sets the room_compensation of this SoundSettings.


        :param room_compensation: The room_compensation of this SoundSettings.  # noqa: E501
        :type room_compensation: RoomCompensationInfo
        :rtype: None
        """

        self._room_compensation = room_compensation

    @property
    def tone_touch(self):
        # type: () -> SoundToneTouch
        """Gets the tone_touch of this SoundSettings.  # noqa: E501


        :return: The tone_touch of this SoundSettings.  # noqa: E501
        :rtype: SoundToneTouch
        """
        return self._tone_touch

    @tone_touch.setter
    def tone_touch(self, tone_touch):
        # type: (SoundToneTouch) -> None
        """Sets the tone_touch of this SoundSettings.


        :param tone_touch: The tone_touch of this SoundSettings.  # noqa: E501
        :type tone_touch: SoundToneTouch
        :rtype: None
        """

        self._tone_touch = tone_touch

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SoundSettings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SoundSettings):
            return True

        return self.to_dict() != other.to_dict()
