# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.source_type_enum import SourceTypeEnum

from mozart_api.configuration import Configuration


class Source(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "id": "str",
        "is_enabled": "bool",
        "is_playable": "bool",
        "name": "str",
        "type": "SourceTypeEnum",
    }

    attribute_map = {
        "id": "id",
        "is_enabled": "isEnabled",
        "is_playable": "isPlayable",
        "name": "name",
        "type": "type",
    }

    def __init__(
        self,
        id: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        is_playable: Optional[bool] = None,
        name: Optional[str] = None,
        type: Optional[SourceTypeEnum] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """Source - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._is_enabled = None
        self._is_playable = None
        self._name = None
        self._type = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if is_playable is not None:
            self.is_playable = is_playable
        if name is not None:
            self.name = name
        if type is not None:
            self.type = type

    @property
    def id(self):
        # type: () -> str
        """Gets the id of this Source.  # noqa: E501


        :return: The id of this Source.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        # type: (str) -> None
        """Sets the id of this Source.


        :param id: The id of this Source.  # noqa: E501
        :type id: str
        :rtype: None
        """

        self._id = id

    @property
    def is_enabled(self):
        # type: () -> bool
        """Gets the is_enabled of this Source.  # noqa: E501

        some sources require an explicit activation or accept of terms before being enabled  # noqa: E501

        :return: The is_enabled of this Source.  # noqa: E501
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        # type: (bool) -> None
        """Sets the is_enabled of this Source.

        some sources require an explicit activation or accept of terms before being enabled  # noqa: E501

        :param is_enabled: The is_enabled of this Source.  # noqa: E501
        :type is_enabled: bool
        :rtype: None
        """

        self._is_enabled = is_enabled

    @property
    def is_playable(self):
        # type: () -> bool
        """Gets the is_playable of this Source.  # noqa: E501


        :return: The is_playable of this Source.  # noqa: E501
        :rtype: bool
        """
        return self._is_playable

    @is_playable.setter
    def is_playable(self, is_playable):
        # type: (bool) -> None
        """Sets the is_playable of this Source.


        :param is_playable: The is_playable of this Source.  # noqa: E501
        :type is_playable: bool
        :rtype: None
        """

        self._is_playable = is_playable

    @property
    def name(self):
        # type: () -> str
        """Gets the name of this Source.  # noqa: E501


        :return: The name of this Source.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        # type: (str) -> None
        """Sets the name of this Source.


        :param name: The name of this Source.  # noqa: E501
        :type name: str
        :rtype: None
        """

        self._name = name

    @property
    def type(self):
        # type: () -> SourceTypeEnum
        """Gets the type of this Source.  # noqa: E501


        :return: The type of this Source.  # noqa: E501
        :rtype: SourceTypeEnum
        """
        return self._type

    @type.setter
    def type(self, type):
        # type: (SourceTypeEnum) -> None
        """Sets the type of this Source.


        :param type: The type of this Source.  # noqa: E501
        :type type: SourceTypeEnum
        :rtype: None
        """

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Source):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Source):
            return True

        return self.to_dict() != other.to_dict()
