# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.speaker_group_member import SpeakerGroupMember

from mozart_api.configuration import Configuration


class SpeakerGroup(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "crossover_frequency": "int",
        "enable_phase_compensation": "bool",
        "friendly_name": "str",
        "id": "str",
        "is_deleteable": "bool",
        "items": "list[SpeakerGroupMember]",
        "room_compensation_id": "str",
        "speaker_preset": "int",
    }

    attribute_map = {
        "crossover_frequency": "crossoverFrequency",
        "enable_phase_compensation": "enablePhaseCompensation",
        "friendly_name": "friendlyName",
        "id": "id",
        "is_deleteable": "isDeleteable",
        "items": "items",
        "room_compensation_id": "roomCompensationId",
        "speaker_preset": "speakerPreset",
    }

    def __init__(
        self,
        crossover_frequency: Optional[int] = None,
        enable_phase_compensation: Optional[bool] = None,
        friendly_name: Optional[str] = None,
        id: Optional[str] = None,
        is_deleteable: Optional[bool] = None,
        items: Optional[List[SpeakerGroupMember]] = None,
        room_compensation_id: Optional[str] = None,
        speaker_preset: Optional[int] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """SpeakerGroup - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._crossover_frequency = None
        self._enable_phase_compensation = None
        self._friendly_name = None
        self._id = None
        self._is_deleteable = None
        self._items = None
        self._room_compensation_id = None
        self._speaker_preset = None
        self.discriminator = None

        self.crossover_frequency = crossover_frequency
        self.enable_phase_compensation = enable_phase_compensation
        self.friendly_name = friendly_name
        if id is not None:
            self.id = id
        self.is_deleteable = is_deleteable
        self.items = items
        self.room_compensation_id = room_compensation_id
        self.speaker_preset = speaker_preset

    @property
    def crossover_frequency(self):
        # type: () -> int
        """Gets the crossover_frequency of this SpeakerGroup.  # noqa: E501

        Crossover frequency for bass management in Hz  # noqa: E501

        :return: The crossover_frequency of this SpeakerGroup.  # noqa: E501
        :rtype: int
        """
        return self._crossover_frequency

    @crossover_frequency.setter
    def crossover_frequency(self, crossover_frequency):
        # type: (int) -> None
        """Sets the crossover_frequency of this SpeakerGroup.

        Crossover frequency for bass management in Hz  # noqa: E501

        :param crossover_frequency: The crossover_frequency of this SpeakerGroup.  # noqa: E501
        :type crossover_frequency: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and crossover_frequency is not None
            and crossover_frequency > 300
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `crossover_frequency`, must be a value less than or equal to `300`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and crossover_frequency is not None
            and crossover_frequency < 20
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `crossover_frequency`, must be a value greater than or equal to `20`"
            )  # noqa: E501

        self._crossover_frequency = crossover_frequency

    @property
    def enable_phase_compensation(self):
        # type: () -> bool
        """Gets the enable_phase_compensation of this SpeakerGroup.  # noqa: E501

        Enable phase compensation in bass management.  # noqa: E501

        :return: The enable_phase_compensation of this SpeakerGroup.  # noqa: E501
        :rtype: bool
        """
        return self._enable_phase_compensation

    @enable_phase_compensation.setter
    def enable_phase_compensation(self, enable_phase_compensation):
        # type: (bool) -> None
        """Sets the enable_phase_compensation of this SpeakerGroup.

        Enable phase compensation in bass management.  # noqa: E501

        :param enable_phase_compensation: The enable_phase_compensation of this SpeakerGroup.  # noqa: E501
        :type enable_phase_compensation: bool
        :rtype: None
        """

        self._enable_phase_compensation = enable_phase_compensation

    @property
    def friendly_name(self):
        # type: () -> str
        """Gets the friendly_name of this SpeakerGroup.  # noqa: E501

        Friendly name of the SpeakerGroup. Required when creating a new group   # noqa: E501

        :return: The friendly_name of this SpeakerGroup.  # noqa: E501
        :rtype: str
        """
        return self._friendly_name

    @friendly_name.setter
    def friendly_name(self, friendly_name):
        # type: (str) -> None
        """Sets the friendly_name of this SpeakerGroup.

        Friendly name of the SpeakerGroup. Required when creating a new group   # noqa: E501

        :param friendly_name: The friendly_name of this SpeakerGroup.  # noqa: E501
        :type friendly_name: str
        :rtype: None
        """

        self._friendly_name = friendly_name

    @property
    def id(self):
        # type: () -> str
        """Gets the id of this SpeakerGroup.  # noqa: E501


        :return: The id of this SpeakerGroup.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        # type: (str) -> None
        """Sets the id of this SpeakerGroup.


        :param id: The id of this SpeakerGroup.  # noqa: E501
        :type id: str
        :rtype: None
        """

        self._id = id

    @property
    def is_deleteable(self):
        # type: () -> bool
        """Gets the is_deleteable of this SpeakerGroup.  # noqa: E501


        :return: The is_deleteable of this SpeakerGroup.  # noqa: E501
        :rtype: bool
        """
        return self._is_deleteable

    @is_deleteable.setter
    def is_deleteable(self, is_deleteable):
        # type: (bool) -> None
        """Sets the is_deleteable of this SpeakerGroup.


        :param is_deleteable: The is_deleteable of this SpeakerGroup.  # noqa: E501
        :type is_deleteable: bool
        :rtype: None
        """

        self._is_deleteable = is_deleteable

    @property
    def items(self):
        # type: () -> List[SpeakerGroupMember]
        """Gets the items of this SpeakerGroup.  # noqa: E501


        :return: The items of this SpeakerGroup.  # noqa: E501
        :rtype: List[SpeakerGroupMember]
        """
        return self._items

    @items.setter
    def items(self, items):
        # type: (list[SpeakerGroupMember]) -> None
        """Sets the items of this SpeakerGroup.


        :param items: The items of this SpeakerGroup.  # noqa: E501
        :type items: list[SpeakerGroupMember]
        :rtype: None
        """

        self._items = items

    @property
    def room_compensation_id(self):
        # type: () -> str
        """Gets the room_compensation_id of this SpeakerGroup.  # noqa: E501

        ID of the calculated coefficents for this group, made during advanced room compensation. When updating an existing group, an empty string will clear roomCompensationId.   # noqa: E501

        :return: The room_compensation_id of this SpeakerGroup.  # noqa: E501
        :rtype: str
        """
        return self._room_compensation_id

    @room_compensation_id.setter
    def room_compensation_id(self, room_compensation_id):
        # type: (str) -> None
        """Sets the room_compensation_id of this SpeakerGroup.

        ID of the calculated coefficents for this group, made during advanced room compensation. When updating an existing group, an empty string will clear roomCompensationId.   # noqa: E501

        :param room_compensation_id: The room_compensation_id of this SpeakerGroup.  # noqa: E501
        :type room_compensation_id: str
        :rtype: None
        """

        self._room_compensation_id = room_compensation_id

    @property
    def speaker_preset(self):
        # type: () -> int
        """Gets the speaker_preset of this SpeakerGroup.  # noqa: E501

        Speaker preset / listening mode eg. BL28 curtain position etc.  # noqa: E501

        :return: The speaker_preset of this SpeakerGroup.  # noqa: E501
        :rtype: int
        """
        return self._speaker_preset

    @speaker_preset.setter
    def speaker_preset(self, speaker_preset):
        # type: (int) -> None
        """Sets the speaker_preset of this SpeakerGroup.

        Speaker preset / listening mode eg. BL28 curtain position etc.  # noqa: E501

        :param speaker_preset: The speaker_preset of this SpeakerGroup.  # noqa: E501
        :type speaker_preset: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and speaker_preset is not None
            and speaker_preset > 99
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `speaker_preset`, must be a value less than or equal to `99`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and speaker_preset is not None
            and speaker_preset < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `speaker_preset`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._speaker_preset = speaker_preset

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SpeakerGroup):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SpeakerGroup):
            return True

        return self.to_dict() != other.to_dict()
