# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.speaker_group_member_location import SpeakerGroupMemberLocation

from mozart_api.configuration import Configuration


class SpeakerGroupMember(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "distance": "int",
        "friendly_name": "str",
        "gain": "float",
        "id": "str",
        "location": "SpeakerGroupMemberLocation",
        "redirection_level": "int",
        "role": "str",
        "type": "str",
    }

    attribute_map = {
        "distance": "distance",
        "friendly_name": "friendlyName",
        "gain": "gain",
        "id": "id",
        "location": "location",
        "redirection_level": "redirectionLevel",
        "role": "role",
        "type": "type",
    }

    def __init__(
        self,
        distance: Optional[int] = None,
        friendly_name: Optional[str] = None,
        gain: Optional[float] = None,
        id: Optional[str] = None,
        location: Optional[SpeakerGroupMemberLocation] = None,
        redirection_level: Optional[int] = None,
        role: Optional[str] = None,
        type: Optional[str] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """SpeakerGroupMember - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._distance = None
        self._friendly_name = None
        self._gain = None
        self._id = None
        self._location = None
        self._redirection_level = None
        self._role = None
        self._type = None
        self.discriminator = None

        self.distance = distance
        self.friendly_name = friendly_name
        self.gain = gain
        self.id = id
        self.location = location
        self.redirection_level = redirection_level
        self.role = role
        self.type = type

    @property
    def distance(self):
        # type: () -> int
        """Gets the distance of this SpeakerGroupMember.  # noqa: E501

        Distance from listening position in cm  # noqa: E501

        :return: The distance of this SpeakerGroupMember.  # noqa: E501
        :rtype: int
        """
        return self._distance

    @distance.setter
    def distance(self, distance):
        # type: (int) -> None
        """Sets the distance of this SpeakerGroupMember.

        Distance from listening position in cm  # noqa: E501

        :param distance: The distance of this SpeakerGroupMember.  # noqa: E501
        :type distance: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and distance is not None
            and distance > 1000
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `distance`, must be a value less than or equal to `1000`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and distance is not None
            and distance < 0
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `distance`, must be a value greater than or equal to `0`"
            )  # noqa: E501

        self._distance = distance

    @property
    def friendly_name(self):
        # type: () -> str
        """Gets the friendly_name of this SpeakerGroupMember.  # noqa: E501


        :return: The friendly_name of this SpeakerGroupMember.  # noqa: E501
        :rtype: str
        """
        return self._friendly_name

    @friendly_name.setter
    def friendly_name(self, friendly_name):
        # type: (str) -> None
        """Sets the friendly_name of this SpeakerGroupMember.


        :param friendly_name: The friendly_name of this SpeakerGroupMember.  # noqa: E501
        :type friendly_name: str
        :rtype: None
        """

        self._friendly_name = friendly_name

    @property
    def gain(self):
        # type: () -> float
        """Gets the gain of this SpeakerGroupMember.  # noqa: E501

        Level in dB  # noqa: E501

        :return: The gain of this SpeakerGroupMember.  # noqa: E501
        :rtype: float
        """
        return self._gain

    @gain.setter
    def gain(self, gain):
        # type: (float) -> None
        """Sets the gain of this SpeakerGroupMember.

        Level in dB  # noqa: E501

        :param gain: The gain of this SpeakerGroupMember.  # noqa: E501
        :type gain: float
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and gain is not None
            and gain > 6
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `gain`, must be a value less than or equal to `6`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and gain is not None
            and gain < -24
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `gain`, must be a value greater than or equal to `-24`"
            )  # noqa: E501

        self._gain = gain

    @property
    def id(self):
        # type: () -> str
        """Gets the id of this SpeakerGroupMember.  # noqa: E501


        :return: The id of this SpeakerGroupMember.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        # type: (str) -> None
        """Sets the id of this SpeakerGroupMember.


        :param id: The id of this SpeakerGroupMember.  # noqa: E501
        :type id: str
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation and id is None
        ):  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def location(self):
        # type: () -> SpeakerGroupMemberLocation
        """Gets the location of this SpeakerGroupMember.  # noqa: E501


        :return: The location of this SpeakerGroupMember.  # noqa: E501
        :rtype: SpeakerGroupMemberLocation
        """
        return self._location

    @location.setter
    def location(self, location):
        # type: (SpeakerGroupMemberLocation) -> None
        """Sets the location of this SpeakerGroupMember.


        :param location: The location of this SpeakerGroupMember.  # noqa: E501
        :type location: SpeakerGroupMemberLocation
        :rtype: None
        """

        self._location = location

    @property
    def redirection_level(self):
        # type: () -> int
        """Gets the redirection_level of this SpeakerGroupMember.  # noqa: E501

        Redirection level for bass management in dB  # noqa: E501

        :return: The redirection_level of this SpeakerGroupMember.  # noqa: E501
        :rtype: int
        """
        return self._redirection_level

    @redirection_level.setter
    def redirection_level(self, redirection_level):
        # type: (int) -> None
        """Sets the redirection_level of this SpeakerGroupMember.

        Redirection level for bass management in dB  # noqa: E501

        :param redirection_level: The redirection_level of this SpeakerGroupMember.  # noqa: E501
        :type redirection_level: int
        :rtype: None
        """
        if (
            self.local_vars_configuration.client_side_validation
            and redirection_level is not None
            and redirection_level > 6
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `redirection_level`, must be a value less than or equal to `6`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and redirection_level is not None
            and redirection_level < -100
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `redirection_level`, must be a value greater than or equal to `-100`"
            )  # noqa: E501

        self._redirection_level = redirection_level

    @property
    def role(self):
        # type: () -> str
        """Gets the role of this SpeakerGroupMember.  # noqa: E501


        :return: The role of this SpeakerGroupMember.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        # type: (str) -> None
        """Sets the role of this SpeakerGroupMember.


        :param role: The role of this SpeakerGroupMember.  # noqa: E501
        :type role: str
        :rtype: None
        """

        self._role = role

    @property
    def type(self):
        # type: () -> str
        """Gets the type of this SpeakerGroupMember.  # noqa: E501


        :return: The type of this SpeakerGroupMember.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        # type: (str) -> None
        """Sets the type of this SpeakerGroupMember.


        :param type: The type of this SpeakerGroupMember.  # noqa: E501
        :type type: str
        :rtype: None
        """

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SpeakerGroupMember):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SpeakerGroupMember):
            return True

        return self.to_dict() != other.to_dict()
