# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.tv_integration_types import TvIntegrationTypes

from mozart_api.configuration import Configuration


class TvProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "integration_supported": "TvIntegrationTypes",
        "name": "str",
        "year": "int",
    }

    attribute_map = {
        "integration_supported": "integrationSupported",
        "name": "name",
        "year": "year",
    }

    def __init__(
        self,
        integration_supported: Optional[TvIntegrationTypes] = None,
        name: Optional[str] = None,
        year: Optional[int] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """TvProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._integration_supported = None
        self._name = None
        self._year = None
        self.discriminator = None

        if integration_supported is not None:
            self.integration_supported = integration_supported
        self.name = name
        self.year = year

    @property
    def integration_supported(self):
        # type: () -> TvIntegrationTypes
        """Gets the integration_supported of this TvProperties.  # noqa: E501


        :return: The integration_supported of this TvProperties.  # noqa: E501
        :rtype: TvIntegrationTypes
        """
        return self._integration_supported

    @integration_supported.setter
    def integration_supported(self, integration_supported):
        # type: (TvIntegrationTypes) -> None
        """Sets the integration_supported of this TvProperties.


        :param integration_supported: The integration_supported of this TvProperties.  # noqa: E501
        :type integration_supported: TvIntegrationTypes
        :rtype: None
        """

        self._integration_supported = integration_supported

    @property
    def name(self):
        # type: () -> str
        """Gets the name of this TvProperties.  # noqa: E501


        :return: The name of this TvProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        # type: (str) -> None
        """Sets the name of this TvProperties.


        :param name: The name of this TvProperties.  # noqa: E501
        :type name: str
        :rtype: None
        """

        self._name = name

    @property
    def year(self):
        # type: () -> int
        """Gets the year of this TvProperties.  # noqa: E501


        :return: The year of this TvProperties.  # noqa: E501
        :rtype: int
        """
        return self._year

    @year.setter
    def year(self, year):
        # type: (int) -> None
        """Sets the year of this TvProperties.


        :param year: The year of this TvProperties.  # noqa: E501
        :type year: int
        :rtype: None
        """

        self._year = year

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TvProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TvProperties):
            return True

        return self.to_dict() != other.to_dict()
