# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional

from mozart_api.models.tv_properties import TvProperties
from mozart_api.models.tv_integration_types import TvIntegrationTypes

from mozart_api.configuration import Configuration


class TvState(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"integration": "TvIntegrationTypes", "tv_info": "TvProperties"}

    attribute_map = {"integration": "integration", "tv_info": "tvInfo"}

    def __init__(
        self,
        integration: Optional[TvIntegrationTypes] = None,
        tv_info: Optional[TvProperties] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """TvState - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._integration = None
        self._tv_info = None
        self.discriminator = None

        if integration is not None:
            self.integration = integration
        if tv_info is not None:
            self.tv_info = tv_info

    @property
    def integration(self):
        # type: () -> TvIntegrationTypes
        """Gets the integration of this TvState.  # noqa: E501


        :return: The integration of this TvState.  # noqa: E501
        :rtype: TvIntegrationTypes
        """
        return self._integration

    @integration.setter
    def integration(self, integration):
        # type: (TvIntegrationTypes) -> None
        """Sets the integration of this TvState.


        :param integration: The integration of this TvState.  # noqa: E501
        :type integration: TvIntegrationTypes
        :rtype: None
        """

        self._integration = integration

    @property
    def tv_info(self):
        # type: () -> TvProperties
        """Gets the tv_info of this TvState.  # noqa: E501


        :return: The tv_info of this TvState.  # noqa: E501
        :rtype: TvProperties
        """
        return self._tv_info

    @tv_info.setter
    def tv_info(self, tv_info):
        # type: (TvProperties) -> None
        """Sets the tv_info of this TvState.


        :param tv_info: The tv_info of this TvState.  # noqa: E501
        :type tv_info: TvProperties
        :rtype: None
        """

        self._tv_info = tv_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TvState):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TvState):
            return True

        return self.to_dict() != other.to_dict()
