# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from datetime import datetime
from typing import List, Literal, Optional


from mozart_api.configuration import Configuration


class VideoPixelFormat(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "bitdepth": "str",
        "chroma_subsample": "str",
        "colorimetry": "str",
        "full_range": "bool",
    }

    attribute_map = {
        "bitdepth": "bitdepth",
        "chroma_subsample": "chromaSubsample",
        "colorimetry": "colorimetry",
        "full_range": "fullRange",
    }

    def __init__(
        self,
        bitdepth: Optional["VideoPixelFormat.LTypeBitdepth"] = None,
        chroma_subsample: Optional["VideoPixelFormat.LTypeChromaSubsample"] = None,
        colorimetry: Optional["VideoPixelFormat.LTypeColorimetry"] = None,
        full_range: Optional[bool] = None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """VideoPixelFormat - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._bitdepth = None
        self._chroma_subsample = None
        self._colorimetry = None
        self._full_range = None
        self.discriminator = None

        if bitdepth is not None:
            self.bitdepth = bitdepth
        if chroma_subsample is not None:
            self.chroma_subsample = chroma_subsample
        if colorimetry is not None:
            self.colorimetry = colorimetry
        if full_range is not None:
            self.full_range = full_range

    LTypeBitdepth = Literal["bit8", "bit10", "bit12"]

    @property
    def bitdepth(self):
        # type: () -> 'VideoPixelFormat.LTypeBitdepth'
        """Gets the bitdepth of this VideoPixelFormat.  # noqa: E501


        :return: The bitdepth of this VideoPixelFormat.  # noqa: E501
        :rtype: 'VideoPixelFormat.LTypeBitdepth'
        """
        return self._bitdepth

    @bitdepth.setter
    def bitdepth(self, bitdepth):
        # type: ('VideoPixelFormat.LTypeBitdepth') -> None
        """Sets the bitdepth of this VideoPixelFormat.


        :param bitdepth: The bitdepth of this VideoPixelFormat.  # noqa: E501
        :type bitdepth: 'VideoPixelFormat.LTypeBitdepth'
        :rtype: None
        """
        allowed_values = ["bit8", "bit10", "bit12"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and bitdepth not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `bitdepth` ({0}), must be one of {1}".format(  # noqa: E501
                    bitdepth, allowed_values
                )
            )

        self._bitdepth = bitdepth

    LTypeChromaSubsample = Literal["yCbCr444RGB", "yCbCr422", "yCbCr420"]

    @property
    def chroma_subsample(self):
        # type: () -> 'VideoPixelFormat.LTypeChromaSubsample'
        """Gets the chroma_subsample of this VideoPixelFormat.  # noqa: E501


        :return: The chroma_subsample of this VideoPixelFormat.  # noqa: E501
        :rtype: 'VideoPixelFormat.LTypeChromaSubsample'
        """
        return self._chroma_subsample

    @chroma_subsample.setter
    def chroma_subsample(self, chroma_subsample):
        # type: ('VideoPixelFormat.LTypeChromaSubsample') -> None
        """Sets the chroma_subsample of this VideoPixelFormat.


        :param chroma_subsample: The chroma_subsample of this VideoPixelFormat.  # noqa: E501
        :type chroma_subsample: 'VideoPixelFormat.LTypeChromaSubsample'
        :rtype: None
        """
        allowed_values = ["yCbCr444RGB", "yCbCr422", "yCbCr420"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and chroma_subsample not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `chroma_subsample` ({0}), must be one of {1}".format(  # noqa: E501
                    chroma_subsample, allowed_values
                )
            )

        self._chroma_subsample = chroma_subsample

    LTypeColorimetry = Literal[
        "rGB",
        "opRGB",
        "rGBP3D65",
        "rGBP3DCI",
        "rGB2020",
        "yCC601",
        "yCC709",
        "xvYCC601",
        "xvYCC709",
        "sYCC601",
        "opYCC601",
        "yCC2020NCL",
        "yCC2020NL",
    ]

    @property
    def colorimetry(self):
        # type: () -> 'VideoPixelFormat.LTypeColorimetry'
        """Gets the colorimetry of this VideoPixelFormat.  # noqa: E501


        :return: The colorimetry of this VideoPixelFormat.  # noqa: E501
        :rtype: 'VideoPixelFormat.LTypeColorimetry'
        """
        return self._colorimetry

    @colorimetry.setter
    def colorimetry(self, colorimetry):
        # type: ('VideoPixelFormat.LTypeColorimetry') -> None
        """Sets the colorimetry of this VideoPixelFormat.


        :param colorimetry: The colorimetry of this VideoPixelFormat.  # noqa: E501
        :type colorimetry: 'VideoPixelFormat.LTypeColorimetry'
        :rtype: None
        """
        allowed_values = [
            "rGB",
            "opRGB",
            "rGBP3D65",
            "rGBP3DCI",
            "rGB2020",
            "yCC601",
            "yCC709",
            "xvYCC601",
            "xvYCC709",
            "sYCC601",
            "opYCC601",
            "yCC2020NCL",
            "yCC2020NL",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and colorimetry not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `colorimetry` ({0}), must be one of {1}".format(  # noqa: E501
                    colorimetry, allowed_values
                )
            )

        self._colorimetry = colorimetry

    @property
    def full_range(self):
        # type: () -> bool
        """Gets the full_range of this VideoPixelFormat.  # noqa: E501


        :return: The full_range of this VideoPixelFormat.  # noqa: E501
        :rtype: bool
        """
        return self._full_range

    @full_range.setter
    def full_range(self, full_range):
        # type: (bool) -> None
        """Sets the full_range of this VideoPixelFormat.


        :param full_range: The full_range of this VideoPixelFormat.  # noqa: E501
        :type full_range: bool
        :rtype: None
        """

        self._full_range = full_range

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoPixelFormat):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoPixelFormat):
            return True

        return self.to_dict() != other.to_dict()
