# coding: utf-8

"""
    Mozart platform API

    API for interacting with the Mozart platform.  # noqa: E501

    The version of the OpenAPI document: 0.2.0
    Contact: support@bang-olufsen.dk
    Generated by: https://openapi-generator.tech
"""


from setuptools import setup, find_packages  # noqa: H301

NAME = "mozart-api"
VERSION = "2.3.4.15123.4"
# To install the library, run the following
#
# python setup.py install
#
# prerequisite: setuptools
# http://pypi.python.org/pypi/setuptools

REQUIRES = [
    "aiohttp",
    "certifi",
    "inflection",
    "python_dateutil",
    "six",
    "urllib3",
    "zeroconf",
]

setup(
    name=NAME,
    version=VERSION,
    description="Mozart platform API",
    author="BangOlufsen",
    author_email="support@bang-olufsen.dk",
    url="https://pypi.org/project/mozart-api/",
    keywords=["OpenAPI", "OpenAPI-Generator", "Mozart platform API"],
    install_requires=REQUIRES,
    packages=find_packages(exclude=["test", "tests"]),
    include_package_data=True,
    license="MIT",
    long_description="""# Mozart platform API

[![License](https://img.shields.io/badge/license-MIT-green)](https://github.com/bang-olufsen/mozart-open-api/blob/main/LICENSE)
[![Version](https://img.shields.io/pypi/v/mozart-api?color=g)](https://pypi.org/project/mozart-api)
[![Downloads](https://img.shields.io/pypi/dm/mozart-api)](https://pypi.org/project/mozart-api)
![Python version](https://img.shields.io/pypi/pyversions/mozart-api)

[![Balance stereo](https://raw.githubusercontent.com/bang-olufsen/mozart-open-api/main/docs/media/balance_stereo.png)](https://www.bang-olufsen.com/en/dk/speakers/beosound-balance-stereo-set?variant=beosound-balance-gva-naturaloak-bundle)

The Mozart API is a REST API with async capabilities and WebSocket notification channel for immediate state information. Currently the API is distributed as a Python package and as an OpenAPI document that can be found in the [Github releases](https://github.com/bang-olufsen/mozart-open-api/releases).

Supported by:

- [Beolab 28](https://www.bang-olufsen.com/en/dk/speakers/beolab-28)
- [Beosound Balance](https://www.bang-olufsen.com/en/dk/speakers/beosound-balance)
- [Beosound Emerge](https://www.bang-olufsen.com/en/dk/speakers/beosound-emerge)
- [Beosound Level](https://www.bang-olufsen.com/en/dk/speakers/beosound-level)
- [Beosound Theatre](https://www.bang-olufsen.com/en/dk/soundbars/beosound-theatre)


API documentation can be found on the [Github page](https://bang-olufsen.github.io/mozart-open-api).
""",
    long_description_content_type="text/markdown",
    entry_points={
        "console_scripts": ["mozart_api = mozart_api.mozart_cli:MozartApiCli"]
    },
    project_urls={
        "Github": "https://github.com/bang-olufsen/mozart-open-api",
        "Documentation": "https://bang-olufsen.github.io/mozart-open-api/",
        "Bug tracker": "https://github.com/bang-olufsen/mozart-open-api/issues",
    },
    python_requires=">=3.8",
    classifiers=[
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.8",
        "Topic :: Multimedia",
        "Intended Audience :: Developers",
    ],
)
