"""
Django URL dispatcher for the cms package.
See :mod:`~integreat_cms.core.urls` for the other namespaces of this application.

For more information on this file, see :doc:`topics/http/urls`.
"""
from django.conf.urls import include, url
from django.conf import settings as django_settings
from django.views.generic import RedirectView

from .views import (
    authentication,
    analytics,
    chat,
    dashboard,
    events,
    offer_templates,
    language_tree,
    languages,
    linkcheck,
    media,
    organizations,
    imprint,
    pages,
    pois,
    push_notifications,
    regions,
    roles,
    settings,
    statistics,
    users,
    utils,
    feedback,
)

media_ajax_urlpatterns = [
    url(
        r"^media/",
        include(
            [
                url(
                    r"^directory-path$",
                    media.get_directory_path_ajax,
                    name="mediacenter_directory_path",
                ),
                url(
                    r"^directory-content$",
                    media.get_directory_content_ajax,
                    name="mediacenter_get_directory_content",
                ),
                url(
                    r"^upload-file$",
                    media.upload_file_ajax,
                    name="mediacenter_upload_file",
                ),
                url(
                    r"^edit-file$",
                    media.edit_file_ajax,
                    name="mediacenter_edit_file",
                ),
                url(
                    r"^delete-file$",
                    media.delete_file_ajax,
                    name="mediacenter_delete_file",
                ),
                url(
                    r"^replace-file$",
                    media.replace_file_ajax,
                    name="mediacenter_replace_file",
                ),
                url(
                    r"^create-directory$",
                    media.create_directory_ajax,
                    name="mediacenter_create_directory",
                ),
                url(
                    r"^update-directory$",
                    media.edit_directory_ajax,
                    name="mediacenter_edit_directory",
                ),
                url(
                    r"^delete-directory$",
                    media.delete_directory_ajax,
                    name="mediacenter_delete_directory",
                ),
            ]
        ),
    ),
]


urlpatterns = [
    url(
        r"^s/",
        include(
            [
                url(
                    r"^p/(?P<short_url_id>[0-9]+)$",
                    pages.expand_page_translation_id,
                    name="expand_page_translation_id",
                ),
                url(
                    r"^i/(?P<imprint_translation_id>[0-9]+)$",
                    imprint.expand_imprint_translation_id,
                    name="expand_imprint_translation_id",
                ),
            ]
        ),
    ),
    url(
        r"^wiki",
        RedirectView.as_view(url=django_settings.WIKI_URL),
        name="wiki_redirect",
    ),
    url(r"^$", dashboard.RedirectView.as_view(), name="redirect"),
    url(
        r"^admin_dashboard/$",
        dashboard.AdminDashboardView.as_view(),
        name="admin_dashboard",
    ),
    url(
        r"^region_selection/$",
        dashboard.RegionSelection.as_view(),
        name="region_selection",
    ),
    url(
        r"^regions/",
        include(
            [
                url(r"^$", regions.RegionListView.as_view(), name="regions"),
                url(r"^new$", regions.RegionView.as_view(), name="new_region"),
                url(
                    r"^(?P<region_slug>[-\w]+)/",
                    include(
                        [
                            url(
                                r"^edit$",
                                regions.RegionView.as_view(),
                                name="edit_region",
                            ),
                            url(
                                r"^delete$", regions.delete_region, name="delete_region"
                            ),
                        ]
                    ),
                ),
            ]
        ),
    ),
    url(r"^media-library/$", media.AdminMediaListView.as_view(), name="media_admin"),
    url(
        r"^languages/",
        include(
            [
                url(r"^$", languages.LanguageListView.as_view(), name="languages"),
                url(r"^new$", languages.LanguageView.as_view(), name="new_language"),
                url(
                    r"^(?P<language_slug>[-\w]+)/",
                    include(
                        [
                            url(
                                r"^edit$",
                                languages.LanguageView.as_view(),
                                name="edit_language",
                            ),
                            url(
                                r"^delete$",
                                languages.LanguageView.as_view(),
                                name="delete_language",
                            ),
                        ]
                    ),
                ),
            ]
        ),
    ),
    url(
        r"^users/",
        include(
            [
                url(r"^$", users.UserListView.as_view(), name="users"),
                url(r"^new$", users.UserView.as_view(), name="new_user"),
                url(
                    r"^(?P<user_id>[0-9]+)/",
                    include(
                        [
                            url(r"^edit$", users.UserView.as_view(), name="edit_user"),
                            url(r"^delete$", users.delete_user, name="delete_user"),
                            url(
                                r"^resend_activation_link$",
                                users.resend_activation_link,
                                name="resend_activation_link",
                            ),
                        ]
                    ),
                ),
            ]
        ),
    ),
    url(
        r"^roles/",
        include(
            [
                url(r"^$", roles.RoleListView.as_view(), name="roles"),
                url(r"^new$", roles.RoleView.as_view(), name="new_role"),
                url(
                    r"^(?P<role_id>[0-9]+)/",
                    include(
                        [
                            url(r"^edit$", roles.RoleView.as_view(), name="edit_role"),
                            url(
                                r"^delete$",
                                roles.RoleView.as_view(),
                                name="delete_role",
                            ),
                        ]
                    ),
                ),
            ]
        ),
    ),
    url(
        r"^organizations/",
        include(
            [
                url(
                    r"^$",
                    organizations.OrganizationListView.as_view(),
                    name="organizations",
                ),
                url(
                    r"^new$",
                    organizations.OrganizationView.as_view(),
                    name="new_organization",
                ),
                url(
                    r"^(?P<organization_id>[0-9]+)/",
                    include(
                        [
                            url(
                                r"^edit$",
                                organizations.OrganizationView.as_view(),
                                name="edit_organization",
                            ),
                            url(
                                r"^delete$",
                                organizations.organization_actions.delete,
                                name="delete_organization",
                            ),
                        ]
                    ),
                ),
            ]
        ),
    ),
    url(
        r"^feedback/",
        include(
            [
                url(
                    r"^$",
                    feedback.AdminFeedbackListView.as_view(),
                    name="admin_feedback",
                ),
                url(
                    r"^mark_read$",
                    feedback.mark_admin_feedback_as_read,
                    name="mark_admin_feedback_as_read",
                ),
                url(
                    r"^mark_unread$",
                    feedback.mark_admin_feedback_as_unread,
                    name="mark_admin_feedback_as_unread",
                ),
                url(
                    r"^delete$",
                    feedback.delete_admin_feedback,
                    name="delete_admin_feedback",
                ),
            ]
        ),
    ),
    url(
        r"^offer_templates/",
        include(
            [
                url(
                    r"^$",
                    offer_templates.OfferTemplateListView.as_view(),
                    name="offer_templates",
                ),
                url(
                    r"^new$",
                    offer_templates.OfferTemplateView.as_view(),
                    name="new_offer_template",
                ),
                url(
                    r"^(?P<offer_template_id>[0-9]+)/",
                    include(
                        [
                            url(
                                r"^edit$",
                                offer_templates.OfferTemplateView.as_view(),
                                name="edit_offer_template",
                            ),
                            url(
                                r"^delete$",
                                offer_templates.OfferTemplateView.as_view(),
                                name="delete_offer_templates",
                            ),
                        ]
                    ),
                ),
            ]
        ),
    ),
    url(
        r"^user_settings/",
        include(
            [
                url(r"^$", settings.UserSettingsView.as_view(), name="user_settings"),
                url(
                    r"^mfa/",
                    include(
                        [
                            url(
                                r"^authenticate/$",
                                settings.AuthenticateModifyMfaView.as_view(),
                                name="authenticate_modify_mfa",
                            ),
                            url(
                                r"^get_challenge/$",
                                settings.GetMfaChallengeView.as_view(),
                                name="get_mfa_challenge",
                            ),
                            url(
                                r"^register/$",
                                settings.RegisterUserMfaKeyView.as_view(),
                                name="register_new_mfa_key",
                            ),
                            url(
                                r"^delete/(?P<key_id>\d+)$",
                                settings.DeleteUserMfaKeyView.as_view(),
                                name="delete_mfa_key",
                            ),
                        ]
                    ),
                ),
            ]
        ),
    ),
    url(
        r"^login/",
        include(
            [
                url(r"^$", authentication.LoginView.as_view(), name="login"),
                url(
                    r"^mfa/",
                    include(
                        [
                            url(
                                r"^$",
                                authentication.MfaLoginView.as_view(),
                                name="login_mfa",
                            ),
                            url(
                                r"^assert$",
                                authentication.MfaAssertView.as_view(),
                                name="login_mfa_assert",
                            ),
                            url(
                                r"^verify$",
                                authentication.MfaVerifyView.as_view(),
                                name="login_mfa_verify",
                            ),
                        ]
                    ),
                ),
            ]
        ),
    ),
    url(r"^logout/$", authentication.LogoutView.as_view(), name="logout"),
    url(
        r"^reset-password/",
        include(
            [
                url(
                    r"^$",
                    authentication.PasswordResetView.as_view(),
                    name="password_reset",
                ),
                url(
                    r"^(?P<uidb64>[0-9A-Za-z]+)-(?P<token>.+)/$",
                    authentication.PasswordResetConfirmView.as_view(),
                    name="password_reset_confirm",
                ),
            ]
        ),
    ),
    url(
        r"^activate-account/(?P<uidb64>[0-9A-Za-z]+)-(?P<token>.+)/$",
        authentication.AccountActivationView.as_view(),
        name="activate_account",
    ),
    url(
        r"^ajax/",
        include(
            [
                url(
                    r"^render/",
                    include(
                        [
                            url(
                                r"^(?P<region_slug>[-\w]+)/mirrored_page_field/",
                                pages.render_mirrored_page_field,
                                name="render_mirrored_page_field",
                            ),
                        ]
                    ),
                ),
                url(
                    r"^chat/",
                    include(
                        [
                            url(
                                r"send-message/?$",
                                chat.send_chat_message,
                                name="send_chat_message",
                            ),
                            url(
                                r"delete-message/(?P<message_id>[0-9]+)?$",
                                chat.delete_chat_message,
                                name="delete_chat_message",
                            ),
                        ]
                    ),
                ),
                url(
                    r"^(?P<region_slug>[-\w]+)/statistics/",
                    include(
                        [
                            url(
                                r"total_views/?$",
                                statistics.get_total_visits_ajax,
                                name="statistics_total_visits",
                            ),
                            url(
                                r"update_chart/?$",
                                statistics.get_visits_per_language_ajax,
                                name="statistics_visits_per_language",
                            ),
                        ]
                    ),
                ),
                url(
                    r"^grant_page_permission$",
                    pages.grant_page_permission_ajax,
                    name="grant_page_permission_ajax",
                ),
                url(
                    r"^revoke_page_permission$",
                    pages.revoke_page_permission_ajax,
                    name="revoke_page_permission_ajax",
                ),
                url(
                    r"^(?P<region_slug>[-\w]+)/post_translation_state$",
                    pages.post_translation_state_ajax,
                    name="post_translation_state_ajax",
                ),
                url(
                    r"^(?P<region_slug>[-\w]+)/(?P<parent_id>[0-9]+)/new_order_table$",
                    pages.get_new_page_order_table_ajax,
                    name="get_new_page_order_table_ajax",
                ),
                url(
                    r"^(?P<region_slug>[-\w]+)/(?P<page_id>[0-9]+)/(?P<parent_id>[0-9]+)/order_table$",
                    pages.get_page_order_table_ajax,
                    name="get_page_order_table_ajax",
                ),
                url(
                    r"^(?P<region_slug>[-\w]+)/search_poi$",
                    events.search_poi_ajax,
                    name="search_poi_ajax",
                ),
                url(
                    r"^(?P<region_slug>[-\w]+)/(?P<language_slug>[-\w]+)/search_content$",
                    utils.search_content_ajax,
                    name="search_content_ajax",
                ),
                url(
                    r"^(?P<region_slug>[-\w]+)/search_content$",
                    utils.search_content_ajax,
                    name="search_content_ajax",
                ),
                url(
                    r"^search_content$",
                    utils.search_content_ajax,
                    name="search_content_ajax",
                ),
                url(
                    r"^(?P<region_slug>[-\w]+)/(?P<language_slug>[-\w]+)/(?P<model_type>event|page|poi)/slugify$",
                    utils.slugify_ajax,
                    name="slugify_ajax",
                ),
                url(
                    r"^(?P<region_slug>[-\w]+)/",
                    include(media_ajax_urlpatterns),
                ),
            ]
            + media_ajax_urlpatterns
        ),
    ),
    url(
        r"^(?P<region_slug>[-\w]+)/",
        include(
            [
                url(r"^$", dashboard.DashboardView.as_view(), name="dashboard"),
                url(
                    r"^analytics/",
                    analytics.AnalyticsView.as_view(),
                    name="analytics",
                ),
                url(
                    r"^statistics/$",
                    statistics.AnalyticsView.as_view(),
                    name="statistics",
                ),
                url(
                    r"^translation_coverage/",
                    analytics.TranslationCoverageView.as_view(),
                    name="translation_coverage",
                ),
                url(
                    r"^app_size/",
                    analytics.AppSizeView.as_view(),
                    name="app_size",
                ),
                url(
                    r"^linkcheck/$",
                    linkcheck.LinkListRedirectView.as_view(),
                    name="linkcheck_landing",
                ),
                url(
                    r"^linkcheck/(?P<link_filter>[-\w]+)/$",
                    linkcheck.LinkListView.as_view(),
                    name="linkcheck",
                ),
                url(
                    r"^pages/",
                    include(
                        [
                            url(r"^$", pages.PageTreeView.as_view(), name="pages"),
                            url(
                                r"^(?P<language_slug>[-\w]+)/",
                                include(
                                    [
                                        url(
                                            r"^$",
                                            pages.PageTreeView.as_view(),
                                            name="pages",
                                        ),
                                        url(
                                            r"^new$",
                                            pages.PageView.as_view(),
                                            name="new_page",
                                        ),
                                        url(
                                            r"^archived$",
                                            pages.PageTreeView.as_view(archived=True),
                                            name="archived_pages",
                                        ),
                                        url(
                                            r"^xliff/",
                                            include(
                                                [
                                                    url(
                                                        r"download",
                                                        pages.download_xliff,
                                                        name="download_xliff",
                                                    ),
                                                    url(
                                                        r"^upload$",
                                                        pages.upload_xliff,
                                                        name="upload_xliff",
                                                    ),
                                                    url(
                                                        r"^import/(?P<xliff_dir>[0-9a-f-]+)",
                                                        pages.PageXliffImportView.as_view(),
                                                        name="import_xliff",
                                                    ),
                                                ],
                                            ),
                                        ),
                                        url(
                                            r"^export$",
                                            pages.export_pdf,
                                            name="export_pdf",
                                        ),
                                        url(
                                            r"^(?P<page_id>[0-9]+)/",
                                            include(
                                                [
                                                    url(
                                                        r"^view$",
                                                        pages.view_page,
                                                        name="view_page",
                                                    ),
                                                    url(
                                                        r"^edit$",
                                                        pages.PageView.as_view(),
                                                        name="edit_page",
                                                    ),
                                                    url(
                                                        r"^sbs_edit$",
                                                        pages.PageSideBySideView.as_view(),
                                                        name="sbs_edit_page",
                                                    ),
                                                    url(
                                                        r"^revisions/",
                                                        include(
                                                            [
                                                                url(
                                                                    r"^$",
                                                                    pages.PageRevisionView.as_view(),
                                                                    name="page_revisions",
                                                                ),
                                                                url(
                                                                    r"^(?P<selected_revision>[0-9]+)$",
                                                                    pages.PageRevisionView.as_view(),
                                                                    name="page_revisions",
                                                                ),
                                                            ],
                                                        ),
                                                    ),
                                                    url(
                                                        r"^archive$",
                                                        pages.archive_page,
                                                        name="archive_page",
                                                    ),
                                                    url(
                                                        r"^restore$",
                                                        pages.restore_page,
                                                        name="restore_page",
                                                    ),
                                                    url(
                                                        r"^delete$",
                                                        pages.delete_page,
                                                        name="delete_page",
                                                    ),
                                                    # warning: the move url is also hardcoded in src/integreat_cms/static/js/tree_drag_and_drop.js
                                                    url(
                                                        r"^move/(?P<target_id>[0-9]+)/(?P<position>[-\w]+)$",
                                                        pages.move_page,
                                                        name="move_page",
                                                    ),
                                                ]
                                            ),
                                        ),
                                    ]
                                ),
                            ),
                        ]
                    ),
                ),
                url(
                    r"^imprint/",
                    include(
                        [
                            url(
                                r"^$",
                                imprint.ImprintView.as_view(),
                                name="edit_imprint",
                            ),
                            url(
                                r"^(?P<language_slug>[-\w]+)/",
                                include(
                                    [
                                        url(
                                            r"^$",
                                            imprint.ImprintView.as_view(),
                                            name="edit_imprint",
                                        ),
                                        url(
                                            r"^sbs_edit$",
                                            imprint.ImprintSideBySideView.as_view(),
                                            name="sbs_edit_imprint",
                                        ),
                                        url(
                                            r"^revisions/",
                                            include(
                                                [
                                                    url(
                                                        r"^$",
                                                        imprint.ImprintRevisionView.as_view(),
                                                        name="imprint_revisions",
                                                    ),
                                                    url(
                                                        r"^(?P<selected_revision>[0-9]+)$",
                                                        imprint.ImprintRevisionView.as_view(),
                                                        name="imprint_revisions",
                                                    ),
                                                ],
                                            ),
                                        ),
                                    ]
                                ),
                            ),
                            url(
                                r"^archive$",
                                imprint.archive_imprint,
                                name="archive_imprint",
                            ),
                            url(
                                r"^restore$",
                                imprint.restore_imprint,
                                name="restore_imprint",
                            ),
                            url(
                                r"^delete$",
                                imprint.delete_imprint,
                                name="delete_imprint",
                            ),
                        ]
                    ),
                ),
                # TODO: Change destination for delete_event, add view_event
                url(
                    r"^events/",
                    include(
                        [
                            url(r"^$", events.EventListView.as_view(), name="events"),
                            url(
                                r"^(?P<language_slug>[-\w]+)/",
                                include(
                                    [
                                        url(
                                            r"^$",
                                            events.EventListView.as_view(),
                                            name="events",
                                        ),
                                        url(
                                            r"^archived$",
                                            events.EventListView.as_view(archived=True),
                                            name="events_archived",
                                        ),
                                        url(
                                            r"^new$",
                                            events.EventView.as_view(),
                                            name="new_event",
                                        ),
                                        url(
                                            r"^(?P<event_id>[0-9]+)/",
                                            include(
                                                [
                                                    url(
                                                        r"^edit$",
                                                        events.EventView.as_view(),
                                                        name="edit_event",
                                                    ),
                                                    url(
                                                        r"^duplicate$",
                                                        events.duplicate,
                                                        name="duplicate_event",
                                                    ),
                                                    url(
                                                        r"^archive$",
                                                        events.archive,
                                                        name="archive_event",
                                                    ),
                                                    url(
                                                        r"^restore$",
                                                        events.restore,
                                                        name="restore_event",
                                                    ),
                                                    url(
                                                        r"^delete$",
                                                        events.delete,
                                                        name="delete_event",
                                                    ),
                                                ]
                                            ),
                                        ),
                                    ]
                                ),
                            ),
                        ]
                    ),
                ),
                url(
                    r"^pois/",
                    include(
                        [
                            url(r"^$", pois.POIListView.as_view(), name="pois"),
                            url(
                                r"^(?P<language_slug>[-\w]+)/",
                                include(
                                    [
                                        url(
                                            r"^$",
                                            pois.POIListView.as_view(),
                                            name="pois",
                                        ),
                                        url(
                                            r"^archived$",
                                            pois.POIListView.as_view(archived=True),
                                            name="archived_pois",
                                        ),
                                        url(
                                            r"^new$",
                                            pois.POIView.as_view(),
                                            name="new_poi",
                                        ),
                                        url(
                                            r"^(?P<poi_id>[0-9]+)/",
                                            include(
                                                [
                                                    url(
                                                        r"^view$",
                                                        pois.view_poi,
                                                        name="view_poi",
                                                    ),
                                                    url(
                                                        r"^edit$",
                                                        pois.POIView.as_view(),
                                                        name="edit_poi",
                                                    ),
                                                    url(
                                                        r"^archive$",
                                                        pois.archive_poi,
                                                        name="archive_poi",
                                                    ),
                                                    url(
                                                        r"^restore$",
                                                        pois.restore_poi,
                                                        name="restore_poi",
                                                    ),
                                                    url(
                                                        r"^delete$",
                                                        pois.delete_poi,
                                                        name="delete_poi",
                                                    ),
                                                ]
                                            ),
                                        ),
                                    ]
                                ),
                            ),
                        ]
                    ),
                ),
                url(
                    r"^feedback/",
                    include(
                        [
                            url(
                                r"^$",
                                feedback.RegionFeedbackListView.as_view(),
                                name="region_feedback",
                            ),
                            url(
                                r"^mark_read$",
                                feedback.mark_region_feedback_as_read,
                                name="mark_region_feedback_as_read",
                            ),
                            url(
                                r"^mark_unread$",
                                feedback.mark_region_feedback_as_unread,
                                name="mark_region_feedback_as_unread",
                            ),
                            url(
                                r"^delete$",
                                feedback.delete_region_feedback,
                                name="delete_region_feedback",
                            ),
                        ]
                    ),
                ),
                url(
                    r"^push_notifications/",
                    include(
                        [
                            url(
                                r"^$",
                                push_notifications.PushNotificationListView.as_view(),
                                name="push_notifications",
                            ),
                            url(
                                r"^(?P<language_slug>[-\w]+)/",
                                include(
                                    [
                                        url(
                                            r"^$",
                                            push_notifications.PushNotificationListView.as_view(),
                                            name="push_notifications",
                                        ),
                                        url(
                                            r"^new$",
                                            push_notifications.PushNotificationView.as_view(),
                                            name="new_push_notification",
                                        ),
                                        url(
                                            r"^(?P<push_notification_id>[0-9]+)/",
                                            include(
                                                [
                                                    url(
                                                        r"^edit$",
                                                        push_notifications.PushNotificationView.as_view(),
                                                        name="edit_push_notification",
                                                    ),
                                                ]
                                            ),
                                        ),
                                    ]
                                ),
                            ),
                        ]
                    ),
                ),
                url(
                    r"^language-tree/",
                    include(
                        [
                            url(
                                r"^$",
                                language_tree.LanguageTreeView.as_view(),
                                name="language_tree",
                            ),
                            url(
                                r"^new$",
                                language_tree.LanguageTreeNodeView.as_view(),
                                name="new_language_tree_node",
                            ),
                            url(
                                r"^(?P<language_tree_node_id>[0-9]+)/",
                                include(
                                    [
                                        url(
                                            r"^edit$",
                                            language_tree.LanguageTreeNodeView.as_view(),
                                            name="edit_language_tree_node",
                                        ),
                                        url(
                                            r"^delete$",
                                            language_tree.delete_language_tree_node,
                                            name="delete_language_tree_node",
                                        ),
                                        # warning: the move url is also hardcoded in src/integreat_cms/static/js/tree_drag_and_drop.js
                                        url(
                                            r"^move/(?P<target_id>[0-9]+)/(?P<target_position>[-\w]+)$",
                                            language_tree.move_language_tree_node,
                                            name="move_language_tree_node",
                                        ),
                                    ]
                                ),
                            ),
                        ]
                    ),
                ),
                url(r"^media-library/$", media.MediaListView.as_view(), name="media"),
                url(
                    r"^users/",
                    include(
                        [
                            url(
                                r"^$",
                                users.RegionUserListView.as_view(),
                                name="region_users",
                            ),
                            url(
                                r"^new$",
                                users.RegionUserView.as_view(),
                                name="new_region_user",
                            ),
                            url(
                                r"^(?P<user_id>[0-9]+)/",
                                include(
                                    [
                                        url(
                                            r"^edit$",
                                            users.RegionUserView.as_view(),
                                            name="edit_region_user",
                                        ),
                                        url(
                                            r"^delete$",
                                            users.delete_region_user,
                                            name="delete_region_user",
                                        ),
                                        url(
                                            r"^resend_activation_link$",
                                            users.resend_activation_link_region,
                                            name="resend_activation_link_region",
                                        ),
                                    ]
                                ),
                            ),
                        ]
                    ),
                ),
                url(
                    r"^user_settings/$",
                    settings.UserSettingsView.as_view(),
                    name="user_settings",
                ),
            ]
        ),
    ),
    url(
        r"^favicon\.ico$", RedirectView.as_view(url="/static/images/integreat-icon.png")
    ),
]
