# Jovian: The platform for all your Data Science projects

![](/docs/jovian_horizontal_logo.svg)

jovian is an open-source Python package integrated with [Jovian](https://jovian.ml/?utm_source=github) to provide the tools necessary for Data Scientists and ML/DL Engineers to **Track**, **Collaborate** and **Automate** projects where even Students and Enthusiasts can leverage the same and also use [Jovian](https://jovian.ml/?utm_source=github) **Share** and **Showcase** their projects.

- [Upload and share Jupyter Notebooks](https://jovian.ml/docs/user-guide/upload.html)
- [Reproduce Notebooks from Jovian](https://jovian.ml/docs/user-guide/reproduce.html)
- [Notebooks as version, view Diffs between versions](https://jovian.ml/docs/user-guide/version.html)
- [Attaching utility files and model outputs with the Notebook](https://jovian.ml/docs/user-guide/attach.html)
- [Tracking Datasets, Hyperparameters and Metrics](https://jovian.ml/docs/user-guide/track.html)
- [Comparing and Analyzing all the experiments](https://jovian.ml/docs/user-guide/compare.html)
- [Collaborate with teammates/colleagues](https://jovian.ml/docs/user-guide/collaborate.html)
- [Stay connected with your model training, live updates with Slack Notifications](https://jovian.ml/docs/user-guide/integrations.html)
- [Embed Jupyter Notebooks and Cell upload on Jovian.ml](https://jovian.ml/docs/user-guide/embed.html)

[![Documentation Status](https://readthedocs.org/projects/jovian-py/badge/?version=latest)](https://jovian.ml/docs/)

## Installation

```
pip install jovian --upgrade
```

> **Caution**:
>
> If you get a `Permission denied` error, try installing with sudo permission (on Linux/Mac).
>
> ```
> sudo pip install jovian --upgrade
> ```
>
> Another alternative is to try installing with the `--user` flag, but you’ll need to ensure that the target directory is added to your system `PATH`.
>
> ```
> pip install jovian --upgrade --user
> ```

Visit [Docs](https://jovian.ml/docs/) for more.

## Contribution Guidelines

If you want to contribute to **jovian**(Python package), review the [**Contribution Page**](https://github.com/JovianML/jovian-py/blob/master/CONTRIBUTING.md).

<table>
    <tr>
        <th> </th>
        <th>jovian(Python Package)</th>
        <th>Jovian(Webapp)</th>
    </tr>
    <tr>
        <td>Issues or Feature Request</td>
        <td align="center"> <a href="https://github.com/JovianML/jovian-py/issues">Forum</a> </td>
        <td align="center"> <a href="https://github.com/JovianML/jovian-support/issues">Forum</a> </td>
    </tr>
    <tr>
        <td>Repository and Website</td>
        <td align="center"> <a href="https://github.com/JovianML">Repo</a> </td>
        <td align="center"> <a href="https://jovian.ml/?utm_source=github">Website</a> </td>
    </tr>
    <tr>
        <td>Slack Discussions</td>
        <td align="center" colspan=2> <a href="https://bit.ly/jovian-users">Slack Invite</a> </td>
    </tr>
</table>

## Contact

Mail : hello@jovian.ml
<br>
Twitter : [@JovianML](https://twitter.com/JovianML)
<br>
Slack : [Slack Invite](https://bit.ly/jovian-users)
