import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::Route53::HealthCheck`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 */
export interface CfnHealthCheckProps {
    /**
     * `AWS::Route53::HealthCheck.HealthCheckConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthcheckconfig
     */
    readonly healthCheckConfig: any | cdk.IResolvable;
    /**
     * `AWS::Route53::HealthCheck.HealthCheckTags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthchecktags
     */
    readonly healthCheckTags?: Array<CfnHealthCheck.HealthCheckTagProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Route53::HealthCheck`
 *
 * @cloudformationResource AWS::Route53::HealthCheck
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 */
export declare class CfnHealthCheck extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::HealthCheck";
    /**
     * @cloudformationAttribute HealthCheckId
     */
    readonly attrHealthCheckId: string;
    /**
     * `AWS::Route53::HealthCheck.HealthCheckConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthcheckconfig
     */
    healthCheckConfig: any | cdk.IResolvable;
    /**
     * `AWS::Route53::HealthCheck.HealthCheckTags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthchecktags
     */
    healthCheckTags: Array<CfnHealthCheck.HealthCheckTagProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Route53::HealthCheck`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnHealthCheckProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnHealthCheck {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html
     */
    interface HealthCheckTagProperty {
        /**
         * `CfnHealthCheck.HealthCheckTagProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html#cfn-route53-healthcheck-healthchecktag-key
         */
        readonly key: string;
        /**
         * `CfnHealthCheck.HealthCheckTagProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html#cfn-route53-healthcheck-healthchecktag-value
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::Route53::HostedZone`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 */
export interface CfnHostedZoneProps {
    /**
     * `AWS::Route53::HostedZone.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-name
     */
    readonly name: string;
    /**
     * `AWS::Route53::HostedZone.HostedZoneConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzoneconfig
     */
    readonly hostedZoneConfig?: CfnHostedZone.HostedZoneConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::HostedZone.HostedZoneTags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzonetags
     */
    readonly hostedZoneTags?: CfnHostedZone.HostedZoneTagProperty[];
    /**
     * `AWS::Route53::HostedZone.QueryLoggingConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-queryloggingconfig
     */
    readonly queryLoggingConfig?: CfnHostedZone.QueryLoggingConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::HostedZone.VPCs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-vpcs
     */
    readonly vpcs?: Array<CfnHostedZone.VPCProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Route53::HostedZone`
 *
 * @cloudformationResource AWS::Route53::HostedZone
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 */
export declare class CfnHostedZone extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::HostedZone";
    /**
     * @cloudformationAttribute NameServers
     */
    readonly attrNameServers: string[];
    /**
     * `AWS::Route53::HostedZone.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-name
     */
    name: string;
    /**
     * `AWS::Route53::HostedZone.HostedZoneConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzoneconfig
     */
    hostedZoneConfig: CfnHostedZone.HostedZoneConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::HostedZone.HostedZoneTags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzonetags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Route53::HostedZone.QueryLoggingConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-queryloggingconfig
     */
    queryLoggingConfig: CfnHostedZone.QueryLoggingConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::HostedZone.VPCs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-vpcs
     */
    vpcs: Array<CfnHostedZone.VPCProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Route53::HostedZone`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnHostedZoneProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnHostedZone {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzoneconfig.html
     */
    interface HostedZoneConfigProperty {
        /**
         * `CfnHostedZone.HostedZoneConfigProperty.Comment`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzoneconfig.html#cfn-route53-hostedzone-hostedzoneconfig-comment
         */
        readonly comment?: string;
    }
}
export declare namespace CfnHostedZone {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzonetags.html
     */
    interface HostedZoneTagProperty {
        /**
         * `CfnHostedZone.HostedZoneTagProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzonetags.html#cfn-route53-hostedzonetags-key
         */
        readonly key: string;
        /**
         * `CfnHostedZone.HostedZoneTagProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzonetags.html#cfn-route53-hostedzonetags-value
         */
        readonly value: string;
    }
}
export declare namespace CfnHostedZone {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-queryloggingconfig.html
     */
    interface QueryLoggingConfigProperty {
        /**
         * `CfnHostedZone.QueryLoggingConfigProperty.CloudWatchLogsLogGroupArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-queryloggingconfig.html#cfn-route53-hostedzone-queryloggingconfig-cloudwatchlogsloggrouparn
         */
        readonly cloudWatchLogsLogGroupArn: string;
    }
}
export declare namespace CfnHostedZone {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone-hostedzonevpcs.html
     */
    interface VPCProperty {
        /**
         * `CfnHostedZone.VPCProperty.VPCId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone-hostedzonevpcs.html#cfn-route53-hostedzone-hostedzonevpcs-vpcid
         */
        readonly vpcId: string;
        /**
         * `CfnHostedZone.VPCProperty.VPCRegion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone-hostedzonevpcs.html#cfn-route53-hostedzone-hostedzonevpcs-vpcregion
         */
        readonly vpcRegion: string;
    }
}
/**
 * Properties for defining a `AWS::Route53::RecordSet`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
 */
export interface CfnRecordSetProps {
    /**
     * `AWS::Route53::RecordSet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-name
     */
    readonly name: string;
    /**
     * `AWS::Route53::RecordSet.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-type
     */
    readonly type: string;
    /**
     * `AWS::Route53::RecordSet.AliasTarget`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
     */
    readonly aliasTarget?: CfnRecordSet.AliasTargetProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::RecordSet.Comment`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-comment
     */
    readonly comment?: string;
    /**
     * `AWS::Route53::RecordSet.Failover`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-failover
     */
    readonly failover?: string;
    /**
     * `AWS::Route53::RecordSet.GeoLocation`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
     */
    readonly geoLocation?: CfnRecordSet.GeoLocationProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::RecordSet.HealthCheckId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-healthcheckid
     */
    readonly healthCheckId?: string;
    /**
     * `AWS::Route53::RecordSet.HostedZoneId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzoneid
     */
    readonly hostedZoneId?: string;
    /**
     * `AWS::Route53::RecordSet.HostedZoneName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzonename
     */
    readonly hostedZoneName?: string;
    /**
     * `AWS::Route53::RecordSet.MultiValueAnswer`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
     */
    readonly multiValueAnswer?: boolean | cdk.IResolvable;
    /**
     * `AWS::Route53::RecordSet.Region`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-region
     */
    readonly region?: string;
    /**
     * `AWS::Route53::RecordSet.ResourceRecords`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-resourcerecords
     */
    readonly resourceRecords?: string[];
    /**
     * `AWS::Route53::RecordSet.SetIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-setidentifier
     */
    readonly setIdentifier?: string;
    /**
     * `AWS::Route53::RecordSet.TTL`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-ttl
     */
    readonly ttl?: string;
    /**
     * `AWS::Route53::RecordSet.Weight`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-weight
     */
    readonly weight?: number;
}
/**
 * A CloudFormation `AWS::Route53::RecordSet`
 *
 * @cloudformationResource AWS::Route53::RecordSet
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
 */
export declare class CfnRecordSet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::RecordSet";
    /**
     * `AWS::Route53::RecordSet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-name
     */
    name: string;
    /**
     * `AWS::Route53::RecordSet.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-type
     */
    type: string;
    /**
     * `AWS::Route53::RecordSet.AliasTarget`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
     */
    aliasTarget: CfnRecordSet.AliasTargetProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::RecordSet.Comment`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-comment
     */
    comment: string | undefined;
    /**
     * `AWS::Route53::RecordSet.Failover`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-failover
     */
    failover: string | undefined;
    /**
     * `AWS::Route53::RecordSet.GeoLocation`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
     */
    geoLocation: CfnRecordSet.GeoLocationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::RecordSet.HealthCheckId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-healthcheckid
     */
    healthCheckId: string | undefined;
    /**
     * `AWS::Route53::RecordSet.HostedZoneId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzoneid
     */
    hostedZoneId: string | undefined;
    /**
     * `AWS::Route53::RecordSet.HostedZoneName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzonename
     */
    hostedZoneName: string | undefined;
    /**
     * `AWS::Route53::RecordSet.MultiValueAnswer`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
     */
    multiValueAnswer: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::RecordSet.Region`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-region
     */
    region: string | undefined;
    /**
     * `AWS::Route53::RecordSet.ResourceRecords`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-resourcerecords
     */
    resourceRecords: string[] | undefined;
    /**
     * `AWS::Route53::RecordSet.SetIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-setidentifier
     */
    setIdentifier: string | undefined;
    /**
     * `AWS::Route53::RecordSet.TTL`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-ttl
     */
    ttl: string | undefined;
    /**
     * `AWS::Route53::RecordSet.Weight`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-weight
     */
    weight: number | undefined;
    /**
     * Create a new `AWS::Route53::RecordSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRecordSetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnRecordSet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html
     */
    interface AliasTargetProperty {
        /**
         * `CfnRecordSet.AliasTargetProperty.DNSName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-dnshostname
         */
        readonly dnsName: string;
        /**
         * `CfnRecordSet.AliasTargetProperty.EvaluateTargetHealth`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-evaluatetargethealth
         */
        readonly evaluateTargetHealth?: boolean | cdk.IResolvable;
        /**
         * `CfnRecordSet.AliasTargetProperty.HostedZoneId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-hostedzoneid
         */
        readonly hostedZoneId: string;
    }
}
export declare namespace CfnRecordSet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html
     */
    interface GeoLocationProperty {
        /**
         * `CfnRecordSet.GeoLocationProperty.ContinentCode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-continentcode
         */
        readonly continentCode?: string;
        /**
         * `CfnRecordSet.GeoLocationProperty.CountryCode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-countrycode
         */
        readonly countryCode?: string;
        /**
         * `CfnRecordSet.GeoLocationProperty.SubdivisionCode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-subdivisioncode
         */
        readonly subdivisionCode?: string;
    }
}
/**
 * Properties for defining a `AWS::Route53::RecordSetGroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 */
export interface CfnRecordSetGroupProps {
    /**
     * `AWS::Route53::RecordSetGroup.Comment`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-comment
     */
    readonly comment?: string;
    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzoneid
     */
    readonly hostedZoneId?: string;
    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzonename
     */
    readonly hostedZoneName?: string;
    /**
     * `AWS::Route53::RecordSetGroup.RecordSets`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-recordsets
     */
    readonly recordSets?: Array<CfnRecordSetGroup.RecordSetProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Route53::RecordSetGroup`
 *
 * @cloudformationResource AWS::Route53::RecordSetGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 */
export declare class CfnRecordSetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::RecordSetGroup";
    /**
     * `AWS::Route53::RecordSetGroup.Comment`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-comment
     */
    comment: string | undefined;
    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzoneid
     */
    hostedZoneId: string | undefined;
    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzonename
     */
    hostedZoneName: string | undefined;
    /**
     * `AWS::Route53::RecordSetGroup.RecordSets`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-recordsets
     */
    recordSets: Array<CfnRecordSetGroup.RecordSetProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Route53::RecordSetGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnRecordSetGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnRecordSetGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html
     */
    interface AliasTargetProperty {
        /**
         * `CfnRecordSetGroup.AliasTargetProperty.DNSName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-dnshostname
         */
        readonly dnsName: string;
        /**
         * `CfnRecordSetGroup.AliasTargetProperty.EvaluateTargetHealth`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-evaluatetargethealth
         */
        readonly evaluateTargetHealth?: boolean | cdk.IResolvable;
        /**
         * `CfnRecordSetGroup.AliasTargetProperty.HostedZoneId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-hostedzoneid
         */
        readonly hostedZoneId: string;
    }
}
export declare namespace CfnRecordSetGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html
     */
    interface GeoLocationProperty {
        /**
         * `CfnRecordSetGroup.GeoLocationProperty.ContinentCode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordsetgroup-geolocation-continentcode
         */
        readonly continentCode?: string;
        /**
         * `CfnRecordSetGroup.GeoLocationProperty.CountryCode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-countrycode
         */
        readonly countryCode?: string;
        /**
         * `CfnRecordSetGroup.GeoLocationProperty.SubdivisionCode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-subdivisioncode
         */
        readonly subdivisionCode?: string;
    }
}
export declare namespace CfnRecordSetGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
     */
    interface RecordSetProperty {
        /**
         * `CfnRecordSetGroup.RecordSetProperty.AliasTarget`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
         */
        readonly aliasTarget?: CfnRecordSetGroup.AliasTargetProperty | cdk.IResolvable;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Comment`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-comment
         */
        readonly comment?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Failover`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-failover
         */
        readonly failover?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.GeoLocation`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
         */
        readonly geoLocation?: CfnRecordSetGroup.GeoLocationProperty | cdk.IResolvable;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.HealthCheckId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-healthcheckid
         */
        readonly healthCheckId?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.HostedZoneId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzoneid
         */
        readonly hostedZoneId?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.HostedZoneName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzonename
         */
        readonly hostedZoneName?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.MultiValueAnswer`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
         */
        readonly multiValueAnswer?: boolean | cdk.IResolvable;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-name
         */
        readonly name: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Region`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-region
         */
        readonly region?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.ResourceRecords`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-resourcerecords
         */
        readonly resourceRecords?: string[];
        /**
         * `CfnRecordSetGroup.RecordSetProperty.SetIdentifier`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-setidentifier
         */
        readonly setIdentifier?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.TTL`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-ttl
         */
        readonly ttl?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-type
         */
        readonly type: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Weight`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-weight
         */
        readonly weight?: number;
    }
}
