# Copyright: (c) 2018, Ansible Project
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import annotations

import json

# Imported for backwards compat
from arolemgr.module_utils.common.json import AnsibleJSONEncoder  # pylint: disable=unused-import

from arolemgr.parsing.vault import VaultLib
from arolemgr.parsing.yaml.objects import AnsibleVaultEncryptedUnicode
from arolemgr.utils.unsafe_proxy import wrap_var


class AnsibleJSONDecoder(json.JSONDecoder):

    _vaults = {}  # type: dict[str, VaultLib]

    def __init__(self, *args, **kwargs):
        kwargs['object_hook'] = self.object_hook
        super(AnsibleJSONDecoder, self).__init__(*args, **kwargs)

    @classmethod
    def set_secrets(cls, secrets):
        cls._vaults['default'] = VaultLib(secrets=secrets)

    def object_hook(self, pairs):
        for key in pairs:
            value = pairs[key]

            if key == '__ansible_vault':
                value = AnsibleVaultEncryptedUnicode(value)
                if self._vaults:
                    value.vault = self._vaults['default']
                return value
            elif key == '__ansible_unsafe':
                return wrap_var(value)

        return pairs
