# Copyright 2015 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
"""Batch Normalization V1 layer."""


from tf_keras.src.layers.normalization import batch_normalization

# isort: off
from tensorflow.python.util.tf_export import keras_export


@keras_export(v1=["keras.layers.BatchNormalization"])
class BatchNormalization(batch_normalization.BatchNormalizationBase):
    _USE_V2_BEHAVIOR = False

    def __init__(self, *args, **kwargs):
        # synchronized not implemented in V1
        kwargs.pop("synchronized", None)
        super().__init__(*args, **kwargs)

