<a id="mypy-boto3-sdb"></a>

# mypy-boto3-sdb

[![PyPI - mypy-boto3-sdb](https://img.shields.io/pypi/v/mypy-boto3-sdb.svg?color=blue)](https://pypi.org/project/mypy-boto3-sdb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sdb.svg?color=blue)](https://pypi.org/project/mypy-boto3-sdb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-sdb?color=blue)](https://pypistats.org/packages/mypy-boto3-sdb)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/main/logo.png)

Type annotations for
[boto3.SimpleDB 1.20.49](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/sdb.html#SimpleDB)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.4.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-sdb docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sdb/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/main/demo.gif)

- [mypy-boto3-sdb](#mypy-boto3-sdb)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `SimpleDB`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `SimpleDB` service.

```bash
# install with boto3 type annotations
python -m pip install 'boto3-stubs[sdb]'

# Lite version does not provide session.client/resource overloads
# it is more RAM-friendly, but requires explicit type annotations
python -m pip install 'boto3-stubs-lite[sdb]'

# standalone installation
python -m pip install mypy-boto3-sdb
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto3-stubs[sdb]` in your environment:
  `python -m pip install 'boto3-stubs[sdb]'`

Both type checking and auto-complete should work for `SimpleDB` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto3-stubs[sdb]` in your environment:
  `python -m pip install 'boto3-stubs[sdb]'`

Both type checking and auto-complete should work for `SimpleDB` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto3-stubs[sdb]` in your environment:
  `python -m pip install 'boto3-stubs[sdb]'`
- Run `mypy` as usual

Type checking should work for `SimpleDB` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto3-stubs[sdb]` in your environment:
  `python -m pip install 'boto3-stubs[sdb]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SimpleDB` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`SimpleDBClient` provides annotations for `boto3.client("sdb")`.

```python
from boto3.session import Session

from mypy_boto3_sdb import SimpleDBClient

client: SimpleDBClient = Session().client("sdb")

# now client usage is checked by mypy and IDE should provide code auto-complete
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_sdb.paginator` module contains type annotations for all paginators.

```python
from boto3.session import Session

from mypy_boto3_sdb import SimpleDBClient
from mypy_boto3_sdb.paginator import (
    ListDomainsPaginator,
    SelectPaginator,
)

client: SimpleDBClient = Session().client("sdb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_domains_paginator: ListDomainsPaginator = client.get_paginator("list_domains")
select_paginator: SelectPaginator = client.get_paginator("select")
```

<a id="literals"></a>

### Literals

`mypy_boto3_sdb.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_sdb.literals import (
    ListDomainsPaginatorName,
    SelectPaginatorName,
    ServiceName,
    PaginatorName,
)

def check_value(value: ListDomainsPaginatorName) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_sdb.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_sdb.type_defs import (
    AttributeTypeDef,
    BatchDeleteAttributesRequestRequestTypeDef,
    BatchPutAttributesRequestRequestTypeDef,
    CreateDomainRequestRequestTypeDef,
    DeletableItemTypeDef,
    DeleteAttributesRequestRequestTypeDef,
    DeleteDomainRequestRequestTypeDef,
    DomainMetadataRequestRequestTypeDef,
    DomainMetadataResultTypeDef,
    GetAttributesRequestRequestTypeDef,
    GetAttributesResultTypeDef,
    ItemTypeDef,
    ListDomainsRequestRequestTypeDef,
    ListDomainsResultTypeDef,
    PaginatorConfigTypeDef,
    PutAttributesRequestRequestTypeDef,
    ReplaceableAttributeTypeDef,
    ReplaceableItemTypeDef,
    ResponseMetadataTypeDef,
    SelectRequestRequestTypeDef,
    SelectResultTypeDef,
    UpdateConditionTypeDef,
)

def get_structure() -> AttributeTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-sdb` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-sdb docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sdb/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
