# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2018-04-18 18:42


from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('models', '3098_custom_map_markers'),
    ]

    operations = [
        migrations.AddField(
            model_name='graphmodel',
            name='color',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.RunSQL("""
            update graphs as g
            set color = n.config->'fillColor'
            from nodes as n
            where n.graphid = g.graphid and g.isresource = true and n.istopnode = true and n.config is not NULL;
            update graphs set color = replace(color, '"', '');
            update nodes set config = config - 'fillColor' where istopnode = true and config is not NULL;
            """,
            """
            update nodes as n
            set config = jsonb_set(config, '{fillColor}', to_jsonb(g.color), true)
            from graphs as g
            where n.graphid = g.graphid and g.isresource = true and n.istopnode = true;
            """)
        ]
