# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['oka']

package_data = \
{'': ['*']}

install_requires = \
['idict>=1.211130.2,<2.0.0',
 'python-dotenv>=0.19.2,<0.20.0',
 'requests>=2.26.0,<3.0.0']

setup_kwargs = {
    'name': 'oka',
    'version': '0.211130.2',
    'description': 'Python client for oka repository',
    'long_description': '![test](https://github.com/rabizao/oka/workflows/test/badge.svg)\n[![codecov](https://codecov.io/gh/rabizao/oka/branch/main/graph/badge.svg)](https://codecov.io/gh/rabizao/oka)\n<a href="https://pypi.org/project/oka">\n<img src="https://img.shields.io/pypi/v/oka.svg?label=release&color=blue&style=flat-square" alt="pypi">\n</a>\n![Python version](https://img.shields.io/badge/python-3.8%20%7C%203.9-blue.svg)\n[![license: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)\n\n[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.5501845.svg)](https://doi.org/10.5281/zenodo.5501845)\n[![arXiv](https://img.shields.io/badge/arXiv-2109.06028-b31b1b.svg?style=flat-square)](https://arxiv.org/abs/2109.06028)\n[![User Manual](https://img.shields.io/badge/doc-user%20manual-a0a0a0.svg)](https://rabizao.github.io/oka)\n[![API Documentation](https://img.shields.io/badge/doc-API%20%28auto%29-a0a0a0.svg)](https://rabizao.github.io/oka/api)\n\n# oka - Client for OKA repository\n[Latest version as a package](https://pypi.org/project/oka)\n\n[Current code](https://github.com/rabizao/oka)\n\n[User manual](https://rabizao.github.io/oka)\n\n[API documentation](https://rabizao.github.io/oka/api)\n\n## Overview\n`oka` is a client for Oka repository.\nIt also provides utilities to process data.\n\n## Installation\n### ...as a standalone lib\n```bash\n# Set up a virtualenv. \npython3 -m venv venv\nsource venv/bin/activate\n\n# Install from PyPI...\npip install --upgrade pip\npip install -U oka\npip install -U oka[full]  # use the flag \'full\' for extra functionality (recommended)\n\n# ...or, install from updated source code.\npip install git+https://github.com/rabizao/oka\n```\n    \n### ...from source\n```bash\nsudo apt install python3.8-venv python3.8-dev python3.8-distutils # For Debian-like systems.\ngit clone https://github.com/rabizao/oka\ncd oka\npython3.8 -m venv venv\nsource venv/bin/activate\npip install -e .\n```\n\n## Usage\n\n\n\n\n\n\n**Hello world**\n<details>\n<p>\n\n```python3\nfrom oka import Oka, generate_token, toy_df\n\n# Create a pandas dataframe.\ndf = toy_df()\nprint(df.head())\n"""\n   attr1  attr2  class\n0    5.1    6.4      0\n1    1.1    2.5      1\n2    6.1    3.6      0\n3    1.1    3.5      1\n4    3.1    2.5      0\n"""\n```\n\n```python3\n\n# Login.\ntoken = generate_token("http://localhost:5000")\nclient = Oka(token, "http://localhost:5000")\n\n# Store.\nid = client.send(df)\n\n# Store again.\nid = client.send(df)\n"""\nContent already stored for id iJ_e4463c51904e9efb800533d25082af2a7bf77\n"""\n\n# Fetch.\ndf = client.get(id)\n\nprint(df.head())\n"""\n   attr1  attr2  class\n0    5.1    6.4      0\n1    1.1    2.5      1\n2    6.1    3.6      0\n3    1.1    3.5      1\n4    3.1    2.5      0\n"""\n```\n\n</p>\n</details>\n\n\n\n\n\n\n\n\n\n**DataFrame by hand**\n<details>\n<p>\n\n```python3\nimport pandas as pd\nfrom oka import Oka, generate_token\n\n# Create a pandas dataframe.\ndf = pd.DataFrame(\n    [[1, 2, "+"],\n     [3, 4, "-"]],\n    index=["row 1", "row 2"],\n    columns=["col 1", "col 2", "class"],\n)\nprint(df.head())\n"""\n       col 1  col 2 class\nrow 1      1      2     +\nrow 2      3      4     -\n"""\n```\n\n```python3\n\n# Login.\ntoken = generate_token("http://localhost:5000")\nclient = Oka(token, "http://localhost:5000")\n\n# Store.\nid = client.send(df)\n\n# Store again.\nid = client.send(df)\n"""\nContent already stored for id f7_6b9deafec2562edde56bfdc573b336b55cb16\n"""\n\n# Fetch.\ndf = client.get(id)\n\nprint(df.head())\n"""\n       col 1  col 2 class\nrow 1      1      2     +\nrow 2      3      4     -\n"""\n```\n\n\n\n\n\n\n**Machine Learning workflow**\n<details>\n<p>\n\n```python3\n\nfrom sklearn.ensemble import RandomForestClassifier as RF\n\nfrom idict import let, idict\nfrom idict.function.classification import fit, predict\nfrom idict.function.evaluation import split\n\ncache = {}\nd = (\n        idict.fromtoy()\n        >> split\n        >> let(fit, algorithm=RF, config={"n_estimators": 55}, Xin="Xtr", yin="ytr")\n        >> let(predict, Xin="Xts")\n        >> (lambda X: {"X2": X * X})\n        >> [cache]\n)\nprint(d.y)\n"""\n[0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1]\n"""\n```\n\n```python3\n\nd.show()\n"""\n{\n    "X2": "→(↑ X)",\n    "z": "→(↑ input Xin yout version Xts→(input config X y) model→(algorithm config Xin yin output version Xtr→(input config X y) ytr→(input config X y)))",\n    "_history": "split----------------------sklearn-1.0.1 fit--------------------------------idict predict----------------------------idict",\n    "model": "→(↑ algorithm config Xin yin output version Xtr→(input config X y) ytr→(input config X y))",\n    "Xtr": "→(↑ input config X y)",\n    "ytr": "→(↑ input config X y)",\n    "Xts": "→(↑ input config X y)",\n    "yts": "→(↑ input config X y)",\n    "X": "«{\'attr1\': {0: 5.1, 1: 1.1, 2: 6.1, 3: 1.1, 4: 3.1, 5: 4.7, 6: 9.1, 7: 8.3, 8: 9.1, 9: 2.5, 10: 7.1, 11: 0.1, 12: 2.1, 13: 0.1, 14: 5.1, 15: 31.1, 16: 1.1, 17: 2.2, 18: 3.1, 19: 1.1}, \'attr2\': {0: 6.4, 1: 2.5, 2: 3.6, 3: 3.5, 4: 2.5, 5: 4.9, 6: 3.5, 7: 2.9, 8: 7.2, 9: 4.5, 10: 6.6, 11: 4.3, 12: 0.1, 13: 4.0, 14: 4.5, 15: 4.7, 16: 3.2, 17: 8.5, 18: 2.5, 19: 8.5}}»",\n    "y": "«[0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1]»",\n    "_id": "\x1b[38;5;121m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mX\x1b[0m\x1b[38;5;187m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;151m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;192m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;114m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;84m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;187m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;151m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;192m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mx\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;114m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;84m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;187m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;151m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;192m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mE\x1b[0m",\n    "_ids": {\n        "X2": "\x1b[38;5;209m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;210m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mZ\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;209m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mp\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;210m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;209m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mQ\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;210m\x1b[1m\x1b[48;5;0md\x1b[0m",\n        "z": "\x1b[38;5;61m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mD\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mh\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mX\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mT\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mU\x1b[0m",\n        "_history": "\x1b[38;5;87m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mE\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;153m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;194m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;158m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;116m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mp\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mZ\x1b[0m\x1b[38;5;153m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;194m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;158m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;116m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m-\x1b[0m",\n        "model": "\x1b[38;5;97m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mx\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mh\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mQ\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mh\x1b[0m",\n        "Xtr": "\x1b[38;5;69m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mE\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mX\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;80m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0mP\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mD\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;80m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m2\x1b[0m",\n        "ytr": "\x1b[38;5;240m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0mT\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mG\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;131m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;95m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;240m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;131m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;95m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;240m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m3\x1b[0m",\n        "Xts": "\x1b[38;5;138m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mZ\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;175m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;205m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;175m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;205m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m4\x1b[0m",\n        "yts": "\x1b[38;5;77m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;149m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;78m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;77m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mQ\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;149m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;78m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;77m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;149m\x1b[1m\x1b[48;5;0m5\x1b[0m",\n        "X": "\x1b[38;5;97m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0m_\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;248m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;248m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;248m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0me\x1b[0m (content: 34_1738c83af436029507def2710bc5125f58d0e)",\n        "y": "\x1b[38;5;99m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m_\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mc\x1b[0m (content: S0_b6360d62ccafa275d4051dfd02b939104feac)"\n    }\n}\n"""\n```\n\n```python3\n\nprint(d.z)\n"""\n[1 0 1 0 1 1 1]\n"""\n```\n\n```python3\n\nd.show()\n"""\n{\n    "X2": "→(↑ X)",\n    "z": "«[1 0 1 0 1 1 1]»",\n    "_history": "split----------------------sklearn-1.0.1 fit--------------------------------idict predict----------------------------idict",\n    "model": "RandomForestClassifier(n_estimators=55)",\n    "Xtr": "→(↑ input config X y)",\n    "ytr": "→(↑ input config X y)",\n    "Xts": "«{\'attr1\': {13: 0.1, 6: 9.1, 9: 2.5, 10: 7.1, 0: 5.1, 14: 5.1, 15: 31.1}, \'attr2\': {13: 4.0, 6: 3.5, 9: 4.5, 10: 6.6, 0: 6.4, 14: 4.5, 15: 4.7}}»",\n    "yts": "→(↑ input config X y)",\n    "X": "«{\'attr1\': {0: 5.1, 1: 1.1, 2: 6.1, 3: 1.1, 4: 3.1, 5: 4.7, 6: 9.1, 7: 8.3, 8: 9.1, 9: 2.5, 10: 7.1, 11: 0.1, 12: 2.1, 13: 0.1, 14: 5.1, 15: 31.1, 16: 1.1, 17: 2.2, 18: 3.1, 19: 1.1}, \'attr2\': {0: 6.4, 1: 2.5, 2: 3.6, 3: 3.5, 4: 2.5, 5: 4.9, 6: 3.5, 7: 2.9, 8: 7.2, 9: 4.5, 10: 6.6, 11: 4.3, 12: 0.1, 13: 4.0, 14: 4.5, 15: 4.7, 16: 3.2, 17: 8.5, 18: 2.5, 19: 8.5}}»",\n    "y": "«[0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1]»",\n    "_id": "\x1b[38;5;121m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mX\x1b[0m\x1b[38;5;187m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;151m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;192m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;114m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;84m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;187m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;151m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;192m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mx\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;114m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;84m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;187m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;151m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;192m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mE\x1b[0m",\n    "_ids": {\n        "X2": "\x1b[38;5;209m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;210m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mZ\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;209m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mp\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;210m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;209m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;203m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0mQ\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;167m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;210m\x1b[1m\x1b[48;5;0md\x1b[0m",\n        "z": "\x1b[38;5;61m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mD\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mh\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mX\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mT\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mU\x1b[0m",\n        "_history": "\x1b[38;5;87m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mE\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;153m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;194m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;158m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;116m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mp\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mZ\x1b[0m\x1b[38;5;153m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;194m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;158m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;116m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m-\x1b[0m",\n        "model": "\x1b[38;5;97m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mx\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mh\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mQ\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mh\x1b[0m",\n        "Xtr": "\x1b[38;5;69m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mE\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mX\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;80m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0mP\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mD\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;80m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m2\x1b[0m",\n        "ytr": "\x1b[38;5;240m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0mT\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mG\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;131m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;95m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;240m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;131m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;95m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;240m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m3\x1b[0m",\n        "Xts": "\x1b[38;5;138m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mZ\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;175m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;205m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;175m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;205m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m4\x1b[0m",\n        "yts": "\x1b[38;5;77m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;149m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;78m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;77m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mQ\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;149m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;78m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;77m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;149m\x1b[1m\x1b[48;5;0m5\x1b[0m",\n        "X": "\x1b[38;5;97m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0m_\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;248m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;248m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;248m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0me\x1b[0m (content: 34_1738c83af436029507def2710bc5125f58d0e)",\n        "y": "\x1b[38;5;99m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m_\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mc\x1b[0m (content: S0_b6360d62ccafa275d4051dfd02b939104feac)"\n    }\n}\n"""\n```\n\n```python3\n\n# A field \'_\' means this function is a noop process triggered only once by accessing one of the other provided fields."\nd >>= (lambda _, X2, y: print("Some logging/printing that doesn\'t affect data... X²=\\n", X2[:3]))\nd.show()\n"""\n{\n    "X2": "→(X2→(↑ X) y _)",\n    "y": "→(X2→(↑ X) y _)",\n    "z": "«[1 0 1 0 1 1 1]»",\n    "_history": "split----------------------sklearn-1.0.1 fit--------------------------------idict predict----------------------------idict",\n    "model": "RandomForestClassifier(n_estimators=55)",\n    "Xtr": "→(↑ input config X y)",\n    "ytr": "→(↑ input config X y)",\n    "Xts": "«{\'attr1\': {13: 0.1, 6: 9.1, 9: 2.5, 10: 7.1, 0: 5.1, 14: 5.1, 15: 31.1}, \'attr2\': {13: 4.0, 6: 3.5, 9: 4.5, 10: 6.6, 0: 6.4, 14: 4.5, 15: 4.7}}»",\n    "yts": "→(↑ input config X y)",\n    "X": "«{\'attr1\': {0: 5.1, 1: 1.1, 2: 6.1, 3: 1.1, 4: 3.1, 5: 4.7, 6: 9.1, 7: 8.3, 8: 9.1, 9: 2.5, 10: 7.1, 11: 0.1, 12: 2.1, 13: 0.1, 14: 5.1, 15: 31.1, 16: 1.1, 17: 2.2, 18: 3.1, 19: 1.1}, \'attr2\': {0: 6.4, 1: 2.5, 2: 3.6, 3: 3.5, 4: 2.5, 5: 4.9, 6: 3.5, 7: 2.9, 8: 7.2, 9: 4.5, 10: 6.6, 11: 4.3, 12: 0.1, 13: 4.0, 14: 4.5, 15: 4.7, 16: 3.2, 17: 8.5, 18: 2.5, 19: 8.5}}»",\n    "_id": "\x1b[38;5;121m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mX\x1b[0m\x1b[38;5;187m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;151m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;192m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;114m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;84m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;187m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;151m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;192m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mx\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;114m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;84m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;187m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;151m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;192m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mE\x1b[0m",\n    "_ids": {\n        "X2": "\x1b[38;5;104m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0mP\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;73m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mp\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mp\x1b[0m\x1b[38;5;67m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0mG\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;73m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0mx\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;67m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mQ\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0me\x1b[0m",\n        "y": "\x1b[38;5;87m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mE\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;153m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;194m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;158m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;116m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mp\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mZ\x1b[0m\x1b[38;5;153m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;194m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;158m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;116m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m-\x1b[0m",\n        "z": "\x1b[38;5;61m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mD\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mh\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mX\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mT\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mU\x1b[0m",\n        "_history": "\x1b[38;5;87m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mE\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;153m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;194m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;158m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;116m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mp\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mZ\x1b[0m\x1b[38;5;153m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;194m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;158m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;116m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m-\x1b[0m",\n        "model": "\x1b[38;5;97m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mx\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mh\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mQ\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mh\x1b[0m",\n        "Xtr": "\x1b[38;5;69m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mE\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mX\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;80m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0mP\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mD\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;80m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m2\x1b[0m",\n        "ytr": "\x1b[38;5;240m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0mT\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mG\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;131m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;95m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;240m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;131m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;95m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;240m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m3\x1b[0m",\n        "Xts": "\x1b[38;5;138m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mZ\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;175m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;205m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;175m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;205m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m4\x1b[0m",\n        "yts": "\x1b[38;5;77m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;149m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;78m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;77m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mQ\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;149m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;78m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;77m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;149m\x1b[1m\x1b[48;5;0m5\x1b[0m",\n        "X": "\x1b[38;5;97m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0m_\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;248m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;248m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;248m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0me\x1b[0m (content: 34_1738c83af436029507def2710bc5125f58d0e)"\n    }\n}\n"""\n```\n\n```python3\n\nprint("Triggering noop function by accessing \'y\'...")\nprint("y", d.y[:3])\n"""\nTriggering noop function by accessing \'y\'...\nSome logging/printing that doesn\'t affect data... X²=\n    attr1  attr2\n0  26.01  40.96\n1   1.21   6.25\n2  37.21  12.96\ny [0 1 0]\n"""\n```\n\n```python3\n\nd.show()\n"""\n{\n    "X2": "     attr1  attr2\\n0    26.01  40.96\\n1     1.21   6.25\\n2    37.21  12.96\\n3     1.21  12.25\\n4     9.61   6.25\\n5    22.09  24.01\\n6    82.81  12.25\\n7    68.89   8.41\\n8    82.81  51.84\\n9     6.25  20.25\\n10   50.41  43.56\\n11    0.01  18.49\\n12    4.41   0.01\\n13    0.01  16.00\\n14   26.01  20.25\\n15  967.21  22.09\\n16    1.21  10.24\\n17    4.84  72.25\\n18    9.61   6.25\\n19    1.21  72.25",\n    "y": "«[0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1]»",\n    "z": "«[1 0 1 0 1 1 1]»",\n    "_history": "split----------------------sklearn-1.0.1 fit--------------------------------idict predict----------------------------idict",\n    "model": "RandomForestClassifier(n_estimators=55)",\n    "Xtr": "→(↑ input config X y)",\n    "ytr": "→(↑ input config X y)",\n    "Xts": "«{\'attr1\': {13: 0.1, 6: 9.1, 9: 2.5, 10: 7.1, 0: 5.1, 14: 5.1, 15: 31.1}, \'attr2\': {13: 4.0, 6: 3.5, 9: 4.5, 10: 6.6, 0: 6.4, 14: 4.5, 15: 4.7}}»",\n    "yts": "→(↑ input config X y)",\n    "X": "«{\'attr1\': {0: 5.1, 1: 1.1, 2: 6.1, 3: 1.1, 4: 3.1, 5: 4.7, 6: 9.1, 7: 8.3, 8: 9.1, 9: 2.5, 10: 7.1, 11: 0.1, 12: 2.1, 13: 0.1, 14: 5.1, 15: 31.1, 16: 1.1, 17: 2.2, 18: 3.1, 19: 1.1}, \'attr2\': {0: 6.4, 1: 2.5, 2: 3.6, 3: 3.5, 4: 2.5, 5: 4.9, 6: 3.5, 7: 2.9, 8: 7.2, 9: 4.5, 10: 6.6, 11: 4.3, 12: 0.1, 13: 4.0, 14: 4.5, 15: 4.7, 16: 3.2, 17: 8.5, 18: 2.5, 19: 8.5}}»",\n    "_id": "\x1b[38;5;121m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mX\x1b[0m\x1b[38;5;187m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;151m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;192m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;114m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;84m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;187m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;151m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;192m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mx\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;114m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;84m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;150m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;187m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;151m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;192m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mE\x1b[0m",\n    "_ids": {\n        "X2": "\x1b[38;5;104m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0mP\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;73m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mp\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mp\x1b[0m\x1b[38;5;67m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0mG\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;73m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0mx\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;67m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mQ\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0me\x1b[0m",\n        "y": "\x1b[38;5;87m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mE\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;153m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;194m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;158m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;116m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mp\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mZ\x1b[0m\x1b[38;5;153m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;194m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;158m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;116m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m-\x1b[0m",\n        "z": "\x1b[38;5;61m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mD\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mh\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mX\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0mT\x1b[0m\x1b[38;5;141m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;62m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;99m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;63m\x1b[1m\x1b[48;5;0mz\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mU\x1b[0m",\n        "_history": "\x1b[38;5;87m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mE\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mS\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;153m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;194m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;158m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;116m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mp\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mF\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0mZ\x1b[0m\x1b[38;5;153m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;194m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;158m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;121m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;116m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;159m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;122m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m-\x1b[0m",\n        "model": "\x1b[38;5;97m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mN\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mx\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mh\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mQ\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mg\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mh\x1b[0m",\n        "Xtr": "\x1b[38;5;69m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mE\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mW\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mX\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;80m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0mP\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mD\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;111m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;87m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;123m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;80m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;69m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0mj\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;117m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;110m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;74m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;75m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;81m\x1b[1m\x1b[48;5;0m2\x1b[0m",\n        "ytr": "\x1b[38;5;240m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mu\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0mT\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mG\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m9\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mq\x1b[0m\x1b[38;5;131m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;95m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;240m\x1b[1m\x1b[48;5;0mR\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mA\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mU\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mo\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;131m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;95m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;240m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;96m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m3\x1b[0m",\n        "Xts": "\x1b[38;5;138m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mZ\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;175m\x1b[1m\x1b[48;5;0mB\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0my\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;205m\x1b[1m\x1b[48;5;0mJ\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mV\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0mv\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0mI\x1b[0m\x1b[38;5;133m\x1b[1m\x1b[48;5;0mL\x1b[0m\x1b[38;5;103m\x1b[1m\x1b[48;5;0mY\x1b[0m\x1b[38;5;175m\x1b[1m\x1b[48;5;0mO\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;205m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;140m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;180m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;132m\x1b[1m\x1b[48;5;0m4\x1b[0m",\n        "yts": "\x1b[38;5;77m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mw\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;149m\x1b[1m\x1b[48;5;0mm\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;78m\x1b[1m\x1b[48;5;0mH\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0mM\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0mK\x1b[0m\x1b[38;5;77m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mQ\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0mC\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0mi\x1b[0m\x1b[38;5;149m\x1b[1m\x1b[48;5;0mb\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0ms\x1b[0m\x1b[38;5;78m\x1b[1m\x1b[48;5;0m4\x1b[0m\x1b[38;5;120m\x1b[1m\x1b[48;5;0mt\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0mk\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0ml\x1b[0m\x1b[38;5;107m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;71m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;77m\x1b[1m\x1b[48;5;0mr\x1b[0m\x1b[38;5;119m\x1b[1m\x1b[48;5;0mn\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;155m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;143m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;83m\x1b[1m\x1b[48;5;0m.\x1b[0m\x1b[38;5;149m\x1b[1m\x1b[48;5;0m5\x1b[0m",\n        "X": "\x1b[38;5;97m\x1b[1m\x1b[48;5;0m-\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0m_\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m3\x1b[0m\x1b[38;5;248m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;248m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0me\x1b[0m\x1b[38;5;139m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;134m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;105m\x1b[1m\x1b[48;5;0m6\x1b[0m\x1b[38;5;138m\x1b[1m\x1b[48;5;0mf\x1b[0m\x1b[38;5;169m\x1b[1m\x1b[48;5;0ma\x1b[0m\x1b[38;5;60m\x1b[1m\x1b[48;5;0mc\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;61m\x1b[1m\x1b[48;5;0m1\x1b[0m\x1b[38;5;97m\x1b[1m\x1b[48;5;0m2\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;104m\x1b[1m\x1b[48;5;0m5\x1b[0m\x1b[38;5;135m\x1b[1m\x1b[48;5;0m7\x1b[0m\x1b[38;5;248m\x1b[1m\x1b[48;5;0m8\x1b[0m\x1b[38;5;168m\x1b[1m\x1b[48;5;0md\x1b[0m\x1b[38;5;98m\x1b[1m\x1b[48;5;0m0\x1b[0m\x1b[38;5;68m\x1b[1m\x1b[48;5;0me\x1b[0m (content: 34_1738c83af436029507def2710bc5125f58d0e)"\n    }\n}\n"""\n```\n\n```python3\n\n# The same workflow will not be processed again if the same cache is used.\nd = (\n        idict.fromtoy()\n        >> split\n        >> let(fit, algorithm=RF, config={"n_estimators": 55}, Xin="Xtr", yin="ytr")\n        >> let(predict, Xin="Xts")\n        >> (lambda X: {"X2": X * X})\n        >> (lambda _, X2, y: print("Some logging/printing that doesn\'t affect data...", X2.head()))\n        >> [cache]\n)\nprint(d.z)\n"""\n[1 0 1 0 1 1 1]\n"""\n```\n\n\n</p>\n</details>\n\n\n\n\n\n\n\n## More info\nAside from the papers on [identification](https://arxiv.org/abs/2109.06028)\nand on [similarity (not ready yet)](https://), the [PyPI package](https://pypi.org/project/oka) \nand [GitHub repository](https://github.com/davips/rabizao/oka), \n<!-- one can find more information, at a higher level application perspective,  -->\nA lower level perspective is provided in the [API documentation](https://rabizao.github.io/oka).\n\n\n\n## Grants\nThis work was supported by Fapesp under supervision of\nProf. André C. P. L. F. de Carvalho at CEPID-CeMEAI (Grants 2013/07375-0 – 2019/01735-0).\n\n.>>>>>>>>> outros <<<<<<<<<<<.\n',
    'author': 'Rafael Bizao',
    'author_email': 'rabizao@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
