# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DomainMappingMetadataArgs',
    'DomainMappingSpecArgs',
    'DomainMappingStatusArgs',
    'DomainMappingStatusConditionArgs',
    'DomainMappingStatusResourceRecordArgs',
    'IamBindingConditionArgs',
    'IamMemberConditionArgs',
    'ServiceMetadataArgs',
    'ServiceStatusArgs',
    'ServiceStatusConditionArgs',
    'ServiceTemplateArgs',
    'ServiceTemplateMetadataArgs',
    'ServiceTemplateSpecArgs',
    'ServiceTemplateSpecContainerArgs',
    'ServiceTemplateSpecContainerEnvArgs',
    'ServiceTemplateSpecContainerEnvFromArgs',
    'ServiceTemplateSpecContainerEnvFromConfigMapRefArgs',
    'ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceArgs',
    'ServiceTemplateSpecContainerEnvFromSecretRefArgs',
    'ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceArgs',
    'ServiceTemplateSpecContainerEnvValueFromArgs',
    'ServiceTemplateSpecContainerEnvValueFromSecretKeyRefArgs',
    'ServiceTemplateSpecContainerPortArgs',
    'ServiceTemplateSpecContainerResourcesArgs',
    'ServiceTemplateSpecContainerVolumeMountArgs',
    'ServiceTemplateSpecVolumeArgs',
    'ServiceTemplateSpecVolumeSecretArgs',
    'ServiceTemplateSpecVolumeSecretItemArgs',
    'ServiceTrafficArgs',
]

@pulumi.input_type
class DomainMappingMetadataArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 generation: Optional[pulumi.Input[int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resource_version: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] namespace: In Cloud Run the namespace must be equal to either the
               project ID or project number.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations is a key value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata. More
               info: http://kubernetes.io/docs/user-guide/annotations
               **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
               If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
               or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
        :param pulumi.Input[int] generation: -
               A sequence number representing a specific generation of the desired state.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize
               (scope and select) objects. May match selectors of replication controllers
               and routes.
               More info: http://kubernetes.io/docs/user-guide/labels
        :param pulumi.Input[str] resource_version: -
               An opaque value that represents the internal version of this object that
               can be used by clients to determine when objects have changed. May be used
               for optimistic concurrency, change detection, and the watch operation on a
               resource or set of resources. They may only be valid for a
               particular resource or set of resources.
               More info:
               https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        :param pulumi.Input[str] self_link: -
               SelfLink is a URL representing this object.
        :param pulumi.Input[str] uid: -
               UID is a unique id generated by the server on successful creation of a resource and is not
               allowed to change on PUT operations.
               More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        pulumi.set(__self__, "namespace", namespace)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        In Cloud Run the namespace must be equal to either the
        project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations is a key value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata. More
        info: http://kubernetes.io/docs/user-guide/annotations
        **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
        If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
        or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[int]]:
        """
        -
        A sequence number representing a specific generation of the desired state.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize
        (scope and select) objects. May match selectors of replication controllers
        and routes.
        More info: http://kubernetes.io/docs/user-guide/labels
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[str]]:
        """
        -
        An opaque value that represents the internal version of this object that
        can be used by clients to determine when objects have changed. May be used
        for optimistic concurrency, change detection, and the watch operation on a
        resource or set of resources. They may only be valid for a
        particular resource or set of resources.
        More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_version", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        -
        SelfLink is a URL representing this object.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        -
        UID is a unique id generated by the server on successful creation of a resource and is not
        allowed to change on PUT operations.
        More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class DomainMappingSpecArgs:
    def __init__(__self__, *,
                 route_name: pulumi.Input[str],
                 certificate_mode: Optional[pulumi.Input[str]] = None,
                 force_override: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] route_name: The name of the Cloud Run Service that this DomainMapping applies to.
               The route must exist.
        :param pulumi.Input[str] certificate_mode: The mode of the certificate.
               Default value is `AUTOMATIC`.
               Possible values are `NONE` and `AUTOMATIC`.
        :param pulumi.Input[bool] force_override: If set, the mapping will override any mapping set before this spec was set.
               It is recommended that the user leaves this empty to receive an error
               warning about a potential conflict and only set it once the respective UI
               has given such a warning.
        """
        pulumi.set(__self__, "route_name", route_name)
        if certificate_mode is not None:
            pulumi.set(__self__, "certificate_mode", certificate_mode)
        if force_override is not None:
            pulumi.set(__self__, "force_override", force_override)

    @property
    @pulumi.getter(name="routeName")
    def route_name(self) -> pulumi.Input[str]:
        """
        The name of the Cloud Run Service that this DomainMapping applies to.
        The route must exist.
        """
        return pulumi.get(self, "route_name")

    @route_name.setter
    def route_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "route_name", value)

    @property
    @pulumi.getter(name="certificateMode")
    def certificate_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mode of the certificate.
        Default value is `AUTOMATIC`.
        Possible values are `NONE` and `AUTOMATIC`.
        """
        return pulumi.get(self, "certificate_mode")

    @certificate_mode.setter
    def certificate_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_mode", value)

    @property
    @pulumi.getter(name="forceOverride")
    def force_override(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, the mapping will override any mapping set before this spec was set.
        It is recommended that the user leaves this empty to receive an error
        warning about a potential conflict and only set it once the respective UI
        has given such a warning.
        """
        return pulumi.get(self, "force_override")

    @force_override.setter
    def force_override(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_override", value)


@pulumi.input_type
class DomainMappingStatusArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingStatusConditionArgs']]]] = None,
                 mapped_route_name: Optional[pulumi.Input[str]] = None,
                 observed_generation: Optional[pulumi.Input[int]] = None,
                 resource_records: Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingStatusResourceRecordArgs']]]] = None):
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if mapped_route_name is not None:
            pulumi.set(__self__, "mapped_route_name", mapped_route_name)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if resource_records is not None:
            pulumi.set(__self__, "resource_records", resource_records)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingStatusConditionArgs']]]]:
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingStatusConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="mappedRouteName")
    def mapped_route_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "mapped_route_name")

    @mapped_route_name.setter
    def mapped_route_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mapped_route_name", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter(name="resourceRecords")
    def resource_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingStatusResourceRecordArgs']]]]:
        return pulumi.get(self, "resource_records")

    @resource_records.setter
    def resource_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingStatusResourceRecordArgs']]]]):
        pulumi.set(self, "resource_records", value)


@pulumi.input_type
class DomainMappingStatusConditionArgs:
    def __init__(__self__, *,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DomainMappingStatusResourceRecordArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 rrdata: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rrdata is not None:
            pulumi.set(__self__, "rrdata", rrdata)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rrdata(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "rrdata")

    @rrdata.setter
    def rrdata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rrdata", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class IamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class IamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ServiceMetadataArgs:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 generation: Optional[pulumi.Input[int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 resource_version: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations is a key value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata. More
               info: http://kubernetes.io/docs/user-guide/annotations
               **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
               If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
               or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
               Cloud Run (fully managed) uses the following annotation keys to configure features on a Service:
               - `run.googleapis.com/ingress` sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
               for the Service. For example, `"run.googleapis.com/ingress" = "all"`.
        :param pulumi.Input[int] generation: -
               A sequence number representing a specific generation of the desired state.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize
               (scope and select) objects. May match selectors of replication controllers
               and routes.
               More info: http://kubernetes.io/docs/user-guide/labels
        :param pulumi.Input[str] namespace: In Cloud Run the namespace must be equal to either the
               project ID or project number.
        :param pulumi.Input[str] resource_version: -
               An opaque value that represents the internal version of this object that
               can be used by clients to determine when objects have changed. May be used
               for optimistic concurrency, change detection, and the watch operation on a
               resource or set of resources. They may only be valid for a
               particular resource or set of resources.
               More info:
               https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        :param pulumi.Input[str] self_link: -
               SelfLink is a URL representing this object.
        :param pulumi.Input[str] uid: -
               UID is a unique id generated by the server on successful creation of a resource and is not
               allowed to change on PUT operations.
               More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations is a key value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata. More
        info: http://kubernetes.io/docs/user-guide/annotations
        **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
        If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
        or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
        Cloud Run (fully managed) uses the following annotation keys to configure features on a Service:
        - `run.googleapis.com/ingress` sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
        for the Service. For example, `"run.googleapis.com/ingress" = "all"`.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[int]]:
        """
        -
        A sequence number representing a specific generation of the desired state.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize
        (scope and select) objects. May match selectors of replication controllers
        and routes.
        More info: http://kubernetes.io/docs/user-guide/labels
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        In Cloud Run the namespace must be equal to either the
        project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[str]]:
        """
        -
        An opaque value that represents the internal version of this object that
        can be used by clients to determine when objects have changed. May be used
        for optimistic concurrency, change detection, and the watch operation on a
        resource or set of resources. They may only be valid for a
        particular resource or set of resources.
        More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_version", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        -
        SelfLink is a URL representing this object.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        -
        UID is a unique id generated by the server on successful creation of a resource and is not
        allowed to change on PUT operations.
        More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ServiceStatusArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceStatusConditionArgs']]]] = None,
                 latest_created_revision_name: Optional[pulumi.Input[str]] = None,
                 latest_ready_revision_name: Optional[pulumi.Input[str]] = None,
                 observed_generation: Optional[pulumi.Input[int]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if latest_created_revision_name is not None:
            pulumi.set(__self__, "latest_created_revision_name", latest_created_revision_name)
        if latest_ready_revision_name is not None:
            pulumi.set(__self__, "latest_ready_revision_name", latest_ready_revision_name)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceStatusConditionArgs']]]]:
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceStatusConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="latestCreatedRevisionName")
    def latest_created_revision_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "latest_created_revision_name")

    @latest_created_revision_name.setter
    def latest_created_revision_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latest_created_revision_name", value)

    @property
    @pulumi.getter(name="latestReadyRevisionName")
    def latest_ready_revision_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "latest_ready_revision_name")

    @latest_ready_revision_name.setter
    def latest_ready_revision_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latest_ready_revision_name", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class ServiceStatusConditionArgs:
    def __init__(__self__, *,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServiceTemplateArgs:
    def __init__(__self__, *,
                 metadata: Optional[pulumi.Input['ServiceTemplateMetadataArgs']] = None,
                 spec: Optional[pulumi.Input['ServiceTemplateSpecArgs']] = None):
        """
        :param pulumi.Input['ServiceTemplateMetadataArgs'] metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.
               Structure is documented below.
        :param pulumi.Input['ServiceTemplateSpecArgs'] spec: RevisionSpec holds the desired state of the Revision (from the client).
               Structure is documented below.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['ServiceTemplateMetadataArgs']]:
        """
        Metadata associated with this Service, including name, namespace, labels,
        and annotations.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['ServiceTemplateMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['ServiceTemplateSpecArgs']]:
        """
        RevisionSpec holds the desired state of the Revision (from the client).
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['ServiceTemplateSpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class ServiceTemplateMetadataArgs:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 generation: Optional[pulumi.Input[int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 resource_version: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations is a key value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata. More
               info: http://kubernetes.io/docs/user-guide/annotations
               **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
               If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
               or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
               Cloud Run (fully managed) uses the following annotation keys to configure features on a Service:
               - `run.googleapis.com/ingress` sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
               for the Service. For example, `"run.googleapis.com/ingress" = "all"`.
        :param pulumi.Input[int] generation: -
               A sequence number representing a specific generation of the desired state.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize
               (scope and select) objects. May match selectors of replication controllers
               and routes.
               More info: http://kubernetes.io/docs/user-guide/labels
        :param pulumi.Input[str] name: Volume's name.
        :param pulumi.Input[str] namespace: In Cloud Run the namespace must be equal to either the
               project ID or project number.
        :param pulumi.Input[str] resource_version: -
               An opaque value that represents the internal version of this object that
               can be used by clients to determine when objects have changed. May be used
               for optimistic concurrency, change detection, and the watch operation on a
               resource or set of resources. They may only be valid for a
               particular resource or set of resources.
               More info:
               https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        :param pulumi.Input[str] self_link: -
               SelfLink is a URL representing this object.
        :param pulumi.Input[str] uid: -
               UID is a unique id generated by the server on successful creation of a resource and is not
               allowed to change on PUT operations.
               More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations is a key value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata. More
        info: http://kubernetes.io/docs/user-guide/annotations
        **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
        If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
        or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
        Cloud Run (fully managed) uses the following annotation keys to configure features on a Service:
        - `run.googleapis.com/ingress` sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
        for the Service. For example, `"run.googleapis.com/ingress" = "all"`.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[int]]:
        """
        -
        A sequence number representing a specific generation of the desired state.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize
        (scope and select) objects. May match selectors of replication controllers
        and routes.
        More info: http://kubernetes.io/docs/user-guide/labels
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        In Cloud Run the namespace must be equal to either the
        project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[str]]:
        """
        -
        An opaque value that represents the internal version of this object that
        can be used by clients to determine when objects have changed. May be used
        for optimistic concurrency, change detection, and the watch operation on a
        resource or set of resources. They may only be valid for a
        particular resource or set of resources.
        More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_version", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        -
        SelfLink is a URL representing this object.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        -
        UID is a unique id generated by the server on successful creation of a resource and is not
        allowed to change on PUT operations.
        More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ServiceTemplateSpecArgs:
    def __init__(__self__, *,
                 container_concurrency: Optional[pulumi.Input[int]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerArgs']]]] = None,
                 service_account_name: Optional[pulumi.Input[str]] = None,
                 serving_state: Optional[pulumi.Input[str]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecVolumeArgs']]]] = None):
        """
        :param pulumi.Input[int] container_concurrency: ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
               requests per container of the Revision. Values are:
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerArgs']]] containers: Container defines the unit of execution for this Revision.
               In the context of a Revision, we disallow a number of the fields of
               this Container, including: name, ports, and volumeMounts.
               The runtime contract is documented here:
               https://github.com/knative/serving/blob/master/docs/runtime-contract.md
               Structure is documented below.
        :param pulumi.Input[str] service_account_name: Email address of the IAM service account associated with the revision of the
               service. The service account represents the identity of the running revision,
               and determines what permissions the revision has. If not provided, the revision
               will use the project's default service account.
        :param pulumi.Input[str] serving_state: -
               ServingState holds a value describing the state the resources
               are in for this Revision.
               It is expected
               that the system will manipulate this based on routability and load.
        :param pulumi.Input[int] timeout_seconds: TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecVolumeArgs']]] volumes: Volume represents a named volume in a container.
               Structure is documented below.
        """
        if container_concurrency is not None:
            pulumi.set(__self__, "container_concurrency", container_concurrency)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if serving_state is not None:
            warnings.warn("""Not supported by Cloud Run fully managed""", DeprecationWarning)
            pulumi.log.warn("""serving_state is deprecated: Not supported by Cloud Run fully managed""")
        if serving_state is not None:
            pulumi.set(__self__, "serving_state", serving_state)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="containerConcurrency")
    def container_concurrency(self) -> Optional[pulumi.Input[int]]:
        """
        ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
        requests per container of the Revision. Values are:
        """
        return pulumi.get(self, "container_concurrency")

    @container_concurrency.setter
    def container_concurrency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_concurrency", value)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerArgs']]]]:
        """
        Container defines the unit of execution for this Revision.
        In the context of a Revision, we disallow a number of the fields of
        this Container, including: name, ports, and volumeMounts.
        The runtime contract is documented here:
        https://github.com/knative/serving/blob/master/docs/runtime-contract.md
        Structure is documented below.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Email address of the IAM service account associated with the revision of the
        service. The service account represents the identity of the running revision,
        and determines what permissions the revision has. If not provided, the revision
        will use the project's default service account.
        """
        return pulumi.get(self, "service_account_name")

    @service_account_name.setter
    def service_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_name", value)

    @property
    @pulumi.getter(name="servingState")
    def serving_state(self) -> Optional[pulumi.Input[str]]:
        """
        -
        ServingState holds a value describing the state the resources
        are in for this Revision.
        It is expected
        that the system will manipulate this based on routability and load.
        """
        return pulumi.get(self, "serving_state")

    @serving_state.setter
    def serving_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serving_state", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecVolumeArgs']]]]:
        """
        Volume represents a named volume in a container.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class ServiceTemplateSpecContainerArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 env_froms: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerEnvFromArgs']]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerEnvArgs']]]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerPortArgs']]]] = None,
                 resources: Optional[pulumi.Input['ServiceTemplateSpecContainerResourcesArgs']] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerVolumeMountArgs']]]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] image: Docker image name. This is most often a reference to a container located
               in the container registry, such as gcr.io/cloudrun/hello
               More info: https://kubernetes.io/docs/concepts/containers/images
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Arguments to the entrypoint.
               The docker image's CMD is used if this is not provided.
               Variable references $(VAR_NAME) are expanded using the container's
               environment. If a variable cannot be resolved, the reference in the input
               string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
               double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
               regardless of whether the variable exists or not.
               More info:
               https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Entrypoint array. Not executed within a shell.
               The docker image's ENTRYPOINT is used if this is not provided.
               Variable references $(VAR_NAME) are expanded using the container's
               environment. If a variable cannot be resolved, the reference in the input
               string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
               double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
               regardless of whether the variable exists or not.
               More info:
               https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerEnvFromArgs']]] env_froms: -
               (Optional, Deprecated)
               List of sources to populate environment variables in the container.
               All invalid keys will be reported as an event when the container is starting.
               When a key exists in multiple sources, the value associated with the last source will
               take precedence. Values defined by an Env with a duplicate key will take
               precedence.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerEnvArgs']]] envs: List of environment variables to set in the container.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerPortArgs']]] ports: List of open ports in the container.
               More Info:
               https://cloud.google.com/run/docs/reference/rest/v1/RevisionSpec#ContainerPort
               Structure is documented below.
        :param pulumi.Input['ServiceTemplateSpecContainerResourcesArgs'] resources: Compute Resources required by this container. Used to set values such as max memory
               More info:
               https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#requests-and-limits
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerVolumeMountArgs']]] volume_mounts: Volume to mount into the container's filesystem.
               Only supports SecretVolumeSources.
               Structure is documented below.
        :param pulumi.Input[str] working_dir: -
               (Optional, Deprecated)
               Container's working directory.
               If not specified, the container runtime's default will be used, which
               might be configured in the container image.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if env_froms is not None:
            warnings.warn("""Not supported by Cloud Run fully managed""", DeprecationWarning)
            pulumi.log.warn("""env_froms is deprecated: Not supported by Cloud Run fully managed""")
        if env_froms is not None:
            pulumi.set(__self__, "env_froms", env_froms)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            warnings.warn("""Not supported by Cloud Run fully managed""", DeprecationWarning)
            pulumi.log.warn("""working_dir is deprecated: Not supported by Cloud Run fully managed""")
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        Docker image name. This is most often a reference to a container located
        in the container registry, such as gcr.io/cloudrun/hello
        More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Arguments to the entrypoint.
        The docker image's CMD is used if this is not provided.
        Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
        double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
        regardless of whether the variable exists or not.
        More info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Entrypoint array. Not executed within a shell.
        The docker image's ENTRYPOINT is used if this is not provided.
        Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
        double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
        regardless of whether the variable exists or not.
        More info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter(name="envFroms")
    def env_froms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerEnvFromArgs']]]]:
        """
        -
        (Optional, Deprecated)
        List of sources to populate environment variables in the container.
        All invalid keys will be reported as an event when the container is starting.
        When a key exists in multiple sources, the value associated with the last source will
        take precedence. Values defined by an Env with a duplicate key will take
        precedence.
        Structure is documented below.
        """
        return pulumi.get(self, "env_froms")

    @env_froms.setter
    def env_froms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerEnvFromArgs']]]]):
        pulumi.set(self, "env_froms", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerEnvArgs']]]]:
        """
        List of environment variables to set in the container.
        Structure is documented below.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerPortArgs']]]]:
        """
        List of open ports in the container.
        More Info:
        https://cloud.google.com/run/docs/reference/rest/v1/RevisionSpec#ContainerPort
        Structure is documented below.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['ServiceTemplateSpecContainerResourcesArgs']]:
        """
        Compute Resources required by this container. Used to set values such as max memory
        More info:
        https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#requests-and-limits
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['ServiceTemplateSpecContainerResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerVolumeMountArgs']]]]:
        """
        Volume to mount into the container's filesystem.
        Only supports SecretVolumeSources.
        Structure is documented below.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        -
        (Optional, Deprecated)
        Container's working directory.
        If not specified, the container runtime's default will be used, which
        might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class ServiceTemplateSpecContainerEnvArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 value_from: Optional[pulumi.Input['ServiceTemplateSpecContainerEnvValueFromArgs']] = None):
        """
        :param pulumi.Input[str] name: Volume's name.
        :param pulumi.Input[str] value: Variable references $(VAR_NAME) are expanded
               using the previous defined environment variables in the container and
               any route environment variables. If a variable cannot be resolved,
               the reference in the input string will be unchanged. The $(VAR_NAME)
               syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
               references will never be expanded, regardless of whether the variable
               exists or not.
               Defaults to "".
        :param pulumi.Input['ServiceTemplateSpecContainerEnvValueFromArgs'] value_from: Source for the environment variable's value. Only supports secret_key_ref.
               Structure is documented below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_from is not None:
            pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Variable references $(VAR_NAME) are expanded
        using the previous defined environment variables in the container and
        any route environment variables. If a variable cannot be resolved,
        the reference in the input string will be unchanged. The $(VAR_NAME)
        syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
        references will never be expanded, regardless of whether the variable
        exists or not.
        Defaults to "".
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> Optional[pulumi.Input['ServiceTemplateSpecContainerEnvValueFromArgs']]:
        """
        Source for the environment variable's value. Only supports secret_key_ref.
        Structure is documented below.
        """
        return pulumi.get(self, "value_from")

    @value_from.setter
    def value_from(self, value: Optional[pulumi.Input['ServiceTemplateSpecContainerEnvValueFromArgs']]):
        pulumi.set(self, "value_from", value)


@pulumi.input_type
class ServiceTemplateSpecContainerEnvFromArgs:
    def __init__(__self__, *,
                 config_map_ref: Optional[pulumi.Input['ServiceTemplateSpecContainerEnvFromConfigMapRefArgs']] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 secret_ref: Optional[pulumi.Input['ServiceTemplateSpecContainerEnvFromSecretRefArgs']] = None):
        """
        :param pulumi.Input['ServiceTemplateSpecContainerEnvFromConfigMapRefArgs'] config_map_ref: The ConfigMap to select from.
               Structure is documented below.
        :param pulumi.Input[str] prefix: An optional identifier to prepend to each key in the ConfigMap.
        :param pulumi.Input['ServiceTemplateSpecContainerEnvFromSecretRefArgs'] secret_ref: The Secret to select from.
               Structure is documented below.
        """
        if config_map_ref is not None:
            pulumi.set(__self__, "config_map_ref", config_map_ref)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter(name="configMapRef")
    def config_map_ref(self) -> Optional[pulumi.Input['ServiceTemplateSpecContainerEnvFromConfigMapRefArgs']]:
        """
        The ConfigMap to select from.
        Structure is documented below.
        """
        return pulumi.get(self, "config_map_ref")

    @config_map_ref.setter
    def config_map_ref(self, value: Optional[pulumi.Input['ServiceTemplateSpecContainerEnvFromConfigMapRefArgs']]):
        pulumi.set(self, "config_map_ref", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        An optional identifier to prepend to each key in the ConfigMap.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['ServiceTemplateSpecContainerEnvFromSecretRefArgs']]:
        """
        The Secret to select from.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['ServiceTemplateSpecContainerEnvFromSecretRefArgs']]):
        pulumi.set(self, "secret_ref", value)


@pulumi.input_type
class ServiceTemplateSpecContainerEnvFromConfigMapRefArgs:
    def __init__(__self__, *,
                 local_object_reference: Optional[pulumi.Input['ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceArgs']] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceArgs'] local_object_reference: The Secret to select from.
               Structure is documented below.
        :param pulumi.Input[bool] optional: Specify whether the Secret must be defined
        """
        if local_object_reference is not None:
            pulumi.set(__self__, "local_object_reference", local_object_reference)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> Optional[pulumi.Input['ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceArgs']]:
        """
        The Secret to select from.
        Structure is documented below.
        """
        return pulumi.get(self, "local_object_reference")

    @local_object_reference.setter
    def local_object_reference(self, value: Optional[pulumi.Input['ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceArgs']]):
        pulumi.set(self, "local_object_reference", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether the Secret must be defined
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Volume's name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ServiceTemplateSpecContainerEnvFromSecretRefArgs:
    def __init__(__self__, *,
                 local_object_reference: Optional[pulumi.Input['ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceArgs']] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceArgs'] local_object_reference: The Secret to select from.
               Structure is documented below.
        :param pulumi.Input[bool] optional: Specify whether the Secret must be defined
        """
        if local_object_reference is not None:
            pulumi.set(__self__, "local_object_reference", local_object_reference)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> Optional[pulumi.Input['ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceArgs']]:
        """
        The Secret to select from.
        Structure is documented below.
        """
        return pulumi.get(self, "local_object_reference")

    @local_object_reference.setter
    def local_object_reference(self, value: Optional[pulumi.Input['ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceArgs']]):
        pulumi.set(self, "local_object_reference", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether the Secret must be defined
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Volume's name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ServiceTemplateSpecContainerEnvValueFromArgs:
    def __init__(__self__, *,
                 secret_key_ref: pulumi.Input['ServiceTemplateSpecContainerEnvValueFromSecretKeyRefArgs']):
        """
        :param pulumi.Input['ServiceTemplateSpecContainerEnvValueFromSecretKeyRefArgs'] secret_key_ref: Selects a key (version) of a secret in Secret Manager.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> pulumi.Input['ServiceTemplateSpecContainerEnvValueFromSecretKeyRefArgs']:
        """
        Selects a key (version) of a secret in Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_key_ref")

    @secret_key_ref.setter
    def secret_key_ref(self, value: pulumi.Input['ServiceTemplateSpecContainerEnvValueFromSecretKeyRefArgs']):
        pulumi.set(self, "secret_key_ref", value)


@pulumi.input_type
class ServiceTemplateSpecContainerEnvValueFromSecretKeyRefArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The Cloud Secret Manager secret version.
               Can be 'latest' for the latest value or an integer for a specific version.
        :param pulumi.Input[str] name: Volume's name.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The Cloud Secret Manager secret version.
        Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ServiceTemplateSpecContainerPortArgs:
    def __init__(__self__, *,
                 container_port: pulumi.Input[int],
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] container_port: Port number.
        :param pulumi.Input[str] name: Volume's name.
        :param pulumi.Input[str] protocol: Protocol used on port. Defaults to TCP.
        """
        pulumi.set(__self__, "container_port", container_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> pulumi.Input[int]:
        """
        Port number.
        """
        return pulumi.get(self, "container_port")

    @container_port.setter
    def container_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "container_port", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol used on port. Defaults to TCP.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class ServiceTemplateSpecContainerResourcesArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 requests: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] limits: Limits describes the maximum amount of compute resources allowed.
               The values of the map is string form of the 'quantity' k8s type:
               https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] requests: Requests describes the minimum amount of compute resources required.
               If Requests is omitted for a container, it defaults to Limits if that is
               explicitly specified, otherwise to an implementation-defined value.
               The values of the map is string form of the 'quantity' k8s type:
               https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Limits describes the maximum amount of compute resources allowed.
        The values of the map is string form of the 'quantity' k8s type:
        https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Requests describes the minimum amount of compute resources required.
        If Requests is omitted for a container, it defaults to Limits if that is
        explicitly specified, otherwise to an implementation-defined value.
        The values of the map is string form of the 'quantity' k8s type:
        https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "requests", value)


@pulumi.input_type
class ServiceTemplateSpecContainerVolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] mount_path: Path within the container at which the volume should be mounted.  Must
               not contain ':'.
        :param pulumi.Input[str] name: Volume's name.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> pulumi.Input[str]:
        """
        Path within the container at which the volume should be mounted.  Must
        not contain ':'.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ServiceTemplateSpecVolumeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 secret: pulumi.Input['ServiceTemplateSpecVolumeSecretArgs']):
        """
        :param pulumi.Input[str] name: Volume's name.
        :param pulumi.Input['ServiceTemplateSpecVolumeSecretArgs'] secret: The secret's value will be presented as the content of a file whose
               name is defined in the item path. If no items are defined, the name of
               the file is the secret_name.
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input['ServiceTemplateSpecVolumeSecretArgs']:
        """
        The secret's value will be presented as the content of a file whose
        name is defined in the item path. If no items are defined, the name of
        the file is the secret_name.
        Structure is documented below.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input['ServiceTemplateSpecVolumeSecretArgs']):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class ServiceTemplateSpecVolumeSecretArgs:
    def __init__(__self__, *,
                 secret_name: pulumi.Input[str],
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecVolumeSecretItemArgs']]]] = None):
        """
        :param pulumi.Input[str] secret_name: The name of the secret in Cloud Secret Manager. By default, the secret
               is assumed to be in the same project.
               If the secret is in another project, you must define an alias.
               An alias definition has the form:
               <alias>:projects/<project-id|project-number>/secrets/<secret-name>.
               If multiple alias definitions are needed, they must be separated by
               commas.
               The alias definitions must be set on the run.googleapis.com/secrets
               annotation.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecVolumeSecretItemArgs']]] items: If unspecified, the volume will expose a file whose name is the
               secret_name.
               If specified, the key will be used as the version to fetch from Cloud
               Secret Manager and the path will be the name of the file exposed in the
               volume. When items are defined, they must specify a key and a path.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[str]:
        """
        The name of the secret in Cloud Secret Manager. By default, the secret
        is assumed to be in the same project.
        If the secret is in another project, you must define an alias.
        An alias definition has the form:
        <alias>:projects/<project-id|project-number>/secrets/<secret-name>.
        If multiple alias definitions are needed, they must be separated by
        commas.
        The alias definitions must be set on the run.googleapis.com/secrets
        annotation.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_name", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecVolumeSecretItemArgs']]]]:
        """
        If unspecified, the volume will expose a file whose name is the
        secret_name.
        If specified, the key will be used as the version to fetch from Cloud
        Secret Manager and the path will be the name of the file exposed in the
        volume. When items are defined, they must specify a key and a path.
        Structure is documented below.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateSpecVolumeSecretItemArgs']]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class ServiceTemplateSpecVolumeSecretItemArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 path: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The Cloud Secret Manager secret version.
               Can be 'latest' for the latest value or an integer for a specific version.
        :param pulumi.Input[str] path: The relative path of the file to map the key to.
               May not be an absolute path.
               May not contain the path element '..'.
               May not start with the string '..'.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The Cloud Secret Manager secret version.
        Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The relative path of the file to map the key to.
        May not be an absolute path.
        May not contain the path element '..'.
        May not start with the string '..'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class ServiceTrafficArgs:
    def __init__(__self__, *,
                 percent: pulumi.Input[int],
                 latest_revision: Optional[pulumi.Input[bool]] = None,
                 revision_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] percent: Percent specifies percent of the traffic to this Revision or Configuration.
        :param pulumi.Input[bool] latest_revision: LatestRevision may be optionally provided to indicate that the latest ready
               Revision of the Configuration should be used for this traffic target. When
               provided LatestRevision must be true if RevisionName is empty; it must be
               false when RevisionName is non-empty.
        :param pulumi.Input[str] revision_name: RevisionName of a specific revision to which to send this portion of traffic.
        """
        pulumi.set(__self__, "percent", percent)
        if latest_revision is not None:
            pulumi.set(__self__, "latest_revision", latest_revision)
        if revision_name is not None:
            pulumi.set(__self__, "revision_name", revision_name)

    @property
    @pulumi.getter
    def percent(self) -> pulumi.Input[int]:
        """
        Percent specifies percent of the traffic to this Revision or Configuration.
        """
        return pulumi.get(self, "percent")

    @percent.setter
    def percent(self, value: pulumi.Input[int]):
        pulumi.set(self, "percent", value)

    @property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> Optional[pulumi.Input[bool]]:
        """
        LatestRevision may be optionally provided to indicate that the latest ready
        Revision of the Configuration should be used for this traffic target. When
        provided LatestRevision must be true if RevisionName is empty; it must be
        false when RevisionName is non-empty.
        """
        return pulumi.get(self, "latest_revision")

    @latest_revision.setter
    def latest_revision(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "latest_revision", value)

    @property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> Optional[pulumi.Input[str]]:
        """
        RevisionName of a specific revision to which to send this portion of traffic.
        """
        return pulumi.get(self, "revision_name")

    @revision_name.setter
    def revision_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_name", value)


