import * as eks from '@aws-cdk/aws-eks';
import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Properties for calling a EKS endpoint with EksCall.
 *
 * @stability stable
 */
export interface EksCallProps extends sfn.TaskStateBaseProps {
    /**
     * The EKS cluster.
     *
     * @stability stable
     */
    readonly cluster: eks.ICluster;
    /**
     * HTTP method ("GET", "POST", "PUT", ...) part of HTTP request.
     *
     * @stability stable
     */
    readonly httpMethod: HttpMethods;
    /**
     * HTTP path of the Kubernetes REST API operation For example: /api/v1/namespaces/default/pods.
     *
     * @stability stable
     */
    readonly httpPath: string;
    /**
     * Query Parameters part of HTTP request.
     *
     * @default - no query parameters
     * @stability stable
     */
    readonly queryParameters?: {
        [key: string]: string[];
    };
    /**
     * Request body part of HTTP request.
     *
     * @default - No request body
     * @stability stable
     */
    readonly requestBody?: sfn.TaskInput;
}
/**
 * Call a EKS endpoint as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-eks.html
 * @stability stable
 */
export declare class EksCall extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * No policies are required due to eks:call is an Http service integration and does not call and EKS API directly.
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-eks.html#connect-eks-permissions
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    private readonly clusterEndpoint;
    private readonly clusterCertificateAuthorityData;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: EksCallProps);
    /**
     * Provides the EKS Call service integration task configuration
     * @internal
     */
    protected _renderTask(): any;
}
/**
 * Method type of a EKS call.
 *
 * @stability stable
 */
export declare enum HttpMethods {
    /**
     * Retrieve data from a server at the specified resource.
     *
     * @stability stable
     */
    GET = "GET",
    /**
     * Send data to the API endpoint to create or update a resource.
     *
     * @stability stable
     */
    POST = "POST",
    /**
     * Send data to the API endpoint to update or create a resource.
     *
     * @stability stable
     */
    PUT = "PUT",
    /**
     * Delete the resource at the specified endpoint.
     *
     * @stability stable
     */
    DELETE = "DELETE",
    /**
     * Apply partial modifications to the resource.
     *
     * @stability stable
     */
    PATCH = "PATCH",
    /**
     * Retrieve data from a server at the specified resource without the response body.
     *
     * @stability stable
     */
    HEAD = "HEAD"
}
