import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Properties for StartExecution.
 *
 * @stability stable
 */
export interface StepFunctionsStartExecutionProps extends sfn.TaskStateBaseProps {
    /**
     * The Step Functions state machine to start the execution on.
     *
     * @stability stable
     */
    readonly stateMachine: sfn.IStateMachine;
    /**
     * The JSON input for the execution, same as that of StartExecution.
     *
     * @default - The state input (JSON path '$')
     * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
     * @stability stable
     */
    readonly input?: sfn.TaskInput;
    /**
     * The name of the execution, same as that of StartExecution.
     *
     * @default - None
     * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
     * @stability stable
     */
    readonly name?: string;
    /**
     * Pass the execution ID from the context object to the execution input.
     *
     * This allows the Step Functions UI to link child executions from parent executions, making it easier to trace execution flow across state machines.
     *
     * If you set this property to `true`, the `input` property must be an object (provided by `sfn.TaskInput.fromObject`) or omitted entirely.
     *
     * @default - false
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid
     * @stability stable
     */
    readonly associateWithParent?: boolean;
}
/**
 * A Step Functions Task to call StartExecution on another state machine.
 *
 * It supports three service integration patterns: REQUEST_RESPONSE, RUN_JOB, and WAIT_FOR_TASK_TOKEN.
 *
 * @stability stable
 */
export declare class StepFunctionsStartExecution extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: StepFunctionsStartExecutionProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
    /**
     * As StateMachineArn is extracted automatically from the state machine object included in the constructor,
     *
     * the scoped access policy should be generated accordingly.
     *
     * This means the action of StartExecution should be restricted on the given state machine, instead of being granted to all the resources (*).
     */
    private createScopedAccessPolicy;
}
